/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import org.infinispan.persistence.jdbc.configuration.TableManipulationConfiguration;
import org.jboss.as.clustering.controller.AddStepHandler;
import org.jboss.as.clustering.controller.AddStepHandlerDescriptor;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.RemoveStepHandler;
import org.jboss.as.clustering.controller.RemoveStepHandlerDescriptor;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.clustering.controller.SimpleAliasEntry;
import org.jboss.as.clustering.controller.SimpleResourceServiceHandler;
import org.jboss.as.clustering.infinispan.subsystem.BinaryKeyedJDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.BinaryTableBuilderFactory;
import org.jboss.as.clustering.infinispan.subsystem.BinaryTableResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanResourceDescriptionResolver;
import org.jboss.as.clustering.infinispan.subsystem.JDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.MixedKeyedJDBCStoreBuilderFactory;
import org.jboss.as.clustering.infinispan.subsystem.StoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StringKeyedJDBCStoreResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.StringTableBuilderFactory;
import org.jboss.as.clustering.infinispan.subsystem.StringTableResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class MixedKeyedJDBCStoreResourceDefinition
extends JDBCStoreResourceDefinition {
    static final PathElement LEGACY_PATH = PathElement.pathElement((String)"mixed-keyed-jdbc-store", (String)"MIXED_KEYED_JDBC_STORE");
    static final PathElement PATH = MixedKeyedJDBCStoreResourceDefinition.pathElement("mixed-jdbc");

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        ResourceTransformationDescriptionBuilder builder = InfinispanModel.VERSION_4_0_0.requiresTransformation(version) ? parent.addChildRedirection(PATH, LEGACY_PATH) : parent.addChildResource(PATH);
        JDBCStoreResourceDefinition.buildTransformation(version, builder);
        BinaryTableResourceDefinition.buildTransformation(version, builder);
        StringTableResourceDefinition.buildTransformation(version, builder);
    }

    MixedKeyedJDBCStoreResourceDefinition(boolean allowRuntimeOnlyRegistration) {
        super(PATH, new InfinispanResourceDescriptionResolver(PATH, MixedKeyedJDBCStoreResourceDefinition.pathElement("jdbc"), WILDCARD_PATH), allowRuntimeOnlyRegistration);
    }

    @Override
    public void register(ManagementResourceRegistration parentRegistration) {
        final ManagementResourceRegistration registration = parentRegistration.registerSubModel((ResourceDefinition)this);
        parentRegistration.registerAlias(LEGACY_PATH, (AliasEntry)new SimpleAliasEntry(registration));
        ResourceDescriptor descriptor = new ResourceDescriptor(this.getResourceDescriptionResolver()).addAttributes(JDBCStoreResourceDefinition.Attribute.class).addAttributes(StoreResourceDefinition.Attribute.class).addExtraParameters(DeprecatedAttribute.class);
        SimpleResourceServiceHandler handler = new SimpleResourceServiceHandler((ResourceServiceBuilderFactory)new MixedKeyedJDBCStoreBuilderFactory());
        new AddStepHandler((AddStepHandlerDescriptor)descriptor, (ResourceServiceHandler)handler){

            public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
                super.execute(context, operation);
                this.addTableStep(context, operation, DeprecatedAttribute.BINARY_TABLE, BinaryTableResourceDefinition.PATH, new BinaryTableBuilderFactory());
                this.addTableStep(context, operation, DeprecatedAttribute.STRING_TABLE, StringTableResourceDefinition.PATH, new StringTableBuilderFactory());
            }

            private void addTableStep(OperationContext context, ModelNode operation, DeprecatedAttribute attribute, PathElement path, ResourceServiceBuilderFactory<TableManipulationConfiguration> provider) {
                if (operation.hasDefined(attribute.getDefinition().getName())) {
                    ModelNode addTableOperation = Util.createAddOperation((PathAddress)context.getCurrentAddress().append(new PathElement[]{path}));
                    ModelNode parameters = operation.get(attribute.getDefinition().getName());
                    for (Property parameter : parameters.asPropertyList()) {
                        addTableOperation.get(parameter.getName()).set(parameter.getValue());
                    }
                    context.addStep(addTableOperation, registration.getOperationHandler(PathAddress.pathAddress((PathElement[])new PathElement[]{path}), "add"), context.getCurrentStage());
                }
            }
        }.register(registration);
        new RemoveStepHandler((RemoveStepHandlerDescriptor)descriptor, (ResourceServiceHandler)handler).register(registration);
        registration.registerReadWriteAttribute(DeprecatedAttribute.BINARY_TABLE.getDefinition(), BinaryKeyedJDBCStoreResourceDefinition.LEGACY_READ_TABLE_HANDLER, BinaryKeyedJDBCStoreResourceDefinition.LEGACY_WRITE_TABLE_HANDLER);
        registration.registerReadWriteAttribute(DeprecatedAttribute.STRING_TABLE.getDefinition(), StringKeyedJDBCStoreResourceDefinition.LEGACY_READ_TABLE_HANDLER, StringKeyedJDBCStoreResourceDefinition.LEGACY_WRITE_TABLE_HANDLER);
        new BinaryTableResourceDefinition().register(registration);
        new StringTableResourceDefinition().register(registration);
        super.register(registration);
    }

    @Deprecated
    static enum DeprecatedAttribute implements Attribute
    {
        BINARY_TABLE(BinaryKeyedJDBCStoreResourceDefinition.DeprecatedAttribute.TABLE),
        STRING_TABLE(StringKeyedJDBCStoreResourceDefinition.DeprecatedAttribute.TABLE);

        private final AttributeDefinition definition;

        private DeprecatedAttribute(Attribute attribute) {
            this.definition = (AttributeDefinition)attribute.getDefinition();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

