/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.protocol.proton.converter.jms;

import javax.jms.JMSException;
import javax.jms.TextMessage;
import org.apache.activemq.artemis.api.core.ActiveMQBuffer;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.message.impl.MessageInternal;
import org.apache.activemq.artemis.core.protocol.proton.converter.jms.ServerJMSMessage;
import org.apache.activemq.artemis.reader.TextMessageUtil;

public class ServerJMSTextMessage
extends ServerJMSMessage
implements TextMessage {
    public static final byte TYPE = 3;
    private SimpleString text;

    public ServerJMSTextMessage(MessageInternal message, int deliveryCount) {
        super(message, deliveryCount);
    }

    public void setText(String text) throws JMSException {
        this.text = text != null ? new SimpleString(text) : null;
        TextMessageUtil.writeBodyText((ActiveMQBuffer)this.getWriteBodyBuffer(), (SimpleString)this.text);
    }

    public String getText() {
        if (this.text != null) {
            return this.text.toString();
        }
        return null;
    }

    @Override
    public void clearBody() throws JMSException {
        super.clearBody();
        this.text = null;
    }

    @Override
    public void encode() throws Exception {
        super.encode();
        TextMessageUtil.writeBodyText((ActiveMQBuffer)this.getWriteBodyBuffer(), (SimpleString)this.text);
    }

    @Override
    public void decode() throws Exception {
        super.decode();
        this.text = TextMessageUtil.readBodyText((ActiveMQBuffer)this.getReadBodyBuffer());
    }
}

