/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.pojo.descriptor;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Set;
import org.jboss.as.pojo.BeanState;
import org.jboss.as.pojo.descriptor.BeanMetaDataConfig;
import org.jboss.as.pojo.descriptor.ConfigVisitor;
import org.jboss.as.pojo.descriptor.ValueConfig;
import org.jboss.as.pojo.logging.PojoLogger;
import org.jboss.as.pojo.service.BeanInfo;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.value.InjectedValue;

public class InjectedValueConfig
extends ValueConfig {
    private static final long serialVersionUID = 1L;
    private String bean;
    private BeanState state;
    private String service;
    private String property;
    private final transient InjectedValue<BeanInfo> beanInfo = new InjectedValue();
    private final transient InjectedValue<Object> value = new InjectedValue();

    @Override
    protected Object getClassValue(Class<?> type) {
        Object result = this.value.getValue();
        if (result instanceof Set) {
            Set set = (Set)result;
            if (set.size() != 1) {
                throw PojoLogger.ROOT_LOGGER.invalidMatchSize(set, type);
            }
            result = set.iterator().next();
        }
        if (this.property != null) {
            Method getter = this.getBeanInfo(result).getGetter(this.property, type);
            try {
                return getter.invoke(result, new Object[0]);
            }
            catch (IllegalAccessException e) {
                throw new IllegalArgumentException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalArgumentException(e);
            }
        }
        return result;
    }

    protected BeanInfo getBeanInfo(Object bean) {
        BeanInfo bi = (BeanInfo)this.beanInfo.getOptionalValue();
        if (bi == null) {
            bi = InjectedValueConfig.getTempBeanInfo(bean.getClass());
        }
        return bi;
    }

    @Override
    public void visit(ConfigVisitor visitor) {
        if (this.bean != null) {
            visitor.addDependency(this.bean, BeanState.DESCRIBED, (Injector)this.beanInfo);
            ServiceName name = BeanMetaDataConfig.toBeanName(this.bean, this.state);
            visitor.addDependency(name, (Injector)this.value);
        } else if (this.service != null) {
            visitor.addDependency(ServiceName.parse((String)this.service), (Injector)this.value);
        } else {
            Class<?> type = InjectedValueConfig.getType(visitor, this.getType());
            if (type == null) {
                type = this.getType(visitor, this);
            }
            if (type == null) {
                throw PojoLogger.ROOT_LOGGER.cannotDetermineInjectedType(this.toString());
            }
            ServiceName instancesName = BeanMetaDataConfig.toInstancesName(type, this.state);
            visitor.addDependency(instancesName, (Injector)this.value);
        }
    }

    public void setBean(String dependency) {
        this.bean = dependency;
    }

    public void setState(BeanState state) {
        this.state = state;
    }

    public void setService(String service) {
        this.service = service;
    }

    public void setProperty(String property) {
        this.property = property;
    }
}

