/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.bindings.wildfly.idp;

import io.undertow.security.api.AuthenticationMechanism;
import io.undertow.security.api.AuthenticationMechanismFactory;
import io.undertow.server.handlers.form.FormParserFactory;
import io.undertow.servlet.ServletExtension;
import io.undertow.servlet.api.DeploymentInfo;
import io.undertow.servlet.api.FilterInfo;
import java.util.Map;
import javax.servlet.DispatcherType;
import javax.servlet.ServletContext;
import org.picketlink.common.PicketLinkLogger;
import org.picketlink.common.PicketLinkLoggerFactory;
import org.picketlink.common.exceptions.ConfigurationException;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.config.federation.IDPType;
import org.picketlink.config.federation.PicketLinkType;
import org.picketlink.config.federation.ProviderType;
import org.picketlink.identity.federation.bindings.wildfly.idp.IDPAuthenticationMechanism;
import org.picketlink.identity.federation.bindings.wildfly.idp.UndertowRoleGenerator;
import org.picketlink.identity.federation.core.audit.PicketLinkAuditHelper;
import org.picketlink.identity.federation.core.impl.EmptyAttributeManager;
import org.picketlink.identity.federation.web.filters.IDPFilter;
import org.picketlink.identity.federation.web.util.ConfigurationUtil;
import org.picketlink.identity.federation.web.util.SAMLConfigurationProvider;

public class IDPServletExtension
implements ServletExtension {
    private static final PicketLinkLogger LOGGER = PicketLinkLoggerFactory.getLogger();
    private final SAMLConfigurationProvider configurationProvider;
    private final PicketLinkAuditHelper auditHelper;

    public IDPServletExtension(SAMLConfigurationProvider configurationProvider, PicketLinkAuditHelper auditHelper) {
        this.configurationProvider = configurationProvider;
        this.auditHelper = auditHelper;
    }

    public IDPServletExtension() {
        this(null, null);
    }

    public void handleDeployment(DeploymentInfo deploymentInfo, final ServletContext servletContext) {
        LOGGER.debug("Processing PicketLink Extension [" + this.getClass() + "].");
        try {
            final PicketLinkType picketLinkConfiguration = this.getConfiguration(servletContext);
            if (picketLinkConfiguration == null) {
                LOGGER.debug("No configuration found for deployment [" + deploymentInfo.getDeploymentName() + "].");
                return;
            }
            ProviderType providerType = picketLinkConfiguration.getIdpOrSP();
            if (IDPType.class.isInstance(providerType)) {
                LOGGER.debug("Configuring deployment [" + deploymentInfo.getDeploymentName() + "] as a SAML Identity Provider.");
                deploymentInfo.addAuthenticationMechanism("FORM", new AuthenticationMechanismFactory(){

                    public AuthenticationMechanism create(String mechanismName, FormParserFactory formParserFactory, Map<String, String> properties) {
                        String loginPage = properties.get("login_page");
                        String errorPage = properties.get("error_page");
                        PicketLinkAuditHelper auditHelper = IDPServletExtension.this.getAuditHelper(picketLinkConfiguration, servletContext);
                        return new IDPAuthenticationMechanism(formParserFactory, mechanismName, loginPage, errorPage, picketLinkConfiguration, auditHelper);
                    }
                });
                IDPType idpType = (IDPType)providerType;
                if (!idpType.hasAttributeManager()) {
                    idpType.setAttributeManager(EmptyAttributeManager.class.getName());
                }
                if (!idpType.hasRoleGenerator()) {
                    idpType.setRoleGenerator(UndertowRoleGenerator.class.getName());
                }
                servletContext.setAttribute("CONFIGURATION", (Object)picketLinkConfiguration);
                servletContext.setAttribute("CONFIG_PROVIDER", (Object)this.configurationProvider);
                servletContext.setAttribute("AUDIT_HELPER", (Object)this.auditHelper);
                this.configureFilterIfNecessary(deploymentInfo);
            }
        }
        catch (ProcessingException e) {
            throw new RuntimeException("Error configuring PicketLink SAML extension [" + this.getClass() + "] to deployment [" + deploymentInfo.getDeploymentName() + "].", e);
        }
        catch (ConfigurationException e) {
            throw new RuntimeException("Could not load PicketLink configuration for deployment [" + deploymentInfo.getDeploymentName() + "].", e);
        }
    }

    private PicketLinkType getConfiguration(ServletContext servletContext) throws ProcessingException, ConfigurationException {
        SAMLConfigurationProvider configurationProvider = this.getConfigurationProvider(servletContext);
        if (configurationProvider != null) {
            return configurationProvider.getPicketLinkConfiguration();
        }
        return ConfigurationUtil.getConfiguration((ServletContext)servletContext);
    }

    private void configureFilterIfNecessary(DeploymentInfo deploymentInfo) {
        if (!this.hasFilter(deploymentInfo)) {
            LOGGER.debug("Enabling SAML IDPFilter for deployment [" + deploymentInfo.getDeploymentName() + "].");
            String filterName = IDPFilter.class.getSimpleName();
            deploymentInfo.addFilter(new FilterInfo(filterName, IDPFilter.class));
            deploymentInfo.addFilterUrlMapping(filterName, "/*", DispatcherType.REQUEST);
        }
    }

    private boolean hasFilter(DeploymentInfo deploymentInfo) {
        Map filters = deploymentInfo.getFilters();
        for (FilterInfo filterInfo : filters.values()) {
            if (!IDPFilter.class.isAssignableFrom(filterInfo.getFilterClass())) continue;
            return true;
        }
        return false;
    }

    private SAMLConfigurationProvider getConfigurationProvider(ServletContext servletContext) {
        if (this.configurationProvider == null) {
            return ConfigurationUtil.getConfigurationProvider((ServletContext)servletContext);
        }
        return this.configurationProvider;
    }

    private PicketLinkAuditHelper getAuditHelper(PicketLinkType picketLinkConfiguration, ServletContext servletContext) {
        if (picketLinkConfiguration.isEnableAudit() && this.auditHelper == null) {
            return ConfigurationUtil.getAuditHelper((ServletContext)servletContext);
        }
        return this.auditHelper;
    }
}

