/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts;

import java.net.URL;
import java.util.List;
import java.util.Properties;
import java.util.logging.Logger;
import javax.security.auth.callback.CallbackHandler;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.resource.ResourceManager;
import org.apache.cxf.rt.security.utils.SecurityUtils;
import org.apache.cxf.sts.IdentityMapper;
import org.apache.cxf.sts.RealmParser;
import org.apache.cxf.sts.STSPropertiesMBean;
import org.apache.cxf.sts.SignatureProperties;
import org.apache.cxf.sts.service.EncryptionProperties;
import org.apache.cxf.sts.token.realm.Relationship;
import org.apache.cxf.sts.token.realm.RelationshipResolver;
import org.apache.cxf.sts.token.realm.SAMLRealmCodec;
import org.apache.cxf.ws.security.sts.provider.STSException;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.dom.WSSConfig;

public class StaticSTSProperties
implements STSPropertiesMBean {
    private static final Logger LOG = LogUtils.getL7dLogger(StaticSTSProperties.class);
    private CallbackHandler callbackHandler;
    private String callbackHandlerClass;
    private Crypto signatureCrypto;
    private Object signatureCryptoProperties;
    private String signatureUsername;
    private Crypto encryptionCrypto;
    private Object encryptionCryptoProperties;
    private String encryptionUsername;
    private String issuer;
    private SignatureProperties signatureProperties = new SignatureProperties();
    private EncryptionProperties encryptionProperties = new EncryptionProperties();
    private RealmParser realmParser;
    private IdentityMapper identityMapper;
    private List<Relationship> relationships;
    private RelationshipResolver relationshipResolver;
    private SAMLRealmCodec samlRealmCodec;
    private Bus bus;
    private boolean validateUseKey = true;

    @Override
    public void configureProperties() throws STSException {
        URL url;
        ResourceManager resourceManager;
        if (this.signatureCrypto == null && this.signatureCryptoProperties != null) {
            resourceManager = this.getResourceManager();
            url = SecurityUtils.loadResource((ResourceManager)resourceManager, (Object)this.signatureCryptoProperties);
            Properties sigProperties = SecurityUtils.loadProperties((Object)url);
            if (sigProperties == null) {
                LOG.fine("Cannot load signature properties using: " + this.signatureCryptoProperties);
                throw new STSException("Configuration error: cannot load signature properties");
            }
            try {
                this.signatureCrypto = CryptoFactory.getInstance((Properties)sigProperties);
            }
            catch (WSSecurityException ex) {
                LOG.fine("Error in loading the signature Crypto object: " + ex.getMessage());
                throw new STSException(ex.getMessage());
            }
        }
        if (this.encryptionCrypto == null && this.encryptionCryptoProperties != null) {
            resourceManager = this.getResourceManager();
            url = SecurityUtils.loadResource((ResourceManager)resourceManager, (Object)this.encryptionCryptoProperties);
            Properties encrProperties = SecurityUtils.loadProperties((Object)url);
            if (encrProperties == null) {
                LOG.fine("Cannot load encryption properties using: " + this.encryptionCryptoProperties);
                throw new STSException("Configuration error: cannot load encryption properties");
            }
            try {
                this.encryptionCrypto = CryptoFactory.getInstance((Properties)encrProperties);
            }
            catch (WSSecurityException ex) {
                LOG.fine("Error in loading the encryption Crypto object: " + ex.getMessage());
                throw new STSException(ex.getMessage());
            }
        }
        if (this.callbackHandler == null && this.callbackHandlerClass != null) {
            try {
                this.callbackHandler = SecurityUtils.getCallbackHandler((Object)this.callbackHandlerClass);
                if (this.callbackHandler == null) {
                    LOG.fine("Cannot load CallbackHandler using: " + this.callbackHandlerClass);
                    throw new STSException("Configuration error: cannot load callback handler");
                }
            }
            catch (Exception ex) {
                LOG.fine("Error in loading the callback handler: " + ex.getMessage());
                throw new STSException(ex.getMessage());
            }
        }
        WSSConfig.init();
    }

    private ResourceManager getResourceManager() {
        Bus b = this.bus;
        if (b == null) {
            b = BusFactory.getThreadDefaultBus();
        }
        return (ResourceManager)b.getExtension(ResourceManager.class);
    }

    @Override
    public void setCallbackHandler(CallbackHandler callbackHandler) {
        this.callbackHandler = callbackHandler;
        LOG.fine("Setting callbackHandler: " + callbackHandler);
    }

    public void setCallbackHandlerClass(String callbackHandlerClass) {
        this.callbackHandlerClass = callbackHandlerClass;
        LOG.fine("Setting callbackHandlerClass: " + callbackHandlerClass);
    }

    @Override
    public CallbackHandler getCallbackHandler() {
        return this.callbackHandler;
    }

    @Override
    public void setSignatureCrypto(Crypto signatureCrypto) {
        this.signatureCrypto = signatureCrypto;
    }

    @Deprecated
    public void setSignaturePropertiesFile(String signaturePropertiesFile) {
        this.setSignatureCryptoProperties(signaturePropertiesFile);
    }

    public void setSignatureCryptoProperties(Object signatureCryptoProperties) {
        this.signatureCryptoProperties = signatureCryptoProperties;
        LOG.fine("Setting signature crypto properties: " + signatureCryptoProperties);
    }

    @Override
    public Crypto getSignatureCrypto() {
        return this.signatureCrypto;
    }

    @Override
    public void setSignatureUsername(String signatureUsername) {
        this.signatureUsername = signatureUsername;
        LOG.fine("Setting signatureUsername: " + signatureUsername);
    }

    @Override
    public String getSignatureUsername() {
        return this.signatureUsername;
    }

    @Override
    public void setEncryptionCrypto(Crypto encryptionCrypto) {
        this.encryptionCrypto = encryptionCrypto;
    }

    @Deprecated
    public void setEncryptionPropertiesFile(String encryptionPropertiesFile) {
        this.setEncryptionCryptoProperties(encryptionPropertiesFile);
    }

    public void setEncryptionCryptoProperties(Object encryptionCryptoProperties) {
        this.encryptionCryptoProperties = encryptionCryptoProperties;
        LOG.fine("Setting encryptionProperties: " + encryptionCryptoProperties);
    }

    @Override
    public Crypto getEncryptionCrypto() {
        return this.encryptionCrypto;
    }

    @Override
    public void setEncryptionUsername(String encryptionUsername) {
        this.encryptionUsername = encryptionUsername;
        LOG.fine("Setting encryptionUsername: " + encryptionUsername);
    }

    @Override
    public String getEncryptionUsername() {
        return this.encryptionUsername;
    }

    @Override
    public void setEncryptionProperties(EncryptionProperties encryptionProperties) {
        this.encryptionProperties = encryptionProperties;
    }

    @Override
    public EncryptionProperties getEncryptionProperties() {
        return this.encryptionProperties;
    }

    @Override
    public void setIssuer(String issuer) {
        this.issuer = issuer;
        LOG.fine("Setting issuer: " + issuer);
    }

    @Override
    public String getIssuer() {
        return this.issuer;
    }

    @Override
    public void setSignatureProperties(SignatureProperties signatureProperties) {
        this.signatureProperties = signatureProperties;
    }

    @Override
    public SignatureProperties getSignatureProperties() {
        return this.signatureProperties;
    }

    @Override
    public void setRealmParser(RealmParser realmParser) {
        this.realmParser = realmParser;
    }

    @Override
    public RealmParser getRealmParser() {
        return this.realmParser;
    }

    @Override
    public void setIdentityMapper(IdentityMapper identityMapper) {
        this.identityMapper = identityMapper;
    }

    @Override
    public IdentityMapper getIdentityMapper() {
        return this.identityMapper;
    }

    @Override
    public void setRelationships(List<Relationship> relationships) {
        this.relationships = relationships;
        this.relationshipResolver = new RelationshipResolver(this.relationships);
    }

    @Override
    public List<Relationship> getRelationships() {
        return this.relationships;
    }

    @Override
    public RelationshipResolver getRelationshipResolver() {
        return this.relationshipResolver;
    }

    @Override
    public SAMLRealmCodec getSamlRealmCodec() {
        return this.samlRealmCodec;
    }

    @Override
    public void setSamlRealmCodec(SAMLRealmCodec samlRealmCodec) {
        this.samlRealmCodec = samlRealmCodec;
    }

    public Bus getBus() {
        return this.bus;
    }

    public void setBus(Bus bus) {
        this.bus = bus;
    }

    @Override
    public boolean isValidateUseKey() {
        return this.validateUseKey;
    }

    @Override
    public void setValidateUseKey(boolean validateUseKey) {
        this.validateUseKey = validateUseKey;
    }
}

