/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.config.federation;

import org.picketlink.common.util.StringUtil;
import org.picketlink.config.federation.EncryptionType;
import org.picketlink.config.federation.ProviderType;

public class IDPType
extends ProviderType {
    protected EncryptionType encryption;
    protected String roleGenerator;
    protected String attributeManager;
    protected Boolean encrypt = Boolean.FALSE;
    protected String hostedURI;
    private boolean strictPostBinding = true;
    private boolean sslClientAuthentication = false;
    private String identityParticipantStack = null;

    public EncryptionType getEncryption() {
        return this.encryption;
    }

    public void setEncryption(EncryptionType value) {
        this.encryption = value;
    }

    public String getRoleGenerator() {
        if (!this.hasRoleGenerator()) {
            return "org.picketlink.identity.federation.bindings.tomcat.TomcatRoleGenerator";
        }
        return this.roleGenerator;
    }

    public boolean hasRoleGenerator() {
        return this.roleGenerator != null;
    }

    public void setRoleGenerator(String value) {
        this.roleGenerator = value;
    }

    public String getAttributeManager() {
        if (!this.hasAttributeManager()) {
            return "org.picketlink.identity.federation.bindings.tomcat.TomcatAttributeManager";
        }
        return this.attributeManager;
    }

    public boolean hasAttributeManager() {
        return this.attributeManager != null;
    }

    public void setAttributeManager(String value) {
        this.attributeManager = value;
    }

    public boolean isEncrypt() {
        if (this.encrypt == null) {
            return false;
        }
        return this.encrypt;
    }

    public void setEncrypt(Boolean value) {
        this.encrypt = value;
    }

    public String getHostedURI() {
        return this.hostedURI;
    }

    public void setHostedURI(String hostedURI) {
        this.hostedURI = hostedURI;
    }

    public void importFrom(IDPType other) {
        String hostedURI;
        super.importFrom(other);
        String attributeManager = other.getAttributeManager();
        if (StringUtil.isNotNull((String)attributeManager) && other.hasAttributeManager()) {
            this.setAttributeManager(attributeManager);
        }
        this.encrypt = other.isEncrypt();
        if (StringUtil.isNotNull((String)other.getRoleGenerator()) && other.hasRoleGenerator()) {
            this.setRoleGenerator(other.getRoleGenerator());
        }
        if (!StringUtil.isNullOrEmpty((String)(hostedURI = other.getHostedURI()))) {
            this.setHostedURI(hostedURI);
        }
    }

    public void setStrictPostBinding(boolean strictPostBinding) {
        this.strictPostBinding = strictPostBinding;
    }

    public boolean isStrictPostBinding() {
        return this.strictPostBinding;
    }

    public boolean isSSLClientAuthentication() {
        return this.sslClientAuthentication;
    }

    public void setSSLClientAuthentication(boolean sslClientAuthentication) {
        this.sslClientAuthentication = sslClientAuthentication;
    }

    public void setIdentityParticipantStack(String identityParticipantStack) {
        this.identityParticipantStack = identityParticipantStack;
    }

    public String getIdentityParticipantStack() {
        return this.identityParticipantStack;
    }
}

