/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.threads;

import java.math.BigDecimal;
import java.math.MathContext;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.as.threads.Attribute;
import org.jboss.as.threads.Element;
import org.jboss.as.threads.Namespace;
import org.jboss.as.threads.PoolAttributeDefinitions;
import org.jboss.as.threads.ThreadsLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public final class ThreadsParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    static final ThreadsParser INSTANCE = new ThreadsParser();
    private static final String SUBSYSTEM_NAME = "threads";

    public static ThreadsParser getInstance() {
        return INSTANCE;
    }

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        if (Element.forName(reader.getLocalName()) != Element.SUBSYSTEM) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        ModelNode address = new ModelNode();
        address.add("subsystem", SUBSYSTEM_NAME);
        address.protect();
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(address);
        list.add(subsystem);
        String readerNS = reader.getNamespaceURI();
        Namespace threadsNamespace = Namespace.forUri(readerNS);
        switch (threadsNamespace) {
            case THREADS_1_0: {
                this.readElement1_0(reader, list, address);
                break;
            }
            default: {
                this.readElement1_1(reader, list, address, readerNS, threadsNamespace);
            }
        }
    }

    private void readElement1_0(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode subsystemAddress) throws XMLStreamException {
        Namespace threadsNamespace = Namespace.THREADS_1_0;
        String readerNS = threadsNamespace.getUriString();
        block7: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = ThreadsParser.nextElement(reader, readerNS);
            switch (element) {
                case BOUNDED_QUEUE_THREAD_POOL: {
                    this.parseUnknownBoundedQueueThreadPool1_0(reader, readerNS, subsystemAddress, list);
                    continue block7;
                }
                case THREAD_FACTORY: {
                    this.parseThreadFactory(reader, readerNS, threadsNamespace, subsystemAddress, list, "thread-factory", null);
                    continue block7;
                }
                case QUEUELESS_THREAD_POOL: {
                    this.parseUnknownQueuelessThreadPool1_0(reader, readerNS, subsystemAddress, list);
                    continue block7;
                }
                case SCHEDULED_THREAD_POOL: {
                    this.parseScheduledThreadPool(reader, readerNS, threadsNamespace, subsystemAddress, list, "scheduled-thread-pool", null);
                    continue block7;
                }
                case UNBOUNDED_QUEUE_THREAD_POOL: {
                    this.parseUnboundedQueueThreadPool(reader, readerNS, threadsNamespace, subsystemAddress, list, "unbounded-queue-thread-pool", null);
                    continue block7;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    private void readElement1_1(XMLExtendedStreamReader reader, List<ModelNode> list, ModelNode subsystemAddress, String readerNS, Namespace threadsNamespace) throws XMLStreamException {
        block9: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = ThreadsParser.nextElement(reader, readerNS);
            switch (element) {
                case BLOCKING_BOUNDED_QUEUE_THREAD_POOL: {
                    this.parseBoundedQueueThreadPool1_1(reader, readerNS, threadsNamespace, subsystemAddress, list, "blocking-bounded-queue-thread-pool", null, true);
                    continue block9;
                }
                case BLOCKING_QUEUELESS_THREAD_POOL: {
                    this.parseQueuelessThreadPool1_1(reader, readerNS, threadsNamespace, subsystemAddress, list, "blocking-queueless-thread-pool", null, true);
                    continue block9;
                }
                case BOUNDED_QUEUE_THREAD_POOL: {
                    this.parseBoundedQueueThreadPool1_1(reader, readerNS, threadsNamespace, subsystemAddress, list, "bounded-queue-thread-pool", null, false);
                    continue block9;
                }
                case THREAD_FACTORY: {
                    this.parseThreadFactory(reader, readerNS, threadsNamespace, subsystemAddress, list, "thread-factory", null);
                    continue block9;
                }
                case QUEUELESS_THREAD_POOL: {
                    this.parseQueuelessThreadPool1_1(reader, readerNS, threadsNamespace, subsystemAddress, list, "queueless-thread-pool", null, false);
                    continue block9;
                }
                case SCHEDULED_THREAD_POOL: {
                    this.parseScheduledThreadPool(reader, readerNS, threadsNamespace, subsystemAddress, list, "scheduled-thread-pool", null);
                    continue block9;
                }
                case UNBOUNDED_QUEUE_THREAD_POOL: {
                    this.parseUnboundedQueueThreadPool(reader, readerNS, threadsNamespace, subsystemAddress, list, "unbounded-queue-thread-pool", null);
                    continue block9;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    public String parseThreadFactory(XMLExtendedStreamReader reader, String expectedNs, Namespace threadsNamespace, ModelNode parentAddress, List<ModelNode> list, String childType, String providedName) throws XMLStreamException {
        ModelNode op = new ModelNode();
        list.add(op);
        op.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block9;
                }
                case GROUP_NAME: {
                    PoolAttributeDefinitions.GROUP_NAME.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue block9;
                }
                case THREAD_NAME_PATTERN: {
                    PoolAttributeDefinitions.THREAD_NAME_PATTERN.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue block9;
                }
                case PRIORITY: {
                    PoolAttributeDefinitions.PRIORITY.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (providedName != null) {
            name = providedName;
        } else if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ModelNode address = parentAddress.clone();
        address.add(childType, name);
        address.protect();
        op.get("address").set(address);
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = ThreadsParser.nextElement(reader, expectedNs);
            switch (element) {
                case PROPERTIES: {
                    this.parseProperties(reader, threadsNamespace);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        return name;
    }

    public String parseBlockingBoundedQueueThreadPool(XMLExtendedStreamReader reader, String expectedNs, Namespace threadsNamespace, ModelNode parentAddress, List<ModelNode> list, String childType, String providedName) throws XMLStreamException {
        switch (threadsNamespace) {
            case THREADS_1_0: {
                return this.parseBoundedQueueThreadPool1_0(reader, expectedNs, threadsNamespace, parentAddress, list, childType, providedName, true);
            }
        }
        return this.parseBoundedQueueThreadPool1_1(reader, expectedNs, threadsNamespace, parentAddress, list, childType, providedName, true);
    }

    public String parseBoundedQueueThreadPool(XMLExtendedStreamReader reader, String expectedNs, Namespace threadsNamespace, ModelNode parentAddress, List<ModelNode> list, String childType, String providedName) throws XMLStreamException {
        switch (threadsNamespace) {
            case THREADS_1_0: {
                return this.parseBoundedQueueThreadPool1_0(reader, expectedNs, threadsNamespace, parentAddress, list, childType, providedName, false);
            }
        }
        return this.parseBoundedQueueThreadPool1_1(reader, expectedNs, threadsNamespace, parentAddress, list, childType, providedName, false);
    }

    private void parseUnknownBoundedQueueThreadPool1_0(XMLExtendedStreamReader reader, String expectedNs, ModelNode parentAddress, List<ModelNode> list) throws XMLStreamException {
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case BLOCKING: {
                    this.parseBoundedQueueThreadPool1_0(reader, expectedNs, Namespace.THREADS_1_0, parentAddress, list, "blocking-bounded-queue-thread-pool", null, true);
                    return;
                }
            }
        }
        this.parseBoundedQueueThreadPool1_0(reader, expectedNs, Namespace.THREADS_1_0, parentAddress, list, "bounded-queue-thread-pool", null, false);
    }

    private String parseBoundedQueueThreadPool1_0(XMLExtendedStreamReader reader, String expectedNs, Namespace threadsNamespace, ModelNode parentAddress, List<ModelNode> list, String childType, String providedName, boolean blocking) throws XMLStreamException {
        ModelNode op = new ModelNode();
        list.add(op);
        op.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block14: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block14;
                }
                case BLOCKING: {
                    continue block14;
                }
                case ALLOW_CORE_TIMEOUT: {
                    PoolAttributeDefinitions.ALLOW_CORE_TIMEOUT.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue block14;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (providedName != null) {
            name = providedName;
        } else if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ModelNode address = parentAddress.clone();
        address.add(childType, name);
        address.protect();
        op.get("address").set(address);
        EnumSet<Element> required = EnumSet.of(Element.MAX_THREADS, Element.QUEUE_LENGTH);
        block15: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = ThreadsParser.nextElement(reader, expectedNs);
            required.remove((Object)element);
            switch (element) {
                case CORE_THREADS: {
                    String scaledCount = this.parseCount(reader, threadsNamespace);
                    PoolAttributeDefinitions.CORE_THREADS.parseAndSetParameter(scaledCount, op, (XMLStreamReader)reader);
                    continue block15;
                }
                case HANDOFF_EXECUTOR: {
                    String ref = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
                    if (blocking) continue block15;
                    PoolAttributeDefinitions.HANDOFF_EXECUTOR.parseAndSetParameter(ref, op, (XMLStreamReader)reader);
                    continue block15;
                }
                case MAX_THREADS: {
                    String scaledCount = this.parseCount(reader, threadsNamespace);
                    PoolAttributeDefinitions.MAX_THREADS.parseAndSetParameter(scaledCount, op, (XMLStreamReader)reader);
                    continue block15;
                }
                case KEEPALIVE_TIME: {
                    PoolAttributeDefinitions.KEEPALIVE_TIME.parseAndSetParameter(op, reader);
                    continue block15;
                }
                case THREAD_FACTORY: {
                    String ref = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
                    PoolAttributeDefinitions.THREAD_FACTORY.parseAndSetParameter(ref, op, (XMLStreamReader)reader);
                    continue block15;
                }
                case PROPERTIES: {
                    this.parseProperties(reader, threadsNamespace);
                    continue block15;
                }
                case QUEUE_LENGTH: {
                    String scaledCount = this.parseCount(reader, threadsNamespace);
                    PoolAttributeDefinitions.QUEUE_LENGTH.parseAndSetParameter(scaledCount, op, (XMLStreamReader)reader);
                    continue block15;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, required);
        }
        return name;
    }

    private String parseBoundedQueueThreadPool1_1(XMLExtendedStreamReader reader, String expectedNs, Namespace threadsNamespace, ModelNode parentAddress, List<ModelNode> list, String childType, String providedName, boolean blocking) throws XMLStreamException {
        ModelNode op = new ModelNode();
        list.add(op);
        op.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block12: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block12;
                }
                case ALLOW_CORE_TIMEOUT: {
                    PoolAttributeDefinitions.ALLOW_CORE_TIMEOUT.parseAndSetParameter(value, op, (XMLStreamReader)reader);
                    continue block12;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (providedName != null) {
            name = providedName;
        } else if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ModelNode address = parentAddress.clone();
        address.add(childType, name);
        address.protect();
        op.get("address").set(address);
        EnumSet<Element> required = EnumSet.of(Element.MAX_THREADS, Element.QUEUE_LENGTH);
        block13: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = ThreadsParser.nextElement(reader, expectedNs);
            required.remove((Object)element);
            switch (element) {
                case CORE_THREADS: {
                    String scaledCount = this.parseCount(reader, threadsNamespace);
                    PoolAttributeDefinitions.CORE_THREADS.parseAndSetParameter(scaledCount, op, (XMLStreamReader)reader);
                    continue block13;
                }
                case HANDOFF_EXECUTOR: {
                    if (blocking) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    String ref = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
                    PoolAttributeDefinitions.HANDOFF_EXECUTOR.parseAndSetParameter(ref, op, (XMLStreamReader)reader);
                    continue block13;
                }
                case MAX_THREADS: {
                    String scaledCount = this.parseCount(reader, threadsNamespace);
                    PoolAttributeDefinitions.MAX_THREADS.parseAndSetParameter(scaledCount, op, (XMLStreamReader)reader);
                    continue block13;
                }
                case KEEPALIVE_TIME: {
                    PoolAttributeDefinitions.KEEPALIVE_TIME.parseAndSetParameter(op, reader);
                    continue block13;
                }
                case THREAD_FACTORY: {
                    String ref = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
                    PoolAttributeDefinitions.THREAD_FACTORY.parseAndSetParameter(ref, op, (XMLStreamReader)reader);
                    continue block13;
                }
                case QUEUE_LENGTH: {
                    String scaledCount = this.parseCount(reader, threadsNamespace);
                    PoolAttributeDefinitions.QUEUE_LENGTH.parseAndSetParameter(scaledCount, op, (XMLStreamReader)reader);
                    continue block13;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!required.isEmpty()) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, required);
        }
        return name;
    }

    public String parseUnboundedQueueThreadPool(XMLExtendedStreamReader reader, String expectedNs, Namespace threadsNamespace, ModelNode parentAddress, List<ModelNode> list, String childType, String providedName) throws XMLStreamException {
        ModelNode op = new ModelNode();
        list.add(op);
        op.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (providedName != null) {
            name = providedName;
        } else if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ModelNode address = parentAddress.clone();
        address.add(childType, name);
        address.protect();
        op.get("address").set(address);
        boolean foundMaxThreads = false;
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = ThreadsParser.nextElement(reader, expectedNs);
            switch (element) {
                case MAX_THREADS: {
                    String scaledCount = this.parseCount(reader, threadsNamespace);
                    PoolAttributeDefinitions.MAX_THREADS.parseAndSetParameter(scaledCount, op, (XMLStreamReader)reader);
                    foundMaxThreads = true;
                    continue block10;
                }
                case KEEPALIVE_TIME: {
                    PoolAttributeDefinitions.KEEPALIVE_TIME.parseAndSetParameter(op, reader);
                    continue block10;
                }
                case THREAD_FACTORY: {
                    String ref = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
                    PoolAttributeDefinitions.THREAD_FACTORY.parseAndSetParameter(ref, op, (XMLStreamReader)reader);
                    continue block10;
                }
                case PROPERTIES: {
                    this.parseProperties(reader, threadsNamespace);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!foundMaxThreads) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton(Element.MAX_THREADS));
        }
        return name;
    }

    public String parseScheduledThreadPool(XMLExtendedStreamReader reader, String expectedNs, Namespace threadsNamespace, ModelNode parentAddress, List<ModelNode> list, String childType, String providedName) throws XMLStreamException {
        ModelNode op = new ModelNode();
        list.add(op);
        op.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (providedName != null) {
            name = providedName;
        } else if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ModelNode address = parentAddress.clone();
        address.add(childType, name);
        address.protect();
        op.get("address").set(address);
        boolean foundMaxThreads = false;
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = ThreadsParser.nextElement(reader, expectedNs);
            switch (element) {
                case MAX_THREADS: {
                    String scaledCount = this.parseCount(reader, threadsNamespace);
                    PoolAttributeDefinitions.MAX_THREADS.parseAndSetParameter(scaledCount, op, (XMLStreamReader)reader);
                    foundMaxThreads = true;
                    continue block10;
                }
                case KEEPALIVE_TIME: {
                    PoolAttributeDefinitions.KEEPALIVE_TIME.parseAndSetParameter(op, reader);
                    continue block10;
                }
                case THREAD_FACTORY: {
                    String ref = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
                    PoolAttributeDefinitions.THREAD_FACTORY.parseAndSetParameter(ref, op, (XMLStreamReader)reader);
                    continue block10;
                }
                case PROPERTIES: {
                    this.parseProperties(reader, threadsNamespace);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!foundMaxThreads) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton(Element.MAX_THREADS));
        }
        return name;
    }

    private void parseUnknownQueuelessThreadPool1_0(XMLExtendedStreamReader reader, String readerNS, ModelNode subsystemAddress, List<ModelNode> list) throws XMLStreamException {
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case BLOCKING: {
                    this.parseQueuelessThreadPool1_0(reader, readerNS, Namespace.THREADS_1_0, subsystemAddress, list, "blocking-queueless-thread-pool", null, true);
                    return;
                }
            }
        }
        this.parseQueuelessThreadPool1_0(reader, readerNS, Namespace.THREADS_1_0, subsystemAddress, list, "queueless-thread-pool", null, false);
    }

    private String parseQueuelessThreadPool1_0(XMLExtendedStreamReader reader, String expectedNs, Namespace threadsNamespace, ModelNode parentAddress, List<ModelNode> list, String childType, String providedName, boolean blocking) throws XMLStreamException {
        ModelNode op = new ModelNode();
        list.add(op);
        op.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block11: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block11;
                }
                case BLOCKING: {
                    continue block11;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (providedName != null) {
            name = providedName;
        } else if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ModelNode address = parentAddress.clone();
        address.add(childType, name);
        address.protect();
        op.get("address").set(address);
        boolean foundMaxThreads = false;
        block12: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = ThreadsParser.nextElement(reader, expectedNs);
            switch (element) {
                case HANDOFF_EXECUTOR: {
                    String ref = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
                    if (blocking) continue block12;
                    PoolAttributeDefinitions.HANDOFF_EXECUTOR.parseAndSetParameter(ref, op, (XMLStreamReader)reader);
                    continue block12;
                }
                case MAX_THREADS: {
                    String scaledCount = this.parseCount(reader, threadsNamespace);
                    PoolAttributeDefinitions.MAX_THREADS.parseAndSetParameter(scaledCount, op, (XMLStreamReader)reader);
                    foundMaxThreads = true;
                    continue block12;
                }
                case KEEPALIVE_TIME: {
                    PoolAttributeDefinitions.KEEPALIVE_TIME.parseAndSetParameter(op, reader);
                    continue block12;
                }
                case THREAD_FACTORY: {
                    String ref = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
                    PoolAttributeDefinitions.THREAD_FACTORY.parseAndSetParameter(ref, op, (XMLStreamReader)reader);
                    continue block12;
                }
                case PROPERTIES: {
                    this.parseProperties(reader, threadsNamespace);
                    continue block12;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!foundMaxThreads) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton(Element.MAX_THREADS));
        }
        return name;
    }

    private String parseQueuelessThreadPool1_1(XMLExtendedStreamReader reader, String expectedNs, Namespace threadsNamespace, ModelNode parentAddress, List<ModelNode> list, String childType, String providedName, boolean blocking) throws XMLStreamException {
        ModelNode op = new ModelNode();
        list.add(op);
        op.get("operation").set("add");
        String name = null;
        int count = reader.getAttributeCount();
        block9: for (int i = 0; i < count; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case NAME: {
                    name = value;
                    continue block9;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (providedName != null) {
            name = providedName;
        } else if (name == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, Collections.singleton(Attribute.NAME));
        }
        ModelNode address = parentAddress.clone();
        address.add(childType, name);
        address.protect();
        op.get("address").set(address);
        boolean foundMaxThreads = false;
        block10: while (reader.hasNext() && reader.nextTag() != 2) {
            Element element = ThreadsParser.nextElement(reader, expectedNs);
            switch (element) {
                case HANDOFF_EXECUTOR: {
                    if (blocking) {
                        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
                    }
                    String ref = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
                    PoolAttributeDefinitions.HANDOFF_EXECUTOR.parseAndSetParameter(ref, op, (XMLStreamReader)reader);
                    continue block10;
                }
                case MAX_THREADS: {
                    String scaledCount = this.parseCount(reader, threadsNamespace);
                    PoolAttributeDefinitions.MAX_THREADS.parseAndSetParameter(scaledCount, op, (XMLStreamReader)reader);
                    foundMaxThreads = true;
                    continue block10;
                }
                case KEEPALIVE_TIME: {
                    PoolAttributeDefinitions.KEEPALIVE_TIME.parseAndSetParameter(op, reader);
                    continue block10;
                }
                case THREAD_FACTORY: {
                    String ref = ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.NAME.getLocalName());
                    PoolAttributeDefinitions.THREAD_FACTORY.parseAndSetParameter(ref, op, (XMLStreamReader)reader);
                    continue block10;
                }
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!foundMaxThreads) {
            throw ParseUtils.missingRequiredElement((XMLExtendedStreamReader)reader, Collections.singleton(Element.MAX_THREADS));
        }
        return name;
    }

    private String parseCount(XMLExtendedStreamReader reader, Namespace expectedNS) throws XMLStreamException {
        switch (expectedNS) {
            case THREADS_1_0: {
                return this.parseScaledCount(reader);
            }
        }
        return ParseUtils.readStringAttributeElement((XMLExtendedStreamReader)reader, (String)Attribute.COUNT.getLocalName());
    }

    private String parseScaledCount(XMLExtendedStreamReader reader) throws XMLStreamException {
        int attrCount = reader.getAttributeCount();
        BigDecimal count = null;
        BigDecimal perCpu = new BigDecimal(0);
        block8: for (int i = 0; i < attrCount; ++i) {
            ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
            String value = reader.getAttributeValue(i);
            Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
            switch (attribute) {
                case COUNT: {
                    try {
                        count = new BigDecimal(value);
                        if (count.compareTo(BigDecimal.ZERO) >= 0) continue block8;
                        throw ThreadsLogger.ROOT_LOGGER.countMustBePositive(attribute, reader.getLocation());
                    }
                    catch (NumberFormatException e) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
                case PER_CPU: {
                    try {
                        perCpu = new BigDecimal(value);
                        if (perCpu.compareTo(BigDecimal.ZERO) >= 0) continue block8;
                        throw ThreadsLogger.ROOT_LOGGER.perCpuMustBePositive(attribute, reader.getLocation());
                    }
                    catch (NumberFormatException e) {
                        throw ParseUtils.invalidAttributeValue((XMLExtendedStreamReader)reader, (int)i);
                    }
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        if (count == null) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, EnumSet.of(Attribute.COUNT));
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
        int fullCount = ThreadsParser.getScaledCount(count, perCpu);
        if (!perCpu.equals(new BigDecimal(0))) {
            ThreadsLogger.ROOT_LOGGER.perCpuNotSupported(Attribute.PER_CPU, count, Attribute.COUNT, perCpu, Attribute.PER_CPU, Runtime.getRuntime().availableProcessors(), fullCount, Attribute.COUNT);
        }
        return String.valueOf(fullCount);
    }

    private static int getScaledCount(BigDecimal count, BigDecimal perCpu) {
        return count.add(perCpu.multiply(BigDecimal.valueOf(Runtime.getRuntime().availableProcessors()), MathContext.DECIMAL64), MathContext.DECIMAL64).round(MathContext.DECIMAL64).intValueExact();
    }

    private void parseProperties(XMLExtendedStreamReader reader, Namespace threadsNamespace) throws XMLStreamException {
        if (threadsNamespace != Namespace.THREADS_1_0) {
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        while (reader.hasNext() && reader.nextTag() != 2) {
            switch (Element.forName(reader.getLocalName())) {
                case PROPERTY: {
                    int attrCount = reader.getAttributeCount();
                    String propName = null;
                    String propValue = null;
                    block8: for (int i = 0; i < attrCount; ++i) {
                        ParseUtils.requireNoNamespaceAttribute((XMLExtendedStreamReader)reader, (int)i);
                        String value = reader.getAttributeValue(i);
                        Attribute attribute = Attribute.forName(reader.getAttributeLocalName(i));
                        switch (attribute) {
                            case NAME: {
                                propName = value;
                                continue block8;
                            }
                            case VALUE: {
                                propValue = value;
                                continue block8;
                            }
                            default: {
                                throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                            }
                        }
                    }
                    if (propName == null || propValue == null) {
                        HashSet<Attribute> missing = new HashSet<Attribute>();
                        if (propName == null) {
                            missing.add(Attribute.NAME);
                        }
                        if (propValue == null) {
                            missing.add(Attribute.VALUE);
                        }
                        throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, missing);
                    }
                    ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                }
            }
        }
    }

    private static Element nextElement(XMLExtendedStreamReader reader, String expectedNamespace) throws XMLStreamException {
        Element element = Element.forName(reader.getLocalName());
        if (element == null) {
            return element;
        }
        if (expectedNamespace.equals(reader.getNamespaceURI())) {
            return element;
        }
        throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement(Namespace.CURRENT.getUriString(), false);
        ModelNode node = context.getModelNode();
        this.writeThreadsElement(writer, node);
        writer.writeEndElement();
    }

    public void writeThreadsElement(XMLExtendedStreamWriter writer, ModelNode node) throws XMLStreamException {
        if (node.hasDefined("thread-factory")) {
            for (Property property : node.get("thread-factory").asPropertyList()) {
                this.writeThreadFactory(writer, property);
            }
        }
        if (node.hasDefined("unbounded-queue-thread-pool")) {
            for (Property property : node.get("unbounded-queue-thread-pool").asPropertyList()) {
                this.writeUnboundedQueueThreadPool(writer, property);
            }
        }
        if (node.hasDefined("bounded-queue-thread-pool")) {
            for (Property property : node.get("bounded-queue-thread-pool").asPropertyList()) {
                this.writeBoundedQueueThreadPool(writer, property);
            }
        }
        if (node.hasDefined("blocking-bounded-queue-thread-pool")) {
            for (Property property : node.get("blocking-bounded-queue-thread-pool").asPropertyList()) {
                this.writeBlockingBoundedQueueThreadPool(writer, property);
            }
        }
        if (node.hasDefined("queueless-thread-pool")) {
            for (Property property : node.get("queueless-thread-pool").asPropertyList()) {
                this.writeQueuelessThreadPool(writer, property);
            }
        }
        if (node.hasDefined("blocking-queueless-thread-pool")) {
            for (Property property : node.get("blocking-queueless-thread-pool").asPropertyList()) {
                this.writeBlockingQueuelessThreadPool(writer, property);
            }
        }
        if (node.hasDefined("scheduled-thread-pool")) {
            for (Property property : node.get("scheduled-thread-pool").asPropertyList()) {
                this.writeScheduledQueueThreadPool(writer, property);
            }
        }
    }

    public void writeThreadFactory(XMLExtendedStreamWriter writer, Property property) throws XMLStreamException {
        this.writeThreadFactory(writer, property, Element.THREAD_FACTORY.getLocalName(), true);
    }

    public void writeThreadFactory(XMLExtendedStreamWriter writer, Property property, String elementName, boolean includeName) throws XMLStreamException {
        writer.writeStartElement(elementName);
        ModelNode node = property.getValue();
        if (includeName) {
            writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
        }
        PoolAttributeDefinitions.GROUP_NAME.marshallAsAttribute(node, (XMLStreamWriter)writer);
        PoolAttributeDefinitions.THREAD_NAME_PATTERN.marshallAsAttribute(node, (XMLStreamWriter)writer);
        PoolAttributeDefinitions.PRIORITY.marshallAsAttribute(node, (XMLStreamWriter)writer);
        writer.writeEndElement();
    }

    public void writeBlockingBoundedQueueThreadPool(XMLExtendedStreamWriter writer, Property property) throws XMLStreamException {
        this.writeBoundedQueueThreadPool(writer, property, Element.BLOCKING_BOUNDED_QUEUE_THREAD_POOL.getLocalName(), true, true);
    }

    public void writeBoundedQueueThreadPool(XMLExtendedStreamWriter writer, Property property) throws XMLStreamException {
        this.writeBoundedQueueThreadPool(writer, property, Element.BOUNDED_QUEUE_THREAD_POOL.getLocalName(), true, false);
    }

    public void writeBoundedQueueThreadPool(XMLExtendedStreamWriter writer, Property property, String elementName, boolean includeName) throws XMLStreamException {
        this.writeBoundedQueueThreadPool(writer, property, elementName, includeName, false);
    }

    public void writeBoundedQueueThreadPool(XMLExtendedStreamWriter writer, Property property, String elementName, boolean includeName, boolean blocking) throws XMLStreamException {
        writer.writeStartElement(elementName);
        ModelNode node = property.getValue();
        if (includeName) {
            writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
        }
        PoolAttributeDefinitions.ALLOW_CORE_TIMEOUT.marshallAsAttribute(node, (XMLStreamWriter)writer);
        this.writeCountElement((AttributeDefinition)PoolAttributeDefinitions.CORE_THREADS, node, writer);
        this.writeCountElement((AttributeDefinition)PoolAttributeDefinitions.QUEUE_LENGTH, node, writer);
        this.writeCountElement((AttributeDefinition)PoolAttributeDefinitions.MAX_THREADS, node, writer);
        this.writeTime(writer, node, Element.KEEPALIVE_TIME);
        this.writeRef(writer, node, Element.THREAD_FACTORY, "thread-factory");
        if (!blocking) {
            this.writeRef(writer, node, Element.HANDOFF_EXECUTOR, "handoff-executor");
        }
        writer.writeEndElement();
    }

    private void writeCountElement(AttributeDefinition attributeDefinition, ModelNode model, XMLExtendedStreamWriter writer) throws XMLStreamException {
        if (attributeDefinition.isMarshallable(model)) {
            writer.writeEmptyElement(attributeDefinition.getXmlName());
            writer.writeAttribute(Attribute.COUNT.getLocalName(), model.get(attributeDefinition.getName()).asString());
        }
    }

    public void writeBlockingQueuelessThreadPool(XMLExtendedStreamWriter writer, Property property) throws XMLStreamException {
        this.writeQueuelessThreadPool(writer, property, Element.BLOCKING_QUEUELESS_THREAD_POOL.getLocalName(), true, true);
    }

    public void writeQueuelessThreadPool(XMLExtendedStreamWriter writer, Property property) throws XMLStreamException {
        this.writeQueuelessThreadPool(writer, property, Element.QUEUELESS_THREAD_POOL.getLocalName(), true, false);
    }

    private void writeQueuelessThreadPool(XMLExtendedStreamWriter writer, Property property, String elementName, boolean includeName, boolean blocking) throws XMLStreamException {
        writer.writeStartElement(elementName);
        ModelNode node = property.getValue();
        if (includeName) {
            writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
        }
        this.writeCountElement((AttributeDefinition)PoolAttributeDefinitions.MAX_THREADS, node, writer);
        this.writeTime(writer, node, Element.KEEPALIVE_TIME);
        this.writeRef(writer, node, Element.THREAD_FACTORY, "thread-factory");
        if (!blocking) {
            this.writeRef(writer, node, Element.HANDOFF_EXECUTOR, "handoff-executor");
        }
        writer.writeEndElement();
    }

    public void writeScheduledQueueThreadPool(XMLExtendedStreamWriter writer, Property property) throws XMLStreamException {
        this.writeScheduledQueueThreadPool(writer, property, Element.SCHEDULED_THREAD_POOL.getLocalName(), true);
    }

    public void writeScheduledQueueThreadPool(XMLExtendedStreamWriter writer, Property property, String elementName, boolean includeName) throws XMLStreamException {
        writer.writeStartElement(elementName);
        ModelNode node = property.getValue();
        if (includeName) {
            writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
        }
        this.writeCountElement((AttributeDefinition)PoolAttributeDefinitions.MAX_THREADS, node, writer);
        this.writeTime(writer, node, Element.KEEPALIVE_TIME);
        this.writeRef(writer, node, Element.THREAD_FACTORY, "thread-factory");
        writer.writeEndElement();
    }

    public void writeUnboundedQueueThreadPool(XMLExtendedStreamWriter writer, Property property) throws XMLStreamException {
        this.writeUnboundedQueueThreadPool(writer, property, Element.UNBOUNDED_QUEUE_THREAD_POOL.getLocalName(), true);
    }

    public void writeUnboundedQueueThreadPool(XMLExtendedStreamWriter writer, Property property, String elementName, boolean includeName) throws XMLStreamException {
        writer.writeStartElement(elementName);
        ModelNode node = property.getValue();
        if (includeName) {
            writer.writeAttribute(Attribute.NAME.getLocalName(), property.getName());
        }
        this.writeCountElement((AttributeDefinition)PoolAttributeDefinitions.MAX_THREADS, node, writer);
        this.writeTime(writer, node, Element.KEEPALIVE_TIME);
        this.writeRef(writer, node, Element.THREAD_FACTORY, "thread-factory");
        writer.writeEndElement();
    }

    private void writeRef(XMLExtendedStreamWriter writer, ModelNode node, Element element, String name) throws XMLStreamException {
        if (node.hasDefined(name)) {
            writer.writeStartElement(element.getLocalName());
            this.writeAttribute(writer, Attribute.NAME, node.get(name));
            writer.writeEndElement();
        }
    }

    private void writeTime(XMLExtendedStreamWriter writer, ModelNode node, Element element) throws XMLStreamException {
        if (node.hasDefined(element.getLocalName())) {
            writer.writeStartElement(element.getLocalName());
            ModelNode keepalive = node.get(element.getLocalName());
            if (keepalive.hasDefined("time")) {
                this.writeAttribute(writer, Attribute.TIME, keepalive.get("time"));
            }
            if (keepalive.hasDefined("unit")) {
                this.writeAttributeLowerCaseValue(writer, Attribute.UNIT, keepalive.get("unit"));
            }
            writer.writeEndElement();
        }
    }

    private void writeAttribute(XMLExtendedStreamWriter writer, Attribute attr, ModelNode value) throws XMLStreamException {
        writer.writeAttribute(attr.getLocalName(), value.asString());
    }

    private void writeAttributeLowerCaseValue(XMLExtendedStreamWriter writer, Attribute attr, ModelNode value) throws XMLStreamException {
        writer.writeAttribute(attr.getLocalName(), value.asString().toLowerCase(Locale.ENGLISH));
    }
}

