/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.HashMap;
import java.util.Map;
import org.infinispan.configuration.cache.BackupConfiguration;
import org.infinispan.configuration.cache.BackupConfigurationBuilder;
import org.infinispan.configuration.cache.BackupFailurePolicy;
import org.infinispan.configuration.cache.BackupForConfiguration;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.SitesConfiguration;
import org.infinispan.configuration.cache.SitesConfigurationBuilder;
import org.jboss.as.clustering.controller.ResourceServiceBuilder;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.infinispan.subsystem.BackupResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponent;
import org.jboss.as.clustering.infinispan.subsystem.CacheComponentBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.value.InjectedValue;
import org.wildfly.clustering.service.Builder;

public class BackupsBuilder
extends CacheComponentBuilder<SitesConfiguration>
implements ResourceServiceBuilder<SitesConfiguration> {
    private final InjectedValue<BackupForConfiguration> backupFor = new InjectedValue();
    private final Map<String, BackupConfiguration> backups = new HashMap<String, BackupConfiguration>();
    private final String containerName;
    private final String cacheName;

    BackupsBuilder(String containerName, String cacheName) {
        super(CacheComponent.BACKUPS, containerName, cacheName);
        this.containerName = containerName;
        this.cacheName = cacheName;
    }

    @Override
    public ServiceBuilder<SitesConfiguration> build(ServiceTarget target) {
        return super.build(target).addDependency(CacheComponent.BACKUP_FOR.getServiceName(this.containerName, this.cacheName), BackupForConfiguration.class, this.backupFor);
    }

    public Builder<SitesConfiguration> configure(OperationContext context, ModelNode model) throws OperationFailedException {
        this.backups.clear();
        if (model.hasDefined(BackupResourceDefinition.WILDCARD_PATH.getKey())) {
            SitesConfigurationBuilder builder = new ConfigurationBuilder().sites();
            for (Property property : model.get(BackupResourceDefinition.WILDCARD_PATH.getKey()).asPropertyList()) {
                String siteName = property.getName();
                ModelNode backup = property.getValue();
                BackupConfigurationBuilder backupBuilder = builder.addBackup();
                backupBuilder.site(siteName).enabled(BackupResourceDefinition.Attribute.ENABLED.getDefinition().resolveModelAttribute(context, backup).asBoolean()).backupFailurePolicy((BackupFailurePolicy)ModelNodes.asEnum((ModelNode)BackupResourceDefinition.Attribute.FAILURE_POLICY.getDefinition().resolveModelAttribute(context, backup), BackupFailurePolicy.class)).replicationTimeout(BackupResourceDefinition.Attribute.TIMEOUT.getDefinition().resolveModelAttribute(context, backup).asLong()).strategy((BackupConfiguration.BackupStrategy)ModelNodes.asEnum((ModelNode)BackupResourceDefinition.Attribute.STRATEGY.getDefinition().resolveModelAttribute(context, backup), BackupConfiguration.BackupStrategy.class)).takeOffline().afterFailures(BackupResourceDefinition.TakeOfflineAttribute.AFTER_FAILURES.getDefinition().resolveModelAttribute(context, backup).asInt()).minTimeToWait(BackupResourceDefinition.TakeOfflineAttribute.MIN_WAIT.getDefinition().resolveModelAttribute(context, backup).asLong());
                this.backups.put(siteName, backupBuilder.create());
            }
        }
        return this;
    }

    public SitesConfiguration getValue() {
        SitesConfigurationBuilder builder = new ConfigurationBuilder().sites();
        builder.backupFor().read((BackupForConfiguration)this.backupFor.getValue());
        builder.disableBackups(this.backups.isEmpty());
        for (Map.Entry<String, BackupConfiguration> backup : this.backups.entrySet()) {
            builder.addBackup().read(backup.getValue());
            builder.addInUseBackupSite(backup.getKey());
        }
        return builder.create();
    }
}

