/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FilteredTermsEnum;
import org.apache.lucene.index.MergeState;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.LongBitSet;
import org.apache.lucene.util.LongValues;

public abstract class DocValuesConsumer
implements Closeable {
    protected DocValuesConsumer() {
    }

    public abstract void addNumericField(FieldInfo var1, Iterable<Number> var2) throws IOException;

    public abstract void addBinaryField(FieldInfo var1, Iterable<BytesRef> var2) throws IOException;

    public abstract void addSortedField(FieldInfo var1, Iterable<BytesRef> var2, Iterable<Number> var3) throws IOException;

    public abstract void addSortedNumericField(FieldInfo var1, Iterable<Number> var2, Iterable<Number> var3) throws IOException;

    public abstract void addSortedSetField(FieldInfo var1, Iterable<BytesRef> var2, Iterable<Number> var3, Iterable<Number> var4) throws IOException;

    public void merge(MergeState mergeState) throws IOException {
        for (DocValuesProducer docValuesProducer : mergeState.docValuesProducers) {
            if (docValuesProducer == null) continue;
            docValuesProducer.checkIntegrity();
        }
        for (FieldInfo mergeFieldInfo : mergeState.mergeFieldInfos) {
            FieldInfo fieldInfo;
            DocValuesProducer docValuesProducer;
            FieldInfo fieldInfo2;
            DocValuesProducer docValuesProducer2;
            Bits bits;
            Object values;
            int i;
            ArrayList<NumericDocValues> toMerge;
            DocValuesType type = mergeFieldInfo.getDocValuesType();
            if (type == DocValuesType.NONE) continue;
            if (type == DocValuesType.NUMERIC) {
                toMerge = new ArrayList<NumericDocValues>();
                ArrayList<Bits> docsWithField = new ArrayList<Bits>();
                for (i = 0; i < mergeState.docValuesProducers.length; ++i) {
                    values = null;
                    bits = null;
                    docValuesProducer2 = mergeState.docValuesProducers[i];
                    if (docValuesProducer2 != null && (fieldInfo2 = mergeState.fieldInfos[i].fieldInfo(mergeFieldInfo.name)) != null && fieldInfo2.getDocValuesType() == DocValuesType.NUMERIC) {
                        values = docValuesProducer2.getNumeric(fieldInfo2);
                        bits = docValuesProducer2.getDocsWithField(fieldInfo2);
                    }
                    if (values == null) {
                        values = DocValues.emptyNumeric();
                        bits = new Bits.MatchNoBits(mergeState.maxDocs[i]);
                    }
                    toMerge.add((NumericDocValues)values);
                    docsWithField.add(bits);
                }
                this.mergeNumericField(mergeFieldInfo, mergeState, toMerge, docsWithField);
                continue;
            }
            if (type == DocValuesType.BINARY) {
                toMerge = new ArrayList();
                ArrayList<Bits> docsWithField = new ArrayList<Bits>();
                for (i = 0; i < mergeState.docValuesProducers.length; ++i) {
                    values = null;
                    bits = null;
                    docValuesProducer2 = mergeState.docValuesProducers[i];
                    if (docValuesProducer2 != null && (fieldInfo2 = mergeState.fieldInfos[i].fieldInfo(mergeFieldInfo.name)) != null && fieldInfo2.getDocValuesType() == DocValuesType.BINARY) {
                        values = docValuesProducer2.getBinary(fieldInfo2);
                        bits = docValuesProducer2.getDocsWithField(fieldInfo2);
                    }
                    if (values == null) {
                        values = DocValues.emptyBinary();
                        bits = new Bits.MatchNoBits(mergeState.maxDocs[i]);
                    }
                    toMerge.add((NumericDocValues)values);
                    docsWithField.add(bits);
                }
                this.mergeBinaryField(mergeFieldInfo, mergeState, toMerge, docsWithField);
                continue;
            }
            if (type == DocValuesType.SORTED) {
                toMerge = new ArrayList();
                for (int i2 = 0; i2 < mergeState.docValuesProducers.length; ++i2) {
                    SortedDocValues values2 = null;
                    docValuesProducer = mergeState.docValuesProducers[i2];
                    if (docValuesProducer != null && (fieldInfo = mergeState.fieldInfos[i2].fieldInfo(mergeFieldInfo.name)) != null && fieldInfo.getDocValuesType() == DocValuesType.SORTED) {
                        values2 = docValuesProducer.getSorted(fieldInfo);
                    }
                    if (values2 == null) {
                        values2 = DocValues.emptySorted();
                    }
                    toMerge.add((NumericDocValues)((Object)values2));
                }
                this.mergeSortedField(mergeFieldInfo, mergeState, toMerge);
                continue;
            }
            if (type == DocValuesType.SORTED_SET) {
                toMerge = new ArrayList();
                for (int i3 = 0; i3 < mergeState.docValuesProducers.length; ++i3) {
                    SortedSetDocValues values3 = null;
                    docValuesProducer = mergeState.docValuesProducers[i3];
                    if (docValuesProducer != null && (fieldInfo = mergeState.fieldInfos[i3].fieldInfo(mergeFieldInfo.name)) != null && fieldInfo.getDocValuesType() == DocValuesType.SORTED_SET) {
                        values3 = docValuesProducer.getSortedSet(fieldInfo);
                    }
                    if (values3 == null) {
                        values3 = DocValues.emptySortedSet();
                    }
                    toMerge.add((NumericDocValues)((Object)values3));
                }
                this.mergeSortedSetField(mergeFieldInfo, mergeState, toMerge);
                continue;
            }
            if (type == DocValuesType.SORTED_NUMERIC) {
                toMerge = new ArrayList();
                for (int i4 = 0; i4 < mergeState.docValuesProducers.length; ++i4) {
                    SortedNumericDocValues values4 = null;
                    docValuesProducer = mergeState.docValuesProducers[i4];
                    if (docValuesProducer != null && (fieldInfo = mergeState.fieldInfos[i4].fieldInfo(mergeFieldInfo.name)) != null && fieldInfo.getDocValuesType() == DocValuesType.SORTED_NUMERIC) {
                        values4 = docValuesProducer.getSortedNumeric(fieldInfo);
                    }
                    if (values4 == null) {
                        values4 = DocValues.emptySortedNumeric(mergeState.maxDocs[i4]);
                    }
                    toMerge.add((NumericDocValues)((Object)values4));
                }
                this.mergeSortedNumericField(mergeFieldInfo, mergeState, toMerge);
                continue;
            }
            throw new AssertionError((Object)("type=" + (Object)((Object)type)));
        }
    }

    public void mergeNumericField(FieldInfo fieldInfo, final MergeState mergeState, final List<NumericDocValues> toMerge, final List<Bits> docsWithField) throws IOException {
        this.addNumericField(fieldInfo, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                return new Iterator<Number>(){
                    int readerUpto = -1;
                    int docIDUpto;
                    long nextValue;
                    boolean nextHasValue;
                    int currentMaxDoc;
                    NumericDocValues currentValues;
                    Bits currentLiveDocs;
                    Bits currentDocsWithField;
                    boolean nextIsSet;

                    @Override
                    public boolean hasNext() {
                        return this.nextIsSet || this.setNext();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Number next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        assert (this.nextIsSet);
                        this.nextIsSet = false;
                        return this.nextHasValue ? Long.valueOf(this.nextValue) : null;
                    }

                    private boolean setNext() {
                        while (this.readerUpto != toMerge.size()) {
                            if (this.docIDUpto == this.currentMaxDoc) {
                                ++this.readerUpto;
                                if (this.readerUpto < toMerge.size()) {
                                    this.currentValues = (NumericDocValues)toMerge.get(this.readerUpto);
                                    this.currentDocsWithField = (Bits)docsWithField.get(this.readerUpto);
                                    this.currentLiveDocs = mergeState.liveDocs[this.readerUpto];
                                    this.currentMaxDoc = mergeState.maxDocs[this.readerUpto];
                                }
                                this.docIDUpto = 0;
                                continue;
                            }
                            if (this.currentLiveDocs == null || this.currentLiveDocs.get(this.docIDUpto)) {
                                this.nextIsSet = true;
                                this.nextValue = this.currentValues.get(this.docIDUpto);
                                this.nextHasValue = this.nextValue != 0L || this.currentDocsWithField.get(this.docIDUpto);
                                ++this.docIDUpto;
                                return true;
                            }
                            ++this.docIDUpto;
                        }
                        return false;
                    }
                };
            }
        });
    }

    public void mergeBinaryField(FieldInfo fieldInfo, final MergeState mergeState, final List<BinaryDocValues> toMerge, final List<Bits> docsWithField) throws IOException {
        this.addBinaryField(fieldInfo, new Iterable<BytesRef>(){

            @Override
            public Iterator<BytesRef> iterator() {
                return new Iterator<BytesRef>(){
                    int readerUpto = -1;
                    int docIDUpto;
                    BytesRef nextValue;
                    BytesRef nextPointer;
                    int currentMaxDoc;
                    BinaryDocValues currentValues;
                    Bits currentLiveDocs;
                    Bits currentDocsWithField;
                    boolean nextIsSet;

                    @Override
                    public boolean hasNext() {
                        return this.nextIsSet || this.setNext();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public BytesRef next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        assert (this.nextIsSet);
                        this.nextIsSet = false;
                        return this.nextPointer;
                    }

                    private boolean setNext() {
                        while (this.readerUpto != toMerge.size()) {
                            if (this.docIDUpto == this.currentMaxDoc) {
                                ++this.readerUpto;
                                if (this.readerUpto < toMerge.size()) {
                                    this.currentValues = (BinaryDocValues)toMerge.get(this.readerUpto);
                                    this.currentDocsWithField = (Bits)docsWithField.get(this.readerUpto);
                                    this.currentLiveDocs = mergeState.liveDocs[this.readerUpto];
                                    this.currentMaxDoc = mergeState.maxDocs[this.readerUpto];
                                }
                                this.docIDUpto = 0;
                                continue;
                            }
                            if (this.currentLiveDocs == null || this.currentLiveDocs.get(this.docIDUpto)) {
                                this.nextIsSet = true;
                                this.nextPointer = this.currentDocsWithField.get(this.docIDUpto) ? (this.nextValue = this.currentValues.get(this.docIDUpto)) : null;
                                ++this.docIDUpto;
                                return true;
                            }
                            ++this.docIDUpto;
                        }
                        return false;
                    }
                };
            }
        });
    }

    public void mergeSortedNumericField(FieldInfo fieldInfo, final MergeState mergeState, List<SortedNumericDocValues> toMerge) throws IOException {
        final int numReaders = toMerge.size();
        final SortedNumericDocValues[] dvs = toMerge.toArray(new SortedNumericDocValues[numReaders]);
        this.addSortedNumericField(fieldInfo, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                return new Iterator<Number>(){
                    int readerUpto = -1;
                    int docIDUpto;
                    int nextValue;
                    int currentMaxDoc;
                    Bits currentLiveDocs;
                    boolean nextIsSet;

                    @Override
                    public boolean hasNext() {
                        return this.nextIsSet || this.setNext();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Number next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        assert (this.nextIsSet);
                        this.nextIsSet = false;
                        return this.nextValue;
                    }

                    private boolean setNext() {
                        while (this.readerUpto != numReaders) {
                            if (this.docIDUpto == this.currentMaxDoc) {
                                ++this.readerUpto;
                                if (this.readerUpto < numReaders) {
                                    this.currentLiveDocs = mergeState.liveDocs[this.readerUpto];
                                    this.currentMaxDoc = mergeState.maxDocs[this.readerUpto];
                                }
                                this.docIDUpto = 0;
                                continue;
                            }
                            if (this.currentLiveDocs == null || this.currentLiveDocs.get(this.docIDUpto)) {
                                this.nextIsSet = true;
                                SortedNumericDocValues dv = dvs[this.readerUpto];
                                dv.setDocument(this.docIDUpto);
                                this.nextValue = dv.count();
                                ++this.docIDUpto;
                                return true;
                            }
                            ++this.docIDUpto;
                        }
                        return false;
                    }
                };
            }
        }, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                return new Iterator<Number>(){
                    int readerUpto = -1;
                    int docIDUpto;
                    long nextValue;
                    int currentMaxDoc;
                    Bits currentLiveDocs;
                    boolean nextIsSet;
                    int valueUpto;
                    int valueLength;

                    @Override
                    public boolean hasNext() {
                        return this.nextIsSet || this.setNext();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Number next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        assert (this.nextIsSet);
                        this.nextIsSet = false;
                        return this.nextValue;
                    }

                    private boolean setNext() {
                        while (this.readerUpto != numReaders) {
                            if (this.valueUpto < this.valueLength) {
                                this.nextValue = dvs[this.readerUpto].valueAt(this.valueUpto);
                                ++this.valueUpto;
                                this.nextIsSet = true;
                                return true;
                            }
                            if (this.docIDUpto == this.currentMaxDoc) {
                                ++this.readerUpto;
                                if (this.readerUpto < numReaders) {
                                    this.currentLiveDocs = mergeState.liveDocs[this.readerUpto];
                                    this.currentMaxDoc = mergeState.maxDocs[this.readerUpto];
                                }
                                this.docIDUpto = 0;
                                continue;
                            }
                            if (this.currentLiveDocs == null || this.currentLiveDocs.get(this.docIDUpto)) {
                                assert (this.docIDUpto < this.currentMaxDoc);
                                SortedNumericDocValues dv = dvs[this.readerUpto];
                                dv.setDocument(this.docIDUpto);
                                this.valueUpto = 0;
                                this.valueLength = dv.count();
                                ++this.docIDUpto;
                                continue;
                            }
                            ++this.docIDUpto;
                        }
                        return false;
                    }
                };
            }
        });
    }

    public void mergeSortedField(FieldInfo fieldInfo, final MergeState mergeState, List<SortedDocValues> toMerge) throws IOException {
        final int numReaders = toMerge.size();
        final SortedDocValues[] dvs = toMerge.toArray(new SortedDocValues[numReaders]);
        TermsEnum[] liveTerms = new TermsEnum[dvs.length];
        long[] weights = new long[liveTerms.length];
        for (int sub = 0; sub < numReaders; ++sub) {
            SortedDocValues dv = dvs[sub];
            Bits liveDocs = mergeState.liveDocs[sub];
            int maxDoc = mergeState.maxDocs[sub];
            if (liveDocs == null) {
                liveTerms[sub] = dv.termsEnum();
                weights[sub] = dv.getValueCount();
                continue;
            }
            LongBitSet bitset = new LongBitSet(dv.getValueCount());
            for (int i = 0; i < maxDoc; ++i) {
                int ord;
                if (!liveDocs.get(i) || (ord = dv.getOrd(i)) < 0) continue;
                bitset.set(ord);
            }
            liveTerms[sub] = new BitsFilteredTermsEnum(dv.termsEnum(), bitset);
            weights[sub] = bitset.cardinality();
        }
        final MultiDocValues.OrdinalMap map = MultiDocValues.OrdinalMap.build(this, liveTerms, weights, 0.0f);
        this.addSortedField(fieldInfo, new Iterable<BytesRef>(){

            @Override
            public Iterator<BytesRef> iterator() {
                return new Iterator<BytesRef>(){
                    int currentOrd;

                    @Override
                    public boolean hasNext() {
                        return (long)this.currentOrd < map.getValueCount();
                    }

                    @Override
                    public BytesRef next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        int segmentNumber = map.getFirstSegmentNumber(this.currentOrd);
                        int segmentOrd = (int)map.getFirstSegmentOrd(this.currentOrd);
                        BytesRef term = dvs[segmentNumber].lookupOrd(segmentOrd);
                        ++this.currentOrd;
                        return term;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                return new Iterator<Number>(){
                    int readerUpto = -1;
                    int docIDUpto;
                    int nextValue;
                    int currentMaxDoc;
                    Bits currentLiveDocs;
                    LongValues currentMap;
                    boolean nextIsSet;

                    @Override
                    public boolean hasNext() {
                        return this.nextIsSet || this.setNext();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Number next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        assert (this.nextIsSet);
                        this.nextIsSet = false;
                        return this.nextValue;
                    }

                    private boolean setNext() {
                        while (this.readerUpto != numReaders) {
                            if (this.docIDUpto == this.currentMaxDoc) {
                                ++this.readerUpto;
                                if (this.readerUpto < numReaders) {
                                    this.currentMap = map.getGlobalOrds(this.readerUpto);
                                    this.currentLiveDocs = mergeState.liveDocs[this.readerUpto];
                                    this.currentMaxDoc = mergeState.maxDocs[this.readerUpto];
                                }
                                this.docIDUpto = 0;
                                continue;
                            }
                            if (this.currentLiveDocs == null || this.currentLiveDocs.get(this.docIDUpto)) {
                                this.nextIsSet = true;
                                int segOrd = dvs[this.readerUpto].getOrd(this.docIDUpto);
                                this.nextValue = segOrd == -1 ? -1 : (int)this.currentMap.get(segOrd);
                                ++this.docIDUpto;
                                return true;
                            }
                            ++this.docIDUpto;
                        }
                        return false;
                    }
                };
            }
        });
    }

    public void mergeSortedSetField(FieldInfo fieldInfo, final MergeState mergeState, List<SortedSetDocValues> toMerge) throws IOException {
        final SortedSetDocValues[] dvs = toMerge.toArray(new SortedSetDocValues[toMerge.size()]);
        final int numReaders = mergeState.maxDocs.length;
        TermsEnum[] liveTerms = new TermsEnum[dvs.length];
        long[] weights = new long[liveTerms.length];
        for (int sub = 0; sub < liveTerms.length; ++sub) {
            SortedSetDocValues dv = dvs[sub];
            Bits liveDocs = mergeState.liveDocs[sub];
            int maxDoc = mergeState.maxDocs[sub];
            if (liveDocs == null) {
                liveTerms[sub] = dv.termsEnum();
                weights[sub] = dv.getValueCount();
                continue;
            }
            LongBitSet bitset = new LongBitSet(dv.getValueCount());
            for (int i = 0; i < maxDoc; ++i) {
                long ord;
                if (!liveDocs.get(i)) continue;
                dv.setDocument(i);
                while ((ord = dv.nextOrd()) != -1L) {
                    bitset.set(ord);
                }
            }
            liveTerms[sub] = new BitsFilteredTermsEnum(dv.termsEnum(), bitset);
            weights[sub] = bitset.cardinality();
        }
        final MultiDocValues.OrdinalMap map = MultiDocValues.OrdinalMap.build(this, liveTerms, weights, 0.0f);
        this.addSortedSetField(fieldInfo, new Iterable<BytesRef>(){

            @Override
            public Iterator<BytesRef> iterator() {
                return new Iterator<BytesRef>(){
                    long currentOrd;

                    @Override
                    public boolean hasNext() {
                        return this.currentOrd < map.getValueCount();
                    }

                    @Override
                    public BytesRef next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        int segmentNumber = map.getFirstSegmentNumber(this.currentOrd);
                        long segmentOrd = map.getFirstSegmentOrd(this.currentOrd);
                        BytesRef term = dvs[segmentNumber].lookupOrd(segmentOrd);
                        ++this.currentOrd;
                        return term;
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        }, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                return new Iterator<Number>(){
                    int readerUpto = -1;
                    int docIDUpto;
                    int nextValue;
                    int currentMaxDoc;
                    Bits currentLiveDocs;
                    boolean nextIsSet;

                    @Override
                    public boolean hasNext() {
                        return this.nextIsSet || this.setNext();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Number next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        assert (this.nextIsSet);
                        this.nextIsSet = false;
                        return this.nextValue;
                    }

                    private boolean setNext() {
                        while (this.readerUpto != numReaders) {
                            if (this.docIDUpto == this.currentMaxDoc) {
                                ++this.readerUpto;
                                if (this.readerUpto < numReaders) {
                                    this.currentLiveDocs = mergeState.liveDocs[this.readerUpto];
                                    this.currentMaxDoc = mergeState.maxDocs[this.readerUpto];
                                }
                                this.docIDUpto = 0;
                                continue;
                            }
                            if (this.currentLiveDocs == null || this.currentLiveDocs.get(this.docIDUpto)) {
                                this.nextIsSet = true;
                                SortedSetDocValues dv = dvs[this.readerUpto];
                                dv.setDocument(this.docIDUpto);
                                this.nextValue = 0;
                                while (dv.nextOrd() != -1L) {
                                    ++this.nextValue;
                                }
                                ++this.docIDUpto;
                                return true;
                            }
                            ++this.docIDUpto;
                        }
                        return false;
                    }
                };
            }
        }, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                return new Iterator<Number>(){
                    int readerUpto = -1;
                    int docIDUpto;
                    long nextValue;
                    int currentMaxDoc;
                    Bits currentLiveDocs;
                    LongValues currentMap;
                    boolean nextIsSet;
                    long[] ords = new long[8];
                    int ordUpto;
                    int ordLength;

                    @Override
                    public boolean hasNext() {
                        return this.nextIsSet || this.setNext();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }

                    @Override
                    public Number next() {
                        if (!this.hasNext()) {
                            throw new NoSuchElementException();
                        }
                        assert (this.nextIsSet);
                        this.nextIsSet = false;
                        return this.nextValue;
                    }

                    private boolean setNext() {
                        while (this.readerUpto != numReaders) {
                            if (this.ordUpto < this.ordLength) {
                                this.nextValue = this.ords[this.ordUpto];
                                ++this.ordUpto;
                                this.nextIsSet = true;
                                return true;
                            }
                            if (this.docIDUpto == this.currentMaxDoc) {
                                ++this.readerUpto;
                                if (this.readerUpto < numReaders) {
                                    this.currentMap = map.getGlobalOrds(this.readerUpto);
                                    this.currentLiveDocs = mergeState.liveDocs[this.readerUpto];
                                    this.currentMaxDoc = mergeState.maxDocs[this.readerUpto];
                                }
                                this.docIDUpto = 0;
                                continue;
                            }
                            if (this.currentLiveDocs == null || this.currentLiveDocs.get(this.docIDUpto)) {
                                long ord;
                                assert (this.docIDUpto < this.currentMaxDoc);
                                SortedSetDocValues dv = dvs[this.readerUpto];
                                dv.setDocument(this.docIDUpto);
                                this.ordLength = 0;
                                this.ordUpto = 0;
                                while ((ord = dv.nextOrd()) != -1L) {
                                    if (this.ordLength == this.ords.length) {
                                        this.ords = ArrayUtil.grow(this.ords, this.ordLength + 1);
                                    }
                                    this.ords[this.ordLength] = this.currentMap.get(ord);
                                    ++this.ordLength;
                                }
                                ++this.docIDUpto;
                                continue;
                            }
                            ++this.docIDUpto;
                        }
                        return false;
                    }
                };
            }
        });
    }

    public static boolean isSingleValued(Iterable<Number> docToValueCount) {
        for (Number count : docToValueCount) {
            if (count.longValue() <= 1L) continue;
            return false;
        }
        return true;
    }

    public static Iterable<Number> singletonView(final Iterable<Number> docToValueCount, final Iterable<Number> values, final Number missingValue) {
        assert (DocValuesConsumer.isSingleValued(docToValueCount));
        return new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                final Iterator countIterator = docToValueCount.iterator();
                final Iterator valuesIterator = values.iterator();
                return new Iterator<Number>(){

                    @Override
                    public boolean hasNext() {
                        return countIterator.hasNext();
                    }

                    @Override
                    public Number next() {
                        int count = ((Number)countIterator.next()).intValue();
                        if (count == 0) {
                            return missingValue;
                        }
                        return (Number)valuesIterator.next();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    static class BitsFilteredTermsEnum
    extends FilteredTermsEnum {
        final LongBitSet liveTerms;

        BitsFilteredTermsEnum(TermsEnum in, LongBitSet liveTerms) {
            super(in, false);
            assert (liveTerms != null);
            this.liveTerms = liveTerms;
        }

        @Override
        protected FilteredTermsEnum.AcceptStatus accept(BytesRef term) throws IOException {
            if (this.liveTerms.get(this.ord())) {
                return FilteredTermsEnum.AcceptStatus.YES;
            }
            return FilteredTermsEnum.AcceptStatus.NO;
        }
    }
}

