/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jboss.as.clustering.controller.AddStepHandlerDescriptor;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.Registration;
import org.jboss.as.clustering.controller.RemoveStepHandlerDescriptor;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.controller.RestartParentResourceAddStepHandler;
import org.jboss.as.clustering.controller.RestartParentResourceRemoveStepHandler;
import org.jboss.as.clustering.controller.SimpleAttribute;
import org.jboss.as.clustering.controller.validation.IntRangeValidatorBuilder;
import org.jboss.as.clustering.controller.validation.LongRangeValidatorBuilder;
import org.jboss.as.clustering.controller.validation.ParameterValidatorBuilder;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsResourceDescriptionResolver;
import org.jboss.as.clustering.jgroups.subsystem.TransportConfigurationBuilderFactory;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.client.helpers.MeasurementUnit;
import org.jboss.as.controller.descriptions.DefaultResourceDescriptionProvider;
import org.jboss.as.controller.descriptions.DescriptionProvider;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public enum ThreadPoolResourceDefinition implements ResourceDefinition,
Registration<ManagementResourceRegistration>
{
    DEFAULT("default", "thread_pool", 20, 300, 100, 60L),
    OOB("oob", "oob_thread_pool", 20, 300, 0, 60L),
    INTERNAL("internal", "internal_thread_pool", 2, 4, 100, 60L),
    TIMER("timer", "timer", 2, 4, 500, 5L);

    static final PathElement WILDCARD_PATH;
    private final String name;
    private final String prefix;
    private final ResourceDescriptionResolver descriptionResolver;
    private final Attribute minThreads;
    private final Attribute maxThreads;
    private final Attribute queueLength;
    private final Attribute keepAliveTime;

    private static PathElement pathElement(String name) {
        return PathElement.pathElement((String)"thread-pool", (String)name);
    }

    private ThreadPoolResourceDefinition(String name, String prefix, int defaultMinThreads, int defaultMaxThreads, int defaultQueueLength, long defaultKeepaliveTime) {
        this.name = name;
        this.prefix = prefix;
        this.descriptionResolver = new JGroupsResourceDescriptionResolver(ThreadPoolResourceDefinition.pathElement("*"));
        this.minThreads = new SimpleAttribute((AttributeDefinition)ThreadPoolResourceDefinition.createBuilder("min-threads", ModelType.INT, new ModelNode(defaultMinThreads), (ParameterValidatorBuilder)new IntRangeValidatorBuilder().min(0)).build());
        this.maxThreads = new SimpleAttribute((AttributeDefinition)ThreadPoolResourceDefinition.createBuilder("max-threads", ModelType.INT, new ModelNode(defaultMaxThreads), (ParameterValidatorBuilder)new IntRangeValidatorBuilder().min(0)).build());
        this.queueLength = new SimpleAttribute((AttributeDefinition)ThreadPoolResourceDefinition.createBuilder("queue-length", ModelType.INT, new ModelNode(defaultQueueLength), (ParameterValidatorBuilder)new IntRangeValidatorBuilder().min(0)).build());
        this.keepAliveTime = new SimpleAttribute((AttributeDefinition)ThreadPoolResourceDefinition.createBuilder("keepalive-time", ModelType.LONG, new ModelNode(defaultKeepaliveTime), (ParameterValidatorBuilder)new LongRangeValidatorBuilder().min(0L)).build());
    }

    private static SimpleAttributeDefinitionBuilder createBuilder(String name, ModelType type, ModelNode defaultValue, ParameterValidatorBuilder validatorBuilder) {
        return (SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setAllowNull(true)).setDefaultValue(defaultValue)).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_RESOURCE_SERVICES})).setMeasurementUnit((MeasurementUnit)(type == ModelType.LONG ? MeasurementUnit.MILLISECONDS : null))).setValidator(validatorBuilder.allowExpression(true).allowUndefined(true).build());
    }

    public PathElement getPathElement() {
        return ThreadPoolResourceDefinition.pathElement(this.name);
    }

    public DescriptionProvider getDescriptionProvider(ImmutableManagementResourceRegistration registration) {
        return new DefaultResourceDescriptionProvider(registration, this.descriptionResolver);
    }

    public void register(ManagementResourceRegistration parentRegistration) {
        ManagementResourceRegistration registration = parentRegistration.registerSubModel((ResourceDefinition)this);
        ResourceDescriptor descriptor = new ResourceDescriptor(this.descriptionResolver).addAttributes(this.getAttributes());
        TransportConfigurationBuilderFactory transportBuilderFactory = new TransportConfigurationBuilderFactory();
        new RestartParentResourceAddStepHandler((ResourceServiceBuilderFactory)transportBuilderFactory, (AddStepHandlerDescriptor)descriptor).register(registration);
        new RestartParentResourceRemoveStepHandler((ResourceServiceBuilderFactory)transportBuilderFactory, (RemoveStepHandlerDescriptor)descriptor).register(registration);
    }

    public void registerAttributes(ManagementResourceRegistration registration) {
    }

    public void registerNotifications(ManagementResourceRegistration registration) {
    }

    public void registerChildren(ManagementResourceRegistration registration) {
    }

    public void registerOperations(ManagementResourceRegistration resourceRegistration) {
    }

    public List<AccessConstraintDefinition> getAccessConstraints() {
        return Collections.emptyList();
    }

    public boolean isRuntime() {
        return false;
    }

    public boolean isOrderedChild() {
        return false;
    }

    Collection<Attribute> getAttributes() {
        return Arrays.asList(this.minThreads, this.maxThreads, this.queueLength, this.keepAliveTime);
    }

    String getPrefix() {
        return this.prefix;
    }

    Attribute getMinThreads() {
        return this.minThreads;
    }

    Attribute getMaxThreads() {
        return this.maxThreads;
    }

    Attribute getQueueLength() {
        return this.queueLength;
    }

    Attribute getKeepAliveTime() {
        return this.keepAliveTime;
    }

    void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
    }

    static {
        WILDCARD_PATH = ThreadPoolResourceDefinition.pathElement("*");
    }
}

