/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import org.jboss.as.clustering.controller.AddStepHandlerDescriptor;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.CapabilityRegistration;
import org.jboss.as.clustering.controller.Registration;
import org.jboss.as.clustering.controller.ResourceServiceHandler;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;

public class AddStepHandler
extends AbstractAddStepHandler
implements Registration<ManagementResourceRegistration> {
    private final AddStepHandlerDescriptor descriptor;
    private final ResourceServiceHandler handler;
    private final OperationStepHandler writeAttributeHandler;

    public AddStepHandler(AddStepHandlerDescriptor descriptor) {
        this(descriptor, null);
    }

    public AddStepHandler(AddStepHandlerDescriptor descriptor, ResourceServiceHandler handler) {
        this(descriptor, handler, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(descriptor.getAttributes()));
    }

    AddStepHandler(AddStepHandlerDescriptor descriptor, ResourceServiceHandler handler, OperationStepHandler writeAttributeHandler) {
        super(descriptor.getAttributes());
        this.descriptor = descriptor;
        this.handler = handler;
        this.writeAttributeHandler = writeAttributeHandler;
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        for (AttributeDefinition definition : this.descriptor.getExtraParameters()) {
            definition.validateOperation(operation);
        }
        super.populateModel(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        if (this.handler != null) {
            this.handler.installServices(context, model);
        }
    }

    protected void rollbackRuntime(OperationContext context, ModelNode operation, Resource resource) {
        if (this.handler != null) {
            try {
                this.handler.removeServices(context, resource.getModel());
            }
            catch (OperationFailedException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        for (Capability capability : this.descriptor.getCapabilities()) {
            context.registerCapability(capability.getRuntimeCapability(address), null);
        }
        ModelNode model = resource.getModel();
        for (AttributeDefinition ad : this.attributes) {
            if (!model.hasDefined(ad.getName()) && !ad.hasCapabilityRequirements()) continue;
            ad.addCapabilityRequirements(context, model.get(ad.getName()));
        }
    }

    @Override
    public void register(ManagementResourceRegistration registration) {
        SimpleOperationDefinitionBuilder builder = new SimpleOperationDefinitionBuilder("add", this.descriptor.getDescriptionResolver()).withFlag(OperationEntry.Flag.RESTART_NONE);
        this.descriptor.getAttributes().forEach(attribute -> builder.addParameter(attribute));
        this.descriptor.getExtraParameters().forEach(attribute -> builder.addParameter(attribute));
        registration.registerOperationHandler((OperationDefinition)builder.build(), (OperationStepHandler)this);
        this.descriptor.getAttributes().forEach(attribute -> registration.registerReadWriteAttribute(attribute, null, this.writeAttributeHandler));
        new CapabilityRegistration(this.descriptor.getCapabilities()).register(registration);
    }
}

