/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.security.negotiation;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapContext;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginException;
import org.jboss.security.negotiation.AdvancedLdapLoginModule;
import org.picketbox.commons.cipher.Base64;

public class AdvancedADLoginModule
extends AdvancedLdapLoginModule {
    private static final String PRIMARY_GROUP_ID = "primaryGroupID";
    private static final String OBJECT_SID = "objectSid";
    private boolean skipPrimaryGroupSearch = false;

    public void initialize(Subject subject, CallbackHandler callbackHandler, Map sharedState, Map options) {
        super.initialize(subject, callbackHandler, sharedState, options);
    }

    protected Properties createBaseProperties() {
        Properties env = super.createBaseProperties();
        env.put("java.naming.ldap.attributes.binary", OBJECT_SID);
        return env;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void rolesSearch(LdapContext searchContext, String dn) throws LoginException {
        boolean TRACE = this.log.isTraceEnabled();
        if (!this.skipPrimaryGroupSearch) {
            this.skipPrimaryGroupSearch = true;
            try {
                String[] attrNames = new String[]{OBJECT_SID, PRIMARY_GROUP_ID};
                Attributes result = searchContext.getAttributes(dn, attrNames);
                Attribute primaryGroupIdAttribute = result.get(PRIMARY_GROUP_ID);
                Attribute objectSidAttribute = result.get(OBJECT_SID);
                if (primaryGroupIdAttribute != null && objectSidAttribute != null) {
                    Object[] filterArgs;
                    String primaryGroupFilter;
                    NamingEnumeration<SearchResult> searchResults;
                    int primaryGroupId = Integer.parseInt((String)primaryGroupIdAttribute.get());
                    byte[] objectSid = (byte[])objectSidAttribute.get();
                    byte[] searchObjectSid = new byte[objectSid.length];
                    System.arraycopy(objectSid, 0, searchObjectSid, 0, objectSid.length - 4);
                    ByteBuffer byteBuffer = ByteBuffer.wrap(searchObjectSid, objectSid.length - 4, 4);
                    byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
                    byteBuffer.putInt(primaryGroupId);
                    if (TRACE) {
                        String objectSidBase64 = Base64.encodeBytes((byte[])objectSid);
                        String searchObjectSidBase64 = Base64.encodeBytes((byte[])searchObjectSid);
                        this.log.trace((Object)("Using base objectSid " + objectSidBase64 + " and replaced with primary group id " + primaryGroupId + " to create new search objectSid " + searchObjectSidBase64));
                    }
                    if ((searchResults = searchContext.search(this.baseCtxDN, primaryGroupFilter = "(objectSid={0})", filterArgs = new Object[]{searchObjectSid}, this.roleSearchControls)).hasMore()) {
                        SearchResult searchResult = searchResults.next();
                        String baseResultDN = this.canonicalize(searchResult.getName());
                        String resultDN = "\"" + baseResultDN + "\"";
                        if (TRACE) {
                            this.log.trace((Object)("Search found primary group " + resultDN));
                        }
                        this.loadRoleByRoleNameAttributeID(searchContext, resultDN);
                        this.recurseRolesSearch(searchContext, baseResultDN);
                    }
                } else {
                    this.log.trace((Object)"primaryGroupIdAttribute or objectSidAttribute was null, skipping primary group search.");
                }
                super.rolesSearch(searchContext, dn);
                return;
            }
            catch (NamingException e) {
                if (!TRACE) return;
                this.log.trace((Object)"Failed to load primary group", (Throwable)e);
                return;
            }
            finally {
                this.skipPrimaryGroupSearch = false;
            }
        } else {
            super.rolesSearch(searchContext, dn);
        }
    }
}

