/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.network;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketAddress;
import org.jboss.as.network.ManagedBinding;
import org.jboss.as.network.ManagedBindingRegistry;

class ManagedSocketBinding
extends Socket
implements ManagedBinding {
    private final String name;
    private final ManagedBindingRegistry socketBindings;

    ManagedSocketBinding(ManagedBindingRegistry socketBindings) {
        this(null, socketBindings);
    }

    ManagedSocketBinding(String name, ManagedBindingRegistry socketBindings) {
        this.name = name;
        this.socketBindings = socketBindings;
    }

    @Override
    public String getSocketBindingName() {
        return this.name;
    }

    @Override
    public InetSocketAddress getBindAddress() {
        return new InetSocketAddress(this.getLocalAddress(), this.getPort());
    }

    @Override
    public void bind(SocketAddress bindpoint) throws IOException {
        super.bind(bindpoint);
        this.socketBindings.registerBinding(this);
    }

    @Override
    public synchronized void close() throws IOException {
        try {
            super.close();
        }
        finally {
            this.socketBindings.unregisterBinding(this);
        }
    }
}

