/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.global;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.MapAttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PrimitiveListAttributeDefinition;
import org.jboss.as.controller.PropertiesAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.operations.global.FilteredData;
import org.jboss.as.controller.operations.global.GlobalOperationHandlers;
import org.jboss.as.controller.operations.validation.EnumValidator;
import org.jboss.as.controller.operations.validation.StringLengthValidator;
import org.jboss.as.controller.registry.ImmutableManagementResourceRegistration;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.dmr.Property;

public final class QueryOperationHandler
extends GlobalOperationHandlers.AbstractMultiTargetHandler {
    public static final QueryOperationHandler INSTANCE = new QueryOperationHandler();
    public static final PropertiesAttributeDefinition WHERE_ATT = ((PropertiesAttributeDefinition.Builder)((PropertiesAttributeDefinition.Builder)new PropertiesAttributeDefinition.Builder("where", true).setCorrector(MapAttributeDefinition.LIST_TO_MAP_CORRECTOR)).setValidator(new StringLengthValidator(1, true, true))).build();
    private static final AttributeDefinition OPERATOR_ATT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("operator", ModelType.STRING).setAllowNull(true)).setDefaultValue(new ModelNode().set(Operator.AND.name()))).setValidator(EnumValidator.create(Operator.class, true, false))).build();
    private static final AttributeDefinition SELECT_ATT = ((PrimitiveListAttributeDefinition.Builder)new PrimitiveListAttributeDefinition.Builder("select", ModelType.STRING).setAllowNull(true)).build();
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("query", ControllerResolver.getResolver("global")).addParameter(SELECT_ATT).addParameter(WHERE_ATT).setReplyType(ModelType.LIST).setReplyValueType(ModelType.OBJECT).setReadOnly().build();

    private QueryOperationHandler() {
        super(null, true, new GlobalOperationHandlers.FilterPredicate(){

            @Override
            public boolean appliesTo(ModelNode item) {
                return !item.hasDefined("result");
            }
        });
    }

    @Override
    void doExecute(OperationContext parentContext, ModelNode operation, FilteredData filteredData, boolean ignoreMissingResources) throws OperationFailedException {
        WHERE_ATT.validateOperation(operation);
        OPERATOR_ATT.validateOperation(operation);
        SELECT_ATT.validateOperation(operation);
        ImmutableManagementResourceRegistration mrr = parentContext.getResourceRegistration();
        OperationStepHandler readResourceHandler = mrr.getOperationHandler(PathAddress.EMPTY_ADDRESS, "read-resource");
        ModelNode readResourceOp = new ModelNode();
        readResourceOp.get("address").set(operation.get("address"));
        readResourceOp.get("operation").set("read-resource");
        readResourceOp.get("include-runtime").set(true);
        parentContext.addStep(operation, FilterReduceHandler.INSTANCE, OperationContext.Stage.MODEL);
        parentContext.addStep(readResourceOp, readResourceHandler, OperationContext.Stage.MODEL);
    }

    static class FilterReduceHandler
    implements OperationStepHandler {
        static final FilterReduceHandler INSTANCE = new FilterReduceHandler();
        private static final String UNDEFINED = "undefined";

        FilterReduceHandler() {
        }

        @Override
        public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
            context.completeStep(new OperationContext.ResultHandler(){

                @Override
                public void handleResult(OperationContext.ResultAction resultAction, OperationContext context, ModelNode operation) {
                    if (operation.hasDefined("where")) {
                        try {
                            Operator operator = operation.hasDefined("operator") ? Operator.valueOf(operation.get("operator").asString()) : Operator.AND;
                            boolean matches = FilterReduceHandler.matchesFilter(context.getResult(), operation.get("where"), operator);
                            if (!matches) {
                                context.getResult().set(new ModelNode());
                            }
                        }
                        catch (Throwable t) {
                            context.getFailureDescription().set(t.getMessage());
                            context.setRollbackOnly();
                        }
                    }
                    if (operation.hasDefined("select") && context.hasResult() && context.getResult().isDefined()) {
                        try {
                            ModelNode reduced = this.reduce(context.getResult(), operation.get("select"));
                            context.getResult().set(reduced);
                        }
                        catch (OperationFailedException e) {
                            context.getFailureDescription().set(e.getMessage());
                            context.setRollbackOnly();
                        }
                    }
                }
            });
        }

        private static boolean matchesFilter(ModelNode resource, ModelNode filter, Operator operator) {
            boolean isMatching = false;
            List filterProperties = filter.asPropertyList();
            ArrayList<Boolean> matches = new ArrayList<Boolean>(filterProperties.size());
            for (Property property : filterProperties) {
                String filterName = property.getName();
                ModelNode filterValue = property.getValue();
                boolean isEqual = false;
                if (!filterValue.isDefined() || filterValue.asString().equals(UNDEFINED)) {
                    isEqual = !resource.get(filterName).isDefined();
                } else {
                    ModelType targetValueType = resource.get(filterName).getType();
                    try {
                        switch (targetValueType) {
                            case BOOLEAN: {
                                isEqual = filterValue.asBoolean() == resource.get(filterName).asBoolean();
                                break;
                            }
                            case LONG: {
                                isEqual = filterValue.asLong() == resource.get(filterName).asLong();
                                break;
                            }
                            case INT: {
                                isEqual = filterValue.asInt() == resource.get(filterName).asInt();
                                break;
                            }
                            case DOUBLE: {
                                isEqual = filterValue.asDouble() == resource.get(filterName).asDouble();
                                break;
                            }
                            default: {
                                isEqual = filterValue.equals(resource.get(filterName));
                                break;
                            }
                        }
                    }
                    catch (IllegalArgumentException e) {
                        throw ControllerLogger.MGMT_OP_LOGGER.validationFailedCouldNotConvertParamToType(filterName, targetValueType, "");
                    }
                }
                if (!isEqual) continue;
                matches.add(resource.get(filterName).equals(filterValue));
            }
            if (Operator.AND.equals((Object)operator)) {
                isMatching = matches.size() == filterProperties.size();
            } else if (Operator.OR.equals((Object)operator)) {
                for (Boolean match : matches) {
                    if (!match.booleanValue()) continue;
                    isMatching = true;
                    break;
                }
            } else {
                throw new IllegalArgumentException(ControllerLogger.MGMT_OP_LOGGER.invalidValue(operator.toString(), "operator", Arrays.asList(Operator.values())));
            }
            return isMatching;
        }

        private ModelNode reduce(ModelNode payload, ModelNode attributes) throws OperationFailedException {
            ModelNode outcome = new ModelNode();
            for (ModelNode attribute : attributes.asList()) {
                String name = attribute.asString();
                ModelNode value = payload.get(name);
                if (!value.isDefined()) continue;
                outcome.get(name).set(value);
            }
            return outcome;
        }
    }

    public static enum Operator {
        AND,
        OR;

    }
}

