/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.server.dispatcher;

import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import org.jboss.as.server.Services;
import org.jboss.marshalling.ClassResolver;
import org.jboss.marshalling.ClassTable;
import org.jboss.marshalling.MarshallingConfiguration;
import org.jboss.marshalling.ModularClassResolver;
import org.jboss.marshalling.ObjectTable;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoadException;
import org.jboss.modules.ModuleLoader;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;
import org.jgroups.Channel;
import org.wildfly.clustering.dispatcher.CommandDispatcherFactory;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.service.ChannelServiceName;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.jboss.DynamicClassTable;
import org.wildfly.clustering.marshalling.jboss.ExternalizerObjectTable;
import org.wildfly.clustering.marshalling.jboss.IndexExternalizer;
import org.wildfly.clustering.marshalling.jboss.MarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.MarshallingContext;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingConfigurationRepository;
import org.wildfly.clustering.marshalling.jboss.SimpleMarshallingContextFactory;
import org.wildfly.clustering.server.dispatcher.ChannelCommandDispatcherFactory;
import org.wildfly.clustering.server.dispatcher.ChannelCommandDispatcherFactoryConfiguration;
import org.wildfly.clustering.server.dispatcher.CommandDispatcherFactoryServiceNameProvider;
import org.wildfly.clustering.server.dispatcher.MarshallingConfigurationContext;
import org.wildfly.clustering.server.group.JGroupsNodeFactory;
import org.wildfly.clustering.service.AsynchronousServiceBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.spi.GroupServiceName;

public class ChannelCommandDispatcherFactoryBuilder
extends CommandDispatcherFactoryServiceNameProvider
implements Builder<CommandDispatcherFactory>,
Service<CommandDispatcherFactory>,
ChannelCommandDispatcherFactoryConfiguration,
MarshallingConfigurationContext {
    private final InjectedValue<ChannelFactory> channelFactory = new InjectedValue();
    private final InjectedValue<Channel> channel = new InjectedValue();
    private final InjectedValue<JGroupsNodeFactory> nodeFactory = new InjectedValue();
    private final InjectedValue<ModuleLoader> loader = new InjectedValue();
    private final ModuleIdentifier moduleId;
    private volatile Module module = null;
    private volatile MarshallingContext marshallingContext = null;
    private volatile ChannelCommandDispatcherFactory factory = null;
    private volatile long timeout = TimeUnit.MINUTES.toMillis(1L);

    public ChannelCommandDispatcherFactoryBuilder(String group, ModuleIdentifier moduleId) {
        super(group);
        this.moduleId = moduleId;
    }

    public ServiceBuilder<CommandDispatcherFactory> build(ServiceTarget target) {
        return new AsynchronousServiceBuilder(this.getServiceName(), (Service)this).build(target).addDependency(GroupServiceName.NODE_FACTORY.getServiceName(this.group), JGroupsNodeFactory.class, this.nodeFactory).addDependency(ChannelServiceName.CONNECTOR.getServiceName(this.group), Channel.class, this.channel).addDependency(ChannelServiceName.FACTORY.getServiceName(this.group), ChannelFactory.class, this.channelFactory).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ModuleLoader.class, this.loader).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public ChannelCommandDispatcherFactoryBuilder timeout(long value, TimeUnit unit) {
        this.timeout = unit.toMillis(value);
        return this;
    }

    public void start(StartContext context) throws StartException {
        try {
            this.module = this.getModuleLoader().loadModule(this.moduleId);
        }
        catch (ModuleLoadException e) {
            throw new StartException((Throwable)e);
        }
        this.marshallingContext = new SimpleMarshallingContextFactory().createMarshallingContext((MarshallingConfigurationRepository)new SimpleMarshallingConfigurationRepository(MarshallingVersion.class, (Enum)MarshallingVersion.CURRENT, (Object)this), (ClassLoader)this.module.getClassLoader());
        this.factory = new ChannelCommandDispatcherFactory(this);
    }

    public void stop(StopContext context) {
        this.factory.close();
        this.factory = null;
        this.marshallingContext = null;
    }

    public CommandDispatcherFactory getValue() {
        return this.factory;
    }

    @Override
    public Module getModule() {
        return this.module;
    }

    @Override
    public ModuleLoader getModuleLoader() {
        return (ModuleLoader)this.loader.getValue();
    }

    @Override
    public Channel getChannel() {
        return (Channel)this.channel.getValue();
    }

    @Override
    public JGroupsNodeFactory getNodeFactory() {
        return (JGroupsNodeFactory)this.nodeFactory.getValue();
    }

    @Override
    public MarshallingContext getMarshallingContext() {
        return this.marshallingContext;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public ChannelFactory getChannelFactory() {
        return (ChannelFactory)this.channelFactory.getValue();
    }

    static enum MarshallingVersion implements Function<MarshallingConfigurationContext, MarshallingConfiguration>
    {
        VERSION_1{

            @Override
            public MarshallingConfiguration apply(MarshallingConfigurationContext context) {
                MarshallingConfiguration config = new MarshallingConfiguration();
                config.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)context.getModuleLoader()));
                config.setClassTable((ClassTable)new DynamicClassTable((Externalizer)IndexExternalizer.UNSIGNED_BYTE, (ClassLoader)context.getModule().getClassLoader()));
                return config;
            }
        }
        ,
        VERSION_2{

            @Override
            public MarshallingConfiguration apply(MarshallingConfigurationContext context) {
                MarshallingConfiguration config = new MarshallingConfiguration();
                config.setClassResolver((ClassResolver)ModularClassResolver.getInstance((ModuleLoader)context.getModuleLoader()));
                config.setClassTable((ClassTable)new DynamicClassTable((ClassLoader)context.getModule().getClassLoader()));
                config.setObjectTable((ObjectTable)new ExternalizerObjectTable((ClassLoader)context.getModule().getClassLoader()));
                return config;
            }
        };

        static final MarshallingVersion CURRENT;

        static {
            CURRENT = VERSION_2;
        }
    }
}

