/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.commands.write;

import org.infinispan.commons.equivalence.Equivalence;
import org.infinispan.container.entries.MVCCEntry;

public enum ValueMatcher {
    MATCH_ALWAYS{

        @Override
        public boolean matches(MVCCEntry existingEntry, Object expectedValue, Object newValue, Equivalence valueEquivalence) {
            return true;
        }

        @Override
        public boolean nonExistentEntryCanMatch() {
            return true;
        }

        @Override
        public ValueMatcher matcherForRetry() {
            return MATCH_ALWAYS;
        }
    }
    ,
    MATCH_EXPECTED{

        @Override
        public boolean matches(MVCCEntry existingEntry, Object expectedValue, Object newValue, Equivalence valueEquivalence) {
            return this.equal(this.extractValue(existingEntry), expectedValue, valueEquivalence);
        }

        @Override
        public boolean nonExistentEntryCanMatch() {
            return true;
        }

        @Override
        public ValueMatcher matcherForRetry() {
            return MATCH_EXPECTED_OR_NEW;
        }
    }
    ,
    MATCH_EXPECTED_OR_NEW{

        @Override
        public boolean matches(MVCCEntry existingEntry, Object expectedValue, Object newValue, Equivalence valueEquivalence) {
            return this.equal(this.extractValue(existingEntry), expectedValue, valueEquivalence) || this.equal(this.extractValue(existingEntry), newValue, valueEquivalence);
        }

        @Override
        public boolean nonExistentEntryCanMatch() {
            return true;
        }

        @Override
        public ValueMatcher matcherForRetry() {
            return MATCH_EXPECTED_OR_NEW;
        }
    }
    ,
    MATCH_EXPECTED_OR_NULL{

        @Override
        public boolean matches(MVCCEntry existingEntry, Object expectedValue, Object newValue, Equivalence valueEquivalence) {
            return newValue == null || this.equal(this.extractValue(existingEntry), expectedValue, valueEquivalence);
        }

        @Override
        public boolean nonExistentEntryCanMatch() {
            return true;
        }

        @Override
        public ValueMatcher matcherForRetry() {
            return MATCH_EXPECTED_OR_NULL;
        }
    }
    ,
    MATCH_NON_NULL{

        @Override
        public boolean matches(MVCCEntry existingEntry, Object expectedValue, Object newValue, Equivalence valueEquivalence) {
            return this.extractValue(existingEntry) != null;
        }

        @Override
        public boolean nonExistentEntryCanMatch() {
            return false;
        }

        @Override
        public ValueMatcher matcherForRetry() {
            return MATCH_ALWAYS;
        }
    }
    ,
    MATCH_NEVER{

        @Override
        public boolean matches(MVCCEntry existingEntry, Object expectedValue, Object newValue, Equivalence valueEquivalence) {
            return false;
        }

        @Override
        public boolean nonExistentEntryCanMatch() {
            return false;
        }

        @Override
        public ValueMatcher matcherForRetry() {
            return MATCH_NEVER;
        }
    };


    public abstract boolean matches(MVCCEntry var1, Object var2, Object var3, Equivalence var4);

    public abstract boolean nonExistentEntryCanMatch();

    public abstract ValueMatcher matcherForRetry();

    protected Object extractValue(MVCCEntry mvccEntry) {
        return mvccEntry == null || mvccEntry.isRemoved() ? null : mvccEntry.getValue();
    }

    protected boolean equal(Object a, Object b, Equivalence valueEquivalence) {
        if (a == b) {
            return true;
        }
        return valueEquivalence != null ? valueEquivalence.equals(a, b) : a != null && a.equals(b);
    }
}

