/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.interceptor;

import java.util.stream.StreamSupport;
import org.infinispan.Cache;
import org.infinispan.CacheSet;
import org.infinispan.CacheStream;
import org.infinispan.commons.util.CloseableSpliterator;
import org.infinispan.distribution.DistributionManager;
import org.infinispan.stream.impl.AbstractDelegatingCacheSet;
import org.infinispan.stream.impl.local.LocalKeyCacheStream;

public abstract class AbstractDelegatingKeyCacheSet<K, V>
extends AbstractDelegatingCacheSet<K> {
    private final Cache<K, V> cache;
    private final CacheSet<K> set;

    protected AbstractDelegatingKeyCacheSet(Cache<K, V> cache, CacheSet<K> set) {
        this.cache = cache;
        this.set = set;
    }

    @Override
    protected final CacheSet<K> delegate() {
        return this.set;
    }

    @Override
    public CacheStream<K> stream() {
        return this.getStream(false);
    }

    @Override
    public CacheStream<K> parallelStream() {
        return this.getStream(true);
    }

    private CacheStream<K> getStream(boolean parallel) {
        DistributionManager dm = this.cache.getAdvancedCache().getDistributionManager();
        CloseableSpliterator closeableSpliterator = this.cache.getAdvancedCache().cacheEntrySet().spliterator();
        LocalKeyCacheStream<K, V> stream = new LocalKeyCacheStream<K, V>(this.cache, parallel, dm != null ? dm.getConsistentHash() : null, () -> StreamSupport.stream(closeableSpliterator, parallel), this.cache.getAdvancedCache().getComponentRegistry());
        stream.onClose(() -> closeableSpliterator.close());
        return stream;
    }
}

