/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.embedded;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.jboss.as.cli.CliEvent;
import org.jboss.as.cli.CliEventListener;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.embedded.Contexts;
import org.jboss.as.cli.embedded.EmbeddedServerLaunch;
import org.jboss.as.cli.embedded.EnvironmentRestorer;
import org.jboss.as.cli.embedded.StopEmbeddedServerHandler;
import org.jboss.as.cli.embedded.ThreadContextsModelControllerClient;
import org.jboss.as.cli.embedded.ThreadLocalContextSelector;
import org.jboss.as.cli.embedded.UncloseablePrintStream;
import org.jboss.as.cli.handlers.CommandHandlerWithArguments;
import org.jboss.as.cli.handlers.CommandHandlerWithHelp;
import org.jboss.as.cli.handlers.DefaultFilenameTabCompleter;
import org.jboss.as.cli.handlers.FilenameTabCompleter;
import org.jboss.as.cli.handlers.SimpleTabCompleter;
import org.jboss.as.cli.handlers.WindowsFilenameTabCompleter;
import org.jboss.as.cli.impl.ArgumentWithValue;
import org.jboss.as.cli.impl.ArgumentWithoutValue;
import org.jboss.as.cli.impl.FileSystemPathArgument;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.protocol.StreamUtils;
import org.jboss.dmr.ModelNode;
import org.jboss.logmanager.LogContext;
import org.jboss.logmanager.LogContextSelector;
import org.jboss.logmanager.PropertyConfigurator;
import org.jboss.modules.ModuleLoader;
import org.jboss.stdio.NullOutputStream;
import org.jboss.stdio.StdioContext;
import org.jboss.stdio.StdioContextSelector;
import org.wildfly.core.embedded.EmbeddedServerFactory;
import org.wildfly.core.embedded.EmbeddedServerReference;
import org.wildfly.security.manager.WildFlySecurityManager;

class EmbedServerHandler
extends CommandHandlerWithHelp {
    private static final String ECHO = "echo";
    private static final String DISCARD_STDOUT = "discard";
    private final AtomicReference<EmbeddedServerLaunch> serverReference;
    private ArgumentWithValue jbossHome;
    private ArgumentWithValue stdOutHandling;
    private ArgumentWithValue adminOnly;
    private ArgumentWithValue serverConfig;
    private ArgumentWithValue dashC;
    private ArgumentWithoutValue emptyConfig;
    private ArgumentWithoutValue removeExisting;
    private ArgumentWithValue timeout;

    static EmbedServerHandler create(AtomicReference<EmbeddedServerLaunch> serverReference, CommandContext ctx, boolean modular) {
        FilenameTabCompleter pathCompleter;
        EmbedServerHandler result = new EmbedServerHandler(serverReference);
        FilenameTabCompleter filenameTabCompleter = pathCompleter = Util.isWindows() ? new WindowsFilenameTabCompleter(ctx) : new DefaultFilenameTabCompleter(ctx);
        if (!modular) {
            result.jbossHome = new FileSystemPathArgument((CommandHandlerWithArguments)result, pathCompleter, "--jboss-home");
        }
        result.stdOutHandling = new ArgumentWithValue((CommandHandlerWithArguments)result, new SimpleTabCompleter(new String[]{ECHO, DISCARD_STDOUT}), "--std-out");
        result.serverConfig = new ArgumentWithValue(result, "--server-config");
        result.dashC = new ArgumentWithValue(result, "-c");
        result.dashC.addCantAppearAfter(result.serverConfig);
        result.serverConfig.addCantAppearAfter(result.dashC);
        result.adminOnly = new ArgumentWithValue((CommandHandlerWithArguments)result, SimpleTabCompleter.BOOLEAN, "--admin-only");
        result.emptyConfig = new ArgumentWithoutValue(result, "--empty-config");
        result.removeExisting = new ArgumentWithoutValue(result, "--remove-existing");
        result.removeExisting.addRequiredPreceding(result.emptyConfig);
        result.timeout = new ArgumentWithValue(result, "--timeout");
        return result;
    }

    private EmbedServerHandler(AtomicReference<EmbeddedServerLaunch> serverReference) {
        super("embed-server", false);
        assert (serverReference != null);
        this.serverReference = serverReference;
    }

    @Override
    public boolean isAvailable(CommandContext ctx) {
        return ctx.getModelControllerClient() == null;
    }

    @Override
    protected void recognizeArguments(CommandContext ctx) throws CommandFormatException {
        ParsedCommandLine parsedCmd = ctx.getParsedCommandLine();
        if (parsedCmd.getOtherProperties().size() > 1) {
            throw new CommandFormatException("The command accepts only one argument but received: " + parsedCmd.getOtherProperties());
        }
    }

    @Override
    protected void doHandle(CommandContext ctx) throws CommandLineException {
        boolean startEmpty;
        ParsedCommandLine parsedCmd = ctx.getParsedCommandLine();
        File jbossHome = this.getJBossHome(parsedCmd);
        String xml = this.serverConfig.getValue(parsedCmd);
        if (xml == null) {
            xml = this.dashC.getValue(parsedCmd);
        }
        boolean adminOnlySetting = true;
        String adminProp = this.adminOnly.getValue(parsedCmd);
        if (adminProp != null && "false".equalsIgnoreCase(adminProp)) {
            adminOnlySetting = false;
        }
        boolean removeConfig = (startEmpty = this.emptyConfig.isPresent(parsedCmd)) && this.removeExisting.isPresent(parsedCmd);
        List<String> args = parsedCmd.getOtherProperties();
        if (!args.isEmpty() && args.size() != 1) {
            throw new CommandFormatException("The command expects only one argument but got " + args);
        }
        Long bootTimeout = null;
        String timeoutString = this.timeout.getValue(parsedCmd);
        if (timeoutString != null) {
            bootTimeout = TimeUnit.SECONDS.toNanos(Long.parseLong(timeoutString));
        }
        EnvironmentRestorer restorer = new EnvironmentRestorer();
        boolean ok = false;
        ThreadLocalContextSelector contextSelector = null;
        try {
            Contexts defaultContexts = restorer.getDefaultContexts();
            StdioContext discardStdoutContext = null;
            if (!ECHO.equalsIgnoreCase(this.stdOutHandling.getValue(parsedCmd))) {
                UncloseablePrintStream nullStream = new UncloseablePrintStream((OutputStream)NullOutputStream.getInstance());
                StdioContext currentContext = defaultContexts.getStdioContext();
                discardStdoutContext = StdioContext.create((InputStream)currentContext.getIn(), (PrintStream)nullStream, (PrintStream)currentContext.getErr());
            }
            LogContext embeddedLogContext = LogContext.create();
            this.configureLogContext(embeddedLogContext, jbossHome, ctx);
            Contexts localContexts = new Contexts(embeddedLogContext, discardStdoutContext);
            contextSelector = new ThreadLocalContextSelector(localContexts, defaultContexts);
            contextSelector.pushLocal();
            StdioContext.setStdioContextSelector((StdioContextSelector)contextSelector);
            LogContext.setLogContextSelector((LogContextSelector)contextSelector);
            ArrayList<String> cmdsList = new ArrayList<String>();
            if (xml != null && xml.trim().length() > 0) {
                cmdsList.add("--server-config=" + xml.trim());
            }
            if (adminOnlySetting) {
                cmdsList.add("--admin-only");
            }
            if (startEmpty) {
                cmdsList.add("--internal-empty-config");
                if (removeConfig) {
                    cmdsList.add("--internal-remove-config");
                }
            }
            String[] cmds = cmdsList.toArray(new String[cmdsList.size()]);
            EmbeddedServerReference server = this.jbossHome == null ? EmbeddedServerFactory.createStandalone((ModuleLoader)ModuleLoader.forClass(this.getClass()), (File)jbossHome, (String[])cmds) : EmbeddedServerFactory.createStandalone((String)jbossHome.getAbsolutePath(), null, null, (String[])cmds);
            server.start();
            this.serverReference.set(new EmbeddedServerLaunch(server, restorer));
            ThreadContextsModelControllerClient mcc = new ThreadContextsModelControllerClient(server.getModelControllerClient(), contextSelector);
            if (bootTimeout == null || bootTimeout > 0L) {
                long expired = bootTimeout == null ? Long.MAX_VALUE : System.nanoTime() + bootTimeout;
                String status = "starting";
                ModelNode getStateOp = new ModelNode();
                getStateOp.get("operation").set("read-attribute");
                getStateOp.get("name").set("server-state");
                do {
                    try {
                        ModelNode response = mcc.execute(getStateOp);
                        if (Util.isSuccess(response)) {
                            status = response.get("result").asString();
                        }
                    }
                    catch (Exception response) {
                        // empty catch block
                    }
                    if (!"starting".equals(status)) break;
                    try {
                        Thread.sleep(50L);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new CommandLineException("Interrupted while waiting for embedded server to start");
                    }
                } while (System.nanoTime() < expired);
                if ("starting".equals(status)) {
                    assert (bootTimeout != null);
                    StopEmbeddedServerHandler.cleanup(this.serverReference);
                    throw new CommandLineException("Embedded server did not exit 'starting' status within " + TimeUnit.NANOSECONDS.toSeconds(bootTimeout) + " seconds");
                }
            }
            ctx.bindClient(mcc);
            ctx.addEventListener(new CliEventListener(){

                @Override
                public void cliEvent(CliEvent event, CommandContext ctx) {
                    if (event == CliEvent.DISCONNECTED) {
                        StopEmbeddedServerHandler.cleanup(EmbedServerHandler.this.serverReference);
                    }
                }
            });
            ok = true;
        }
        catch (Exception e) {
            throw new CommandLineException("Cannot start embedded server", e);
        }
        finally {
            if (!ok) {
                ctx.disconnectController();
                restorer.restoreEnvironment();
            } else if (contextSelector != null) {
                contextSelector.restore(null);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void configureLogContext(LogContext embeddedLogContext, File jbossHome, CommandContext ctx) {
        File standaloneDir = new File(jbossHome, "standalone");
        File configDir = new File(standaloneDir, "configuration");
        File logDir = new File(standaloneDir, "log");
        File bootLog = new File(logDir, "boot.log");
        File loggingProperties = new File(configDir, "logging.properties");
        if (loggingProperties.exists()) {
            WildFlySecurityManager.setPropertyPrivileged((String)"org.jboss.boot.log.file", (String)bootLog.getAbsolutePath());
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(loggingProperties);
                new PropertyConfigurator(embeddedLogContext).configure((InputStream)fis);
            }
            catch (IOException e) {
                try {
                    ctx.printLine("Unable to configure embedded server logging from " + loggingProperties);
                }
                catch (Throwable throwable) {
                    StreamUtils.safeClose(fis);
                    throw throwable;
                }
                StreamUtils.safeClose((Closeable)fis);
            }
            StreamUtils.safeClose((Closeable)fis);
        }
    }

    private File getJBossHome(ParsedCommandLine parsedCmd) throws CommandLineException {
        String jbossHome;
        String string = jbossHome = this.jbossHome == null ? null : this.jbossHome.getValue(parsedCmd);
        if (jbossHome == null || jbossHome.length() == 0) {
            jbossHome = WildFlySecurityManager.getEnvPropertyPrivileged((String)"JBOSS_HOME", null);
            if (jbossHome == null || jbossHome.length() == 0) {
                if (this.jbossHome != null) {
                    throw new CommandLineException("Missing configuration value for --jboss-home and environment variable JBOSS_HOME is not set");
                }
                throw new CommandLineException("Environment variable JBOSS_HOME is not set");
            }
            return EmbedServerHandler.validateJBossHome(jbossHome, "environment variable JBOSS_HOME");
        }
        return EmbedServerHandler.validateJBossHome(jbossHome, "argument --jboss-home");
    }

    private static File validateJBossHome(String jbossHome, String source) throws CommandLineException {
        File f = new File(jbossHome);
        if (!f.exists()) {
            throw new CommandLineException(String.format("File %s specified by %s does not exist", jbossHome, source));
        }
        if (!f.isDirectory()) {
            throw new CommandLineException(String.format("File %s specified by %s is not a directory", jbossHome, source));
        }
        return f;
    }
}

