/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.handlers.ifelse;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandLineException;
import org.jboss.as.cli.CommandLineRedirection;
import org.jboss.as.cli.Util;
import org.jboss.as.cli.batch.Batch;
import org.jboss.as.cli.batch.BatchManager;
import org.jboss.as.cli.handlers.ifelse.Operation;
import org.jboss.as.cli.operation.ParsedCommandLine;
import org.jboss.as.cli.parsing.command.CommandFormat;
import org.jboss.as.controller.client.ModelControllerClient;
import org.jboss.dmr.ModelNode;

class IfElseControlFlow
implements CommandLineRedirection {
    private static final String CTX_KEY = "IF";
    private CommandLineRedirection.Registration registration;
    private final Operation ifCondition;
    private final ModelNode ifRequest;
    private List<String> ifBlock;
    private List<String> elseBlock;
    private boolean inElse;

    static IfElseControlFlow get(CommandContext ctx) {
        return (IfElseControlFlow)ctx.get(CTX_KEY);
    }

    IfElseControlFlow(CommandContext ctx, Operation ifCondition, String ifRequest) throws CommandLineException {
        if (ifCondition == null) {
            throw new IllegalArgumentException("Condition is null");
        }
        if (ifRequest == null) {
            throw new IllegalArgumentException("Condition request is null");
        }
        this.ifCondition = ifCondition;
        this.ifRequest = ctx.buildRequest(ifRequest);
        ctx.set(CTX_KEY, this);
    }

    @Override
    public void set(CommandLineRedirection.Registration registration) {
        this.registration = registration;
    }

    @Override
    public void handle(CommandContext ctx) throws CommandLineException {
        ParsedCommandLine line = ctx.getParsedCommandLine();
        if (line.getFormat() == CommandFormat.INSTANCE) {
            if (line.hasProperty("--help") || line.hasProperty("-h")) {
                this.registration.handle(line);
                return;
            }
            String cmd = line.getOperationName();
            if ("else".equals(cmd) || "end-if".equals(cmd)) {
                this.registration.handle(line);
            } else {
                this.addLine(line);
            }
        } else {
            this.addLine(line);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void run(CommandContext ctx) throws CommandLineException {
        try {
            ModelNode targetValue;
            BatchManager batchManager = ctx.getBatchManager();
            if (batchManager.isBatchActive()) {
                throw new CommandLineException("if-else can't be executed as part of a batch.");
            }
            ModelControllerClient client = ctx.getModelControllerClient();
            if (client == null) {
                throw new CommandLineException("The connection to the controller has not been established.");
            }
            try {
                targetValue = client.execute(this.ifRequest);
            }
            catch (IOException e) {
                throw new CommandLineException("condition request failed", e);
            }
            Object value = this.ifCondition.resolveValue(ctx, targetValue);
            if (value == null) {
                throw new CommandLineException("if expression resolved to a null");
            }
            this.registration.unregister();
            if (Boolean.TRUE.equals(value)) {
                this.executeBlock(ctx, this.ifBlock, "if");
            } else if (this.inElse) {
                this.executeBlock(ctx, this.elseBlock, "else");
            }
        }
        finally {
            if (this.registration.isActive()) {
                this.registration.unregister();
            }
            ctx.remove(CTX_KEY);
        }
    }

    boolean isInIf() {
        return !this.inElse;
    }

    void moveToElse() {
        this.inElse = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeBlock(CommandContext ctx, List<String> block, String blockName) throws CommandLineException {
        if (block != null && !block.isEmpty()) {
            BatchManager batchManager = ctx.getBatchManager();
            if (!batchManager.activateNewBatch()) {
                throw new CommandLineException("Failed to activate a new batch");
            }
            Batch batch = batchManager.getActiveBatch();
            try {
                for (String l : block) {
                    ctx.handle(l);
                }
            }
            finally {
                batchManager.discardActiveBatch();
            }
            if (!batch.getCommands().isEmpty()) {
                ModelNode request = batch.toRequest();
                try {
                    ModelNode response = ctx.getModelControllerClient().execute(request);
                    if (!Util.isSuccess(response)) {
                        throw new CommandLineException(blockName + " request failed: " + Util.getFailureDescription(response));
                    }
                }
                catch (IOException e) {
                    throw new CommandLineException(blockName + " request failed", e);
                }
            }
        }
    }

    private void addLine(ParsedCommandLine line) {
        if (this.inElse) {
            if (this.elseBlock == null) {
                this.elseBlock = new ArrayList<String>();
            }
            this.elseBlock.add(line.getOriginalLine());
        } else {
            if (this.ifBlock == null) {
                this.ifBlock = new ArrayList<String>();
            }
            this.ifBlock.add(line.getOriginalLine());
        }
    }
}

