/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.client.serviceref;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.ws.WebServiceException;
import javax.xml.ws.handler.Handler;
import javax.xml.ws.handler.HandlerResolver;
import javax.xml.ws.handler.LogicalHandler;
import javax.xml.ws.handler.PortInfo;
import org.apache.cxf.Bus;
import org.apache.cxf.common.injection.ResourceInjector;
import org.apache.cxf.jaxws.handler.HandlerChainBuilder;
import org.apache.cxf.jaxws.handler.types.PortComponentHandlerType;
import org.apache.cxf.resource.DefaultResourceManager;
import org.apache.cxf.resource.ResourceManager;
import org.jboss.ws.common.DOMUtils;
import org.jboss.wsf.stack.cxf.Loggers;
import org.jboss.wsf.stack.cxf.Messages;
import org.jboss.wsf.stack.cxf.client.serviceref.SecurityActions;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class CXFHandlerResolverImpl
extends HandlerChainBuilder
implements HandlerResolver {
    private final Map<PortInfo, List<Handler>> handlerMap = new HashMap<PortInfo, List<Handler>>();
    private final String handlerFile;
    private final Class<?> clazz;
    private final ClassLoader classLoader;
    private final Bus bus;

    public CXFHandlerResolverImpl(Bus bus, String handlerFile, Class<?> clazz) {
        this.handlerFile = handlerFile;
        this.clazz = clazz;
        this.classLoader = clazz.getClassLoader();
        this.bus = bus;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Handler> getHandlerChain(PortInfo portInfo) {
        Map<PortInfo, List<Handler>> map = this.handlerMap;
        synchronized (map) {
            List<Handler> handlerChain = this.handlerMap.get(portInfo);
            if (handlerChain == null) {
                QName portQName = portInfo.getPortName();
                QName serviceQName = portInfo.getServiceName();
                String bindingId = portInfo.getBindingID();
                handlerChain = this.createHandlerChain(portInfo, portQName, serviceQName, bindingId);
                this.handlerMap.put(portInfo, handlerChain);
                for (Handler h : handlerChain) {
                    this.configHandler(h);
                }
            }
            return handlerChain;
        }
    }

    private void configHandler(Handler handler) {
        if (handler != null) {
            ResourceManager resourceManager = (ResourceManager)this.bus.getExtension(ResourceManager.class);
            List resolvers = resourceManager.getResourceResolvers();
            resourceManager = new DefaultResourceManager(resolvers);
            ResourceInjector injector = new ResourceInjector(resourceManager);
            injector.inject((Object)handler);
            injector.construct((Object)handler);
        }
    }

    private InputStream getInputStream() {
        return this.getInputStream(this.handlerFile, this.clazz);
    }

    protected List<Handler> createHandlerChain(PortInfo portInfo, QName portQName, QName serviceQName, String bindingID) {
        ArrayList<Handler> chain = new ArrayList<Handler>();
        InputStream is = this.getInputStream();
        try {
            if (is == null) {
                throw Messages.MESSAGES.handlerConfigFileNotFound(this.handlerFile);
            }
            Document doc = Holder.builder.parse(is);
            Element el = doc.getDocumentElement();
            if (!"http://java.sun.com/xml/ns/javaee".equals(el.getNamespaceURI()) || !"handler-chains".equals(el.getLocalName())) {
                throw Messages.MESSAGES.differentElementExpected(this.handlerFile, "{http://java.sun.com/xml/ns/javaee}handler-chains", "{" + el.getNamespaceURI() + "}" + el.getLocalName());
            }
            for (Node node = el.getFirstChild(); node != null; node = node.getNextSibling()) {
                if (!(node instanceof Element)) continue;
                el = (Element)node;
                if (!el.getNamespaceURI().equals("http://java.sun.com/xml/ns/javaee") || !el.getLocalName().equals("handler-chain")) {
                    throw Messages.MESSAGES.differentElementExpected(this.handlerFile, "{http://java.sun.com/xml/ns/javaee}handler-chain", "{" + el.getNamespaceURI() + "}" + el.getLocalName());
                }
                this.processHandlerChainElement(el, chain, portQName, serviceQName, bindingID);
            }
        }
        catch (WebServiceException e) {
            throw e;
        }
        catch (Exception e) {
            throw Messages.MESSAGES.noHandlerChainFound(this.handlerFile, e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        assert (chain != null);
        return this.sortHandlers(chain);
    }

    private void processHandlerChainElement(Element el, List<Handler> chain, QName portQName, QName serviceQName, String bindingID) {
        for (Node node = el.getFirstChild(); node != null; node = node.getNextSibling()) {
            Node cur = node;
            if (!(cur instanceof Element)) continue;
            el = (Element)cur;
            if (!el.getNamespaceURI().equals("http://java.sun.com/xml/ns/javaee")) {
                String xml = "{" + el.getNamespaceURI() + "}" + el.getLocalName();
                throw Messages.MESSAGES.invalidElementInHandler(this.handlerFile, xml);
            }
            String name = el.getLocalName();
            if ("port-name-pattern".equals(name)) {
                if (this.patternMatches(el, portQName)) continue;
                return;
            }
            if ("service-name-pattern".equals(name)) {
                if (this.patternMatches(el, serviceQName)) continue;
                return;
            }
            if (!"protocol-bindings".equals(name)) continue;
            if (this.protocolMatches(el, bindingID)) continue;
            return;
        }
    }

    private boolean protocolMatches(Element el, String id) {
        if (id == null) {
            return true;
        }
        String name = el.getTextContent().trim();
        if ("##SOAP11_HTTP".equals(name)) {
            return "http://schemas.xmlsoap.org/wsdl/soap/http".contains(id) || "http://schemas.xmlsoap.org/soap/".contains(id);
        }
        if ("##SOAP11_HTTP_MTOM".equals(name)) {
            return "http://schemas.xmlsoap.org/wsdl/soap/http?mtom=true".contains(id) || "http://schemas.xmlsoap.org/soap/?mtom=true".contains(id);
        }
        if ("##SOAP12_HTTP".equals(name)) {
            return "http://www.w3.org/2003/05/soap/bindings/HTTP/".contains(id) || "http://schemas.xmlsoap.org/wsdl/soap12/".contains(id);
        }
        if ("##SOAP12_HTTP_MTOM".equals(name)) {
            return "http://www.w3.org/2003/05/soap/bindings/HTTP/?mtom=true".contains(id) || "http://schemas.xmlsoap.org/wsdl/soap12/?mtom=true".contains(id);
        }
        if ("##XML_HTTP".equals(name)) {
            name = "http://www.w3.org/2004/08/wsdl/http";
        }
        return name.contains(id);
    }

    private boolean patternMatches(Element el, QName comp) {
        if (comp == null) {
            return true;
        }
        String namePattern = el.getTextContent().trim();
        if ("*".equals(namePattern)) {
            return true;
        }
        if (!namePattern.contains(":")) {
            throw Messages.MESSAGES.notAQNamePattern(this.handlerFile, namePattern);
        }
        String localPart = namePattern.substring(namePattern.indexOf(58) + 1, namePattern.length());
        String pfx = namePattern.substring(0, namePattern.indexOf(58));
        String ns = el.lookupNamespaceURI(pfx);
        if (ns == null) {
            ns = pfx;
        }
        if (!ns.equals(comp.getNamespaceURI())) {
            return false;
        }
        if (localPart.contains("*")) {
            return Pattern.matches(localPart, comp.getLocalPart());
        }
        return localPart.equals(comp.getLocalPart());
    }

    public List<Handler> sortHandlers(List<Handler> handlers) {
        ArrayList<LogicalHandler> logicalHandlers = new ArrayList<LogicalHandler>();
        ArrayList<Handler> protocolHandlers = new ArrayList<Handler>();
        for (Handler handler : handlers) {
            if (handler instanceof LogicalHandler) {
                logicalHandlers.add((LogicalHandler)handler);
                continue;
            }
            protocolHandlers.add(handler);
        }
        ArrayList<Handler> sortedHandlers = new ArrayList<Handler>();
        sortedHandlers.addAll(logicalHandlers);
        sortedHandlers.addAll(protocolHandlers);
        return sortedHandlers;
    }

    private InputStream getInputStream(String filename, Class<?> wsClass) {
        URL fileURL = null;
        try {
            fileURL = new URL(filename);
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (fileURL == null) {
            try {
                File file = new File(filename);
                if (file.exists()) {
                    fileURL = file.toURI().toURL();
                }
            }
            catch (MalformedURLException file) {
                // empty catch block
            }
        }
        if (fileURL == null) {
            fileURL = wsClass.getClassLoader().getResource(filename);
        }
        if (fileURL == null) {
            String filepath = filename;
            String packagePath = wsClass.getPackage().getName().replace('.', '/');
            String resourcePath = packagePath + "/" + filepath;
            while (filepath.startsWith("../")) {
                packagePath = packagePath.substring(0, packagePath.lastIndexOf("/"));
                filepath = filepath.substring(3);
                resourcePath = packagePath + "/" + filepath;
            }
            fileURL = wsClass.getClassLoader().getResource(resourcePath);
        }
        if (fileURL == null) {
            throw Messages.MESSAGES.cannotResolveHandlerFile(filename, wsClass.getName());
        }
        try {
            return fileURL.openStream();
        }
        catch (IOException ioe) {
            throw new WebServiceException((Throwable)ioe);
        }
    }

    private void processHandlerElement(Element el, List<Handler> chain) {
        try {
            JAXBContext ctx = Holder.context;
            PortComponentHandlerType pt = (PortComponentHandlerType)ctx.createUnmarshaller().unmarshal((Node)el, PortComponentHandlerType.class).getValue();
            chain.addAll(this.buildHandlerChain(pt, this.classLoader));
        }
        catch (JAXBException e) {
            e.printStackTrace();
        }
    }

    private static class Holder {
        static final DocumentBuilder builder = Holder.getDocumentBuilder();
        static final JAXBContext context = Holder.getContextForPortComponentHandlerType();

        private Holder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private static DocumentBuilder getDocumentBuilder() {
            DocumentBuilder builder;
            ClassLoader classLoader = SecurityActions.getContextClassLoader();
            SecurityActions.setContextClassLoader(CXFHandlerResolverImpl.class.getClassLoader());
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setValidating(false);
                factory.setNamespaceAware(true);
                factory.setExpandEntityReferences(false);
                try {
                    factory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                }
                catch (ParserConfigurationException pce) {
                    Loggers.DEPLOYMENT_LOGGER.error(pce);
                }
                builder = DOMUtils.newDocumentBuilder((DocumentBuilderFactory)factory);
            }
            finally {
                SecurityActions.setContextClassLoader(classLoader);
            }
            return builder;
        }

        private static JAXBContext getContextForPortComponentHandlerType() {
            JAXBContext context = null;
            try {
                context = JAXBContext.newInstance((Class[])new Class[]{PortComponentHandlerType.class});
            }
            catch (JAXBException e) {
                e.printStackTrace();
            }
            return context;
        }
    }
}

