/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller;

import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.dmr.ModelNode;
import org.wildfly.security.manager.WildFlySecurityManager;

class BlockingTimeout {
    public static final String SYSTEM_PROPERTY = "jboss.as.management.blocking.timeout";
    private static final int DEFAULT_TIMEOUT = 300;
    private static final String DEFAULT_TIMEOUT_STRING = Long.toString(300L);
    private static final int SHORT_TIMEOUT = 5000;
    private static String sysPropValue;
    private static int defaultValue;
    private final int blockingTimeout;
    private final int shortTimeout;
    private volatile boolean timeoutDetected;

    BlockingTimeout(ModelNode headerValue) {
        if (headerValue != null && headerValue.isDefined()) {
            Integer opHeaderValue = headerValue.asInt();
            if (opHeaderValue < 1) {
                throw ControllerLogger.MGMT_OP_LOGGER.invalidBlockingTimeout(opHeaderValue.longValue(), "blocking-timeout");
            }
            this.blockingTimeout = opHeaderValue * 1000;
        } else {
            this.blockingTimeout = BlockingTimeout.resolveDefaultTimeout();
        }
        this.shortTimeout = Math.min(this.blockingTimeout, 5000);
    }

    private static int resolveDefaultTimeout() {
        String propValue = WildFlySecurityManager.getPropertyPrivileged((String)SYSTEM_PROPERTY, (String)DEFAULT_TIMEOUT_STRING);
        if (sysPropValue == null || !sysPropValue.equals(propValue)) {
            sysPropValue = propValue;
            int number = -1;
            try {
                number = Integer.valueOf(sysPropValue);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            if (number > 0) {
                defaultValue = number * 1000;
            } else {
                ControllerLogger.MGMT_OP_LOGGER.invalidDefaultBlockingTimeout(sysPropValue, SYSTEM_PROPERTY, 300L);
                defaultValue = 300000;
            }
        }
        return defaultValue;
    }

    int getBlockingTimeout() {
        return this.timeoutDetected ? this.shortTimeout : this.blockingTimeout;
    }

    void timeoutDetected() {
        this.timeoutDetected = true;
    }
}

