/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server;

import io.undertow.connector.ByteBufferPool;
import io.undertow.connector.PooledByteBuffer;
import java.nio.ByteBuffer;
import org.xnio.Pool;
import org.xnio.Pooled;

public class XnioByteBufferPool
implements ByteBufferPool {
    private final Pool<ByteBuffer> pool;
    private final int bufferSize;

    public XnioByteBufferPool(Pool<ByteBuffer> pool) {
        this.pool = pool;
        Pooled buf = pool.allocate();
        this.bufferSize = ((ByteBuffer)buf.getResource()).remaining();
        buf.free();
    }

    @Override
    public PooledByteBuffer allocate() {
        final Pooled buf = this.pool.allocate();
        return new PooledByteBuffer(){
            private boolean open = true;

            @Override
            public ByteBuffer getBuffer() {
                return (ByteBuffer)buf.getResource();
            }

            @Override
            public void close() {
                this.open = false;
                buf.free();
            }

            @Override
            public boolean isOpen() {
                return this.open;
            }
        };
    }

    @Override
    public void close() {
    }

    @Override
    public int getBufferSize() {
        return this.bufferSize;
    }
}

