/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.postoffice.impl;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.DuplicateIDCache;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;

public class DuplicateIDCacheImpl
implements DuplicateIDCache {
    private final Map<ByteArrayHolder, Integer> cache = new ConcurrentHashMap<ByteArrayHolder, Integer>();
    private final SimpleString address;
    private final ArrayList<Pair<ByteArrayHolder, Long>> ids;
    private int pos;
    private final int cacheSize;
    private final StorageManager storageManager;
    private final boolean persist;

    public DuplicateIDCacheImpl(SimpleString address, int size, StorageManager storageManager, boolean persist) {
        this.address = address;
        this.cacheSize = size;
        this.ids = new ArrayList(size);
        this.storageManager = storageManager;
        this.persist = persist;
    }

    @Override
    public void load(List<Pair<byte[], Long>> theIds) throws Exception {
        int count = 0;
        long txID = -1L;
        for (Pair<byte[], Long> id : theIds) {
            if (count < this.cacheSize) {
                ByteArrayHolder bah = new ByteArrayHolder(id.getA());
                Pair<ByteArrayHolder, Long> pair = new Pair<ByteArrayHolder, Long>(bah, id.getB());
                this.cache.put(bah, this.ids.size());
                this.ids.add(pair);
            } else {
                if (txID == -1L) {
                    txID = this.storageManager.generateID();
                }
                this.storageManager.deleteDuplicateIDTransactional(txID, id.getB());
            }
            ++count;
        }
        if (txID != -1L) {
            this.storageManager.commit(txID);
        }
        this.pos = this.ids.size();
        if (this.pos == this.cacheSize) {
            this.pos = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteFromCache(byte[] duplicateID) throws Exception {
        ByteArrayHolder bah = new ByteArrayHolder(duplicateID);
        Integer posUsed = this.cache.remove(bah);
        if (posUsed != null) {
            DuplicateIDCacheImpl duplicateIDCacheImpl = this;
            synchronized (duplicateIDCacheImpl) {
                Pair<ByteArrayHolder, Long> id = this.ids.get(posUsed);
                if (id.getA().equals(bah)) {
                    id.setA(null);
                    this.storageManager.deleteDuplicateID(id.getB());
                    id.setB(null);
                }
            }
        }
    }

    @Override
    public boolean contains(byte[] duplID) {
        return this.cache.get(new ByteArrayHolder(duplID)) != null;
    }

    @Override
    public synchronized void addToCache(byte[] duplID, Transaction tx) throws Exception {
        long recordID = -1L;
        if (tx == null) {
            if (this.persist) {
                recordID = this.storageManager.generateID();
                this.storageManager.storeDuplicateID(this.address, duplID, recordID);
            }
            this.addToCacheInMemory(duplID, recordID);
        } else {
            if (this.persist) {
                recordID = this.storageManager.generateID();
                this.storageManager.storeDuplicateIDTransactional(tx.getID(), this.address, duplID, recordID);
                tx.setContainsPersistent();
            }
            tx.addOperation(new AddDuplicateIDOperation(duplID, recordID));
        }
    }

    @Override
    public void load(Transaction tx, byte[] duplID) {
        tx.addOperation(new AddDuplicateIDOperation(duplID, tx.getID()));
    }

    private synchronized void addToCacheInMemory(byte[] duplID, long recordID) {
        ByteArrayHolder holder = new ByteArrayHolder(duplID);
        this.cache.put(holder, this.pos);
        if (this.pos < this.ids.size()) {
            Pair<ByteArrayHolder, Long> id = this.ids.get(this.pos);
            if (id.getA() != null) {
                this.cache.remove(id.getA());
                if (id.getB() != null) {
                    try {
                        this.storageManager.deleteDuplicateID(id.getB());
                    }
                    catch (Exception e) {
                        ActiveMQServerLogger.LOGGER.errorDeletingDuplicateCache(e);
                    }
                }
            }
            id.setA(holder);
            id.setB(recordID >= 0L ? Long.valueOf(recordID) : null);
            holder.pos = this.pos;
        } else {
            Pair<ByteArrayHolder, Long> id = new Pair<ByteArrayHolder, Long>(holder, recordID >= 0L ? Long.valueOf(recordID) : null);
            this.ids.add(id);
            holder.pos = this.pos;
        }
        if (this.pos++ == this.cacheSize - 1) {
            this.pos = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() throws Exception {
        DuplicateIDCacheImpl duplicateIDCacheImpl = this;
        synchronized (duplicateIDCacheImpl) {
            if (this.ids.size() > 0) {
                long tx = this.storageManager.generateID();
                for (Pair<ByteArrayHolder, Long> id : this.ids) {
                    this.storageManager.deleteDuplicateIDTransactional(tx, id.getB());
                }
                this.storageManager.commit(tx);
            }
            this.ids.clear();
            this.cache.clear();
            this.pos = 0;
        }
    }

    @Override
    public List<Pair<byte[], Long>> getMap() {
        ArrayList<Pair<byte[], Long>> list = new ArrayList<Pair<byte[], Long>>();
        for (Pair<ByteArrayHolder, Long> id : this.ids) {
            list.add(new Pair<byte[], Long>(id.getA().bytes, id.getB()));
        }
        return list;
    }

    private static final class ByteArrayHolder {
        final byte[] bytes;
        int hash;
        int pos;

        ByteArrayHolder(byte[] bytes) {
            this.bytes = bytes;
        }

        public boolean equals(Object other) {
            if (other instanceof ByteArrayHolder) {
                ByteArrayHolder s = (ByteArrayHolder)other;
                if (this.bytes.length != s.bytes.length) {
                    return false;
                }
                for (int i = 0; i < this.bytes.length; ++i) {
                    if (this.bytes[i] == s.bytes[i]) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public int hashCode() {
            if (this.hash == 0) {
                for (byte b : this.bytes) {
                    this.hash = 31 * this.hash + b;
                }
            }
            return this.hash;
        }
    }

    private final class AddDuplicateIDOperation
    extends TransactionOperationAbstract {
        final byte[] duplID;
        final long recordID;
        volatile boolean done;

        AddDuplicateIDOperation(byte[] duplID, long recordID) {
            this.duplID = duplID;
            this.recordID = recordID;
        }

        private void process() {
            if (!this.done) {
                DuplicateIDCacheImpl.this.addToCacheInMemory(this.duplID, this.recordID);
                this.done = true;
            }
        }

        @Override
        public void afterCommit(Transaction tx) {
            this.process();
        }

        @Override
        public List<MessageReference> getRelatedMessageReferences() {
            return null;
        }
    }
}

