/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import java.util.Iterator;
import java.util.ServiceLoader;
import org.jboss.as.clustering.controller.ParentResourceServiceHandler;
import org.jboss.as.clustering.controller.ResourceServiceBuilderFactory;
import org.jboss.as.clustering.jgroups.subsystem.JGroupsBindingFactory;
import org.jboss.as.clustering.naming.BinderServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceTarget;
import org.jgroups.Channel;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;
import org.wildfly.clustering.jgroups.spi.service.ChannelBuilder;
import org.wildfly.clustering.jgroups.spi.service.ChannelConnectorBuilder;
import org.wildfly.clustering.jgroups.spi.service.ChannelServiceName;
import org.wildfly.clustering.jgroups.spi.service.ProtocolStackServiceName;
import org.wildfly.clustering.service.AliasServiceBuilder;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.spi.DistributedGroupBuilderProvider;
import org.wildfly.clustering.spi.GroupBuilderProvider;

public class ForkServiceHandler
extends ParentResourceServiceHandler<ChannelFactory> {
    ForkServiceHandler(ResourceServiceBuilderFactory<ChannelFactory> factory) {
        super(factory);
    }

    public void installServices(OperationContext context, ModelNode model) throws OperationFailedException {
        super.installServices(context, model);
        PathAddress address = context.getCurrentAddress();
        String name = address.getLastElement().getValue();
        String channel = address.getParent().getLastElement().getValue();
        ServiceTarget target = context.getServiceTarget();
        new AliasServiceBuilder(ChannelServiceName.FACTORY.getServiceName(name), ProtocolStackServiceName.CHANNEL_FACTORY.getServiceName(channel), ChannelFactory.class).build(target).install();
        new ChannelBuilder(name).build(target).install();
        new ChannelConnectorBuilder(name).build(target).install();
        new BinderServiceBuilder(JGroupsBindingFactory.createChannelBinding(name), ChannelServiceName.CHANNEL.getServiceName(name), Channel.class).build(target).install();
        for (GroupBuilderProvider groupBuilderProvider : ServiceLoader.load(DistributedGroupBuilderProvider.class, DistributedGroupBuilderProvider.class.getClassLoader())) {
            Iterator groupBuilders = groupBuilderProvider.getBuilders(channel, null).iterator();
            for (Builder groupBuilder : groupBuilderProvider.getBuilders(name, null)) {
                new AliasServiceBuilder(groupBuilder.getServiceName(), ((Builder)groupBuilders.next()).getServiceName(), Object.class).build(target).install();
            }
        }
    }

    public void removeServices(OperationContext context, ModelNode model) throws OperationFailedException {
        String name = context.getCurrentAddressValue();
        for (GroupBuilderProvider groupBuilderProvider : ServiceLoader.load(DistributedGroupBuilderProvider.class, DistributedGroupBuilderProvider.class.getClassLoader())) {
            for (Builder builder : groupBuilderProvider.getBuilders(name, null)) {
                context.removeService(builder.getServiceName());
            }
        }
        context.removeService(JGroupsBindingFactory.createChannelBinding(name).getBinderServiceName());
        for (ChannelServiceName factory : ChannelServiceName.values()) {
            context.removeService(factory.getServiceName(name));
        }
        super.removeServices(context, model);
    }
}

