/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.jgroups.subsystem;

import org.jboss.as.clustering.controller.CapabilityDependency;
import org.jboss.as.clustering.controller.RequiredCapability;
import org.jboss.as.clustering.controller.Requirement;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.clustering.jgroups.subsystem.AbstractProtocolConfigurationBuilder;
import org.jboss.as.clustering.jgroups.subsystem.ThreadPoolResourceDefinition;
import org.jboss.as.clustering.jgroups.subsystem.TransportResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.network.SocketBinding;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.jgroups.spi.TransportConfiguration;
import org.wildfly.clustering.service.Builder;
import org.wildfly.clustering.service.ValueDependency;

public class TransportConfigurationBuilder
extends AbstractProtocolConfigurationBuilder<TransportConfiguration>
implements TransportConfiguration {
    private ValueDependency<SocketBinding> diagnosticsSocketBinding;
    private boolean shared;
    private TransportConfiguration.Topology topology = null;

    public TransportConfigurationBuilder(String stackName, String name) {
        super(stackName, name);
    }

    @Override
    public ServiceBuilder<TransportConfiguration> build(ServiceTarget target) {
        ServiceBuilder builder = super.build(target);
        if (this.diagnosticsSocketBinding != null) {
            this.diagnosticsSocketBinding.register(builder);
        }
        return builder;
    }

    public TransportConfiguration getValue() {
        return this;
    }

    @Override
    public Builder<TransportConfiguration> configure(OperationContext context, ModelNode transport) throws OperationFailedException {
        final String machine = ModelNodes.asString((ModelNode)TransportResourceDefinition.Attribute.MACHINE.getDefinition().resolveModelAttribute(context, transport));
        final String rack = ModelNodes.asString((ModelNode)TransportResourceDefinition.Attribute.RACK.getDefinition().resolveModelAttribute(context, transport));
        final String site = ModelNodes.asString((ModelNode)TransportResourceDefinition.Attribute.SITE.getDefinition().resolveModelAttribute(context, transport));
        if (site != null || rack != null || machine != null) {
            this.topology = new TransportConfiguration.Topology(){

                public String getMachine() {
                    return machine;
                }

                public String getRack() {
                    return rack;
                }

                public String getSite() {
                    return site;
                }
            };
        }
        this.shared = TransportResourceDefinition.Attribute.SHARED.getDefinition().resolveModelAttribute(context, transport).asBoolean();
        String diagnosticsBinding = ModelNodes.asString((ModelNode)TransportResourceDefinition.Attribute.DIAGNOSTICS_SOCKET_BINDING.getDefinition().resolveModelAttribute(context, transport));
        if (diagnosticsBinding != null) {
            this.diagnosticsSocketBinding = new CapabilityDependency(context, (Requirement)RequiredCapability.SOCKET_BINDING, diagnosticsBinding, SocketBinding.class);
        }
        for (ThreadPoolResourceDefinition pool : ThreadPoolResourceDefinition.values()) {
            String prefix = pool.getPrefix();
            ModelNode model = transport.get(pool.getPathElement().getKeyValuePair());
            this.getProperties().put(prefix + ".min_threads", ((AttributeDefinition)pool.getMinThreads().getDefinition()).resolveModelAttribute(context, model).asString());
            this.getProperties().put(prefix + ".max_threads", ((AttributeDefinition)pool.getMaxThreads().getDefinition()).resolveModelAttribute(context, model).asString());
            int queueSize = ((AttributeDefinition)pool.getQueueLength().getDefinition()).resolveModelAttribute(context, model).asInt();
            if (pool != ThreadPoolResourceDefinition.TIMER) {
                this.getProperties().put(prefix + ".queue_enabled", String.valueOf(queueSize > 0));
            }
            this.getProperties().put(prefix + ".queue_max_size", String.valueOf(queueSize));
            this.getProperties().put(prefix + ".keep_alive_time", ((AttributeDefinition)pool.getKeepAliveTime().getDefinition()).resolveModelAttribute(context, model).asString());
            this.getProperties().put(prefix + ".rejection_policy", "abort");
        }
        return super.configure(context, transport);
    }

    public boolean isShared() {
        return this.shared;
    }

    public SocketBinding getDiagnosticsSocketBinding() {
        return this.diagnosticsSocketBinding != null ? (SocketBinding)this.diagnosticsSocketBinding.getValue() : null;
    }

    public TransportConfiguration.Topology getTopology() {
        return this.topology;
    }
}

