/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.messaging.logging;

import java.util.Collection;
import java.util.Set;
import javax.jms.IllegalStateRuntimeException;
import javax.xml.stream.XMLStreamException;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.messaging.Element;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.logging.BasicLogger;
import org.jboss.logging.Logger;
import org.jboss.logging.annotations.Cause;
import org.jboss.logging.annotations.LogMessage;
import org.jboss.logging.annotations.Message;
import org.jboss.logging.annotations.MessageLogger;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartException;

@MessageLogger(projectCode="WFLYMSG", length=4)
public interface MessagingLogger
extends BasicLogger {
    public static final MessagingLogger ROOT_LOGGER = (MessagingLogger)Logger.getMessageLogger(MessagingLogger.class, (String)"org.jboss.as.messaging");

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=1, value="AIO wasn't located on this platform, it will fall back to using pure Java NIO.")
    public void aioWarning();

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=2, value="Bound messaging object to jndi name %s")
    public void boundJndiName(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=3, value="Exception while stopping JMS server")
    public void errorStoppingJmsServer(@Cause Throwable var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=4, value="Failed to destroy %s: %s")
    public void failedToDestroy(@Cause Throwable var1, String var2, String var3);

    @LogMessage(level=Logger.Level.WARN)
    public void failedToDestroy(String var1, String var2);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=5, value="%s caught exception attempting to revert operation %s at address %s")
    public void revertOperationFailed(@Cause Throwable var1, String var2, String var3, PathAddress var4);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=6, value="Unbound messaging object to jndi name %s")
    public void unboundJndiName(String var1);

    @LogMessage(level=Logger.Level.ERROR)
    @Message(id=7, value="Could not close file %s")
    public void couldNotCloseFile(String var1, @Cause Throwable var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=8, value="Failed to unbind messaging object bound to jndi name %s in %d %s")
    public void failedToUnbindJndiName(String var1, long var2, String var4);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=9, value="Element %s is deprecated and will not be taken into account")
    public void deprecatedXMLElement(String var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=10, value="Attribute %s is deprecated and will not be taken into account")
    public void deprecatedXMLAttribute(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=11, value="Started %s %s")
    public void startedService(String var1, String var2);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=12, value="Stopped %s %s")
    public void stoppedService(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=13, value="Attribute %s of the resource at %s is deprecated and setting its value will not be taken into account")
    public void deprecatedAttribute(String var1, PathAddress var2);

    @Message(id=14, value="Can not change the clustered attribute to false: The hornetq-server resource at %s has cluster-connection children resources and will remain clustered.")
    public String canNotChangeClusteredAttribute(PathAddress var1);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=15, value="Ignoring %s property that is not a known property for pooled connection factory.")
    public void unknownPooledConnectionFactoryAttribute(String var1);

    @LogMessage(level=Logger.Level.INFO)
    @Message(id=16, value="Registered HTTP upgrade for %s protocol handled by %s acceptor")
    public void registeredHTTPUpgradeHandler(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=17, value="Element %s is deprecated and %s will be used in its place")
    public void deprecatedXMLElement(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=18, value="No connectors were explicitly defined for the pooled connection factory %s. Using %s as the connector.")
    public void connectorForPooledConnectionFactory(String var1, String var2);

    @Message(id=19, value="Alternative attribute of (%s) is already defined.")
    public String altAttributeAlreadyDefined(String var1);

    @Message(id=20, value="All attribute definitions must have the same xml name -- found %s but already had %s")
    public IllegalArgumentException attributeDefinitionsMustMatch(String var1, String var2);

    @Message(id=21, value="All attribute definitions must have unique names -- already found %s")
    public IllegalArgumentException attributeDefinitionsNotUnique(String var1);

    @Message(id=22, value="Cannot bind a null or empty string as jndi name")
    public IllegalArgumentException cannotBindJndiName();

    @Message(id=23, value="Operation cannot include both parameter %s and parameter %s")
    public String cannotIncludeOperationParameters(String var1, String var2);

    @Message(id=24, value="%s cannot be marshalled as an attribute; use marshallAsElement")
    public UnsupportedOperationException cannotMarshalAttribute(String var1);

    @Message(id=25, value="Cannot unbind a null or empty string as jndi name")
    public IllegalArgumentException cannotUnbindJndiName();

    @Message(id=26, value="A child resource of type %1$s already exists; the messaging subsystem only allows a single resource of type %1$s")
    public String childResourceAlreadyExists(String var1);

    @Message(id=27, value="Connector %s not defined")
    public IllegalStateException connectorNotDefined(String var1);

    @Message(id=28, value="Failed to create %s")
    public StartException failedToCreate(@Cause Throwable var1, String var2);

    @Message(id=29, value="Failed to find SocketBinding for broadcast binding: %s")
    public StartException failedToFindBroadcastSocketBinding(String var1);

    @Message(id=30, value="Failed to find SocketBinding for connector: %s")
    public StartException failedToFindConnectorSocketBinding(String var1);

    @Message(id=31, value="Failed to find SocketBinding for discovery binding: %s")
    public StartException failedToFindDiscoverySocketBinding(String var1);

    @Message(id=32, value="Failed to shutdown %s server")
    public RuntimeException failedToShutdownServer(@Cause Throwable var1, String var2);

    @Message(id=33, value="Failed to start service")
    public StartException failedToStartService(@Cause Throwable var1);

    @Message(id=34, value="Ignoring unhandled element: %s, at: %s")
    public XMLStreamException ignoringUnhandledElement(Element var1, String var2);

    @Message(id=35, value="Illegal element %s: cannot be used when %s is used")
    public String illegalElement(String var1, String var2);

    @Message(id=36, value="Illegal value %s for element %s")
    public String illegalValue(Object var1, String var2);

    @Message(id=-1, value="Illegal value %s for element %s as it could not be converted to required type %s")
    public String illegalValue(Object var1, String var2, ModelType var3);

    @Message(id=37, value="Resource is immutable")
    public UnsupportedOperationException immutableResource();

    @Message(id=38, value="%s is invalid")
    public String invalid(Object var1);

    @Message(id=39, value="Attribute %s has unexpected type %s")
    public IllegalStateException invalidAttributeType(String var1, ModelType var2);

    @Message(id=40, value="Operation must include parameter %s or parameter %s")
    public String invalidOperationParameters(String var1, String var2);

    @Message(id=41, value="%s is an invalid value for parameter %s. Values must be one of: %s")
    public String invalidParameterValue(Object var1, String var2, Collection<?> var3);

    @Message(id=42, value="Service %s is not in state %s, it is in state %s")
    public IllegalStateException invalidServiceState(ServiceName var1, ServiceController.State var2, ServiceController.State var3);

    @Message(id=43, value="JNDI name %s is already registered")
    public String jndiNameAlreadyRegistered(String var1);

    @Message(id=44, value="Multiple %s children found; only one is allowed")
    public IllegalStateException multipleChildrenFound(String var1);

    @Message(id=45, value="%s is required")
    public String required(Object var1);

    @Message(id=46, value="Either %s or %s is required")
    public String required(Object var1, Object var2);

    @Message(id=47, value="%s is null")
    public IllegalArgumentException nullVar(String var1);

    @Message(id=48, value="Parameter not defined: %s")
    public String parameterNotDefined(Object var1);

    @Message(id=49, value="No such attribute (%s)")
    public String unknownAttribute(String var1);

    @Message(id=50, value="Read support for attribute %s was not properly implemented")
    public IllegalStateException unsupportedAttribute(String var1);

    @Message(id=51, value="Implement support for element %s")
    public UnsupportedOperationException unsupportedElement(String var1);

    @Message(id=52, value="Support for operation %s was not properly implemented")
    public IllegalStateException unsupportedOperation(String var1);

    @Message(id=53, value="Runtime handling for %s is not implemented")
    public UnsupportedOperationException unsupportedRuntimeAttribute(String var1);

    @Message(id=54, value="No HornetQ Server is available under name %s")
    public OperationFailedException hornetQServerNotInstalled(String var1);

    @Message(id=55, value="Could not parse file %s")
    public DeploymentUnitProcessingException couldNotParseDeployment(String var1, @Cause Throwable var2);

    @Message(id=56, value="Handler cannot handle operation %s")
    public IllegalStateException operationNotValid(String var1);

    @Message(id=57, value="No message destination registered at address %s")
    public String noDestinationRegisteredForAddress(PathAddress var1);

    @Message(id=58, value="SecurityDomainContext has not been set")
    public IllegalStateException securityDomainContextNotSet();

    @Message(id=59, value="Only one of %s or %s is required")
    public String onlyOneRequired(Object var1, Object var2);

    @Message(id=60, value="Failed to recover %s")
    public OperationFailedException failedToRecover(@Cause Throwable var1, String var2);

    @Message(id=61, value="Attribute(s) %s are not supported by messaging management model %s")
    public String unsupportedAttributeInVersion(String var1, ModelVersion var2);

    @Message(id=62, value="The clustered attribute is deprecated. To create a clustered HornetQ server, define at least one cluster-connection")
    public UnsupportedOperationException canNotWriteClusteredAttribute();

    @Message(id=63, value="Resources of type %s cannot be registered")
    public UnsupportedOperationException canNotRegisterResourceOfType(String var1);

    @Message(id=64, value="Resources of type %s cannot be removed")
    public UnsupportedOperationException canNotRemoveResourceOfType(String var1);

    @Message(id=65, value="No resource exists at address %s")
    public String hqServerManagementServiceResourceNotFound(PathAddress var1);

    @Message(id=66, value="Resource at the address %s can not be managed, the hornetq-server is in backup mode")
    public String hqServerInBackupMode(PathAddress var1);

    @Message(id=67, value="The broadcast group '%s' defines reference to nonexistent connector '%s'. Available connectors '%s'.")
    public OperationFailedException wrongConnectorRefInBroadCastGroup(String var1, String var2, Collection<String> var3);

    @Message(id=68, value="It is not permitted to call this method on injected JMSContext (see JMS 2.0 spec, \u00a712.4.5).")
    public IllegalStateRuntimeException callNotPermittedOnInjectedJMSContext();

    @Message(id=69, value="Attribute (%s) can not been undefined as the resource does not define any alternative to this attribute.")
    public String undefineAttributeWithoutAlternative(String var1);

    @Message(id=70, value="Attributes %s is an alias for attribute %s; both cannot be set with conflicting values.")
    public OperationFailedException inconsistentStatisticsSettings(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=71, value="There is no resource matching the expiry-address %s for the address-settings %s, expired messages from destinations matching this address-setting will be lost!")
    public void noMatchingExpiryAddress(String var1, String var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=72, value="There is no resource matching the dead-letter-address %s for the address-settings %s, undelivered messages from destinations matching this address-setting will be lost!")
    public void noMatchingDeadLetterAddress(String var1, String var2);

    @Message(id=73, value="Can not remove JNDI name %s. The resource must have at least one JNDI name")
    public String canNotRemoveLastJNDIName(String var1);

    @Message(id=74, value="Invalid parameter key: %s, the allowed keys are %s.")
    public OperationFailedException invalidParameterName(String var1, Set<String> var2);

    @LogMessage(level=Logger.Level.WARN)
    @Message(id=75, value="AIO wasn't located on this platform, it will fall back to using pure Java NIO. Your platform is Linux, install LibAIO to enable the AIO journal.")
    public void aioWarningLinux();

    @Message(id=76, value="Parameter %s contains duplicate elements [%s]")
    public OperationFailedException duplicateElements(String var1, ModelNode var2);

    @Message(id=77, value="Can not remove unknown entry %s")
    public OperationFailedException canNotRemoveUnknownEntry(String var1);

    @Message(id=78, value="Indexed child resources can only be registered if the parent resource supports ordered children. The parent of '%s' is not indexed")
    public IllegalStateException indexedChildResourceRegistrationNotAvailable(PathElement var1);

    @Message(id=79, value="The migrate operation can not be performed: the server must be in admin-only mode")
    public OperationFailedException migrateOperationAllowedOnlyInAdminOnly();

    @Message(id=80, value="Could not migrate attribute %s from resource %s. Use instead the socket-attribute to configure this broadcast-group.")
    public String couldNotMigrateBroadcastGroupAttribute(String var1, PathAddress var2);

    @Message(id=81, value="Migration failed, see results for more details.")
    public String migrationFailed();

    @Message(id=82, value="Classes providing the %s are discarded during the migration. To use them in the new messaging-activemq subsystem, you will have to extend the Artemis-based Interceptor.")
    public String couldNotMigrateInterceptors(String var1);

    @Message(id=83, value="Could not migrate the HA configuration of %s. Its shared-store and backup attributes holds expressions and it is not possible to determine unambiguously how to create the corresponding ha-policy for the messaging-activemq's server.")
    public String couldNotMigrateHA(PathAddress var1);

    @Message(id=84, value="Could not migrate attribute %s from resource %s. Use instead the socket-attribute to configure this discovery-group.")
    public String couldNotMigrateDiscoveryGroupAttribute(String var1, PathAddress var2);

    @Message(id=85, value="Could not create a legacy-connection-factory based on connection-factory %s. It used a HornetQ in-vm connector that is not compatible with Artemis in-vm connector ")
    public String couldNotCreateLegacyConnectionFactoryUsingInVMConnector(PathAddress var1);

    @Message(id=86, value="Could not migrate attribute %s from resource %s. The attribute uses an expression that can be resolved differently depending on system properties. To be able to migrate this property, replace the expression by an actual value.")
    public String couldNotMigrateResourceAttributeWithExpression(String var1, PathAddress var2);
}

