/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan;

import java.nio.ByteBuffer;
import org.infinispan.remoting.responses.CacheNotFoundResponse;
import org.infinispan.remoting.transport.jgroups.CommandAwareRpcDispatcher;
import org.infinispan.remoting.transport.jgroups.JGroupsTransport;
import org.infinispan.remoting.transport.jgroups.MarshallerAdapter;
import org.jgroups.Channel;
import org.jgroups.blocks.RpcDispatcher;
import org.wildfly.clustering.jgroups.spi.ChannelFactory;

public class ChannelTransport
extends JGroupsTransport {
    private final Channel channel;
    private final ChannelFactory factory;

    public ChannelTransport(Channel channel, ChannelFactory factory) {
        this.channel = channel;
        this.factory = factory;
        this.connectChannel = true;
        this.disconnectChannel = true;
        this.closeChannel = false;
    }

    protected void initRPCDispatcher() {
        this.dispatcher = new CommandAwareRpcDispatcher(this.channel, (JGroupsTransport)this, this.globalHandler, this.getTimeoutExecutor());
        MarshallerAdapter adapter = new MarshallerAdapter(this.marshaller){

            public Object objectFromBuffer(byte[] buffer, int offset, int length) throws Exception {
                return ChannelTransport.this.isUnknownForkResponse(ByteBuffer.wrap(buffer, offset, length)) ? CacheNotFoundResponse.INSTANCE : super.objectFromBuffer(buffer, offset, length);
            }
        };
        this.dispatcher.setRequestMarshaller((RpcDispatcher.Marshaller)adapter);
        this.dispatcher.setResponseMarshaller((RpcDispatcher.Marshaller)adapter);
        this.dispatcher.start();
    }

    boolean isUnknownForkResponse(ByteBuffer response) {
        return this.factory.isUnknownForkResponse(response);
    }

    protected void initChannel() {
        ((JGroupsTransport)this).channel = this.channel;
        ((JGroupsTransport)this).channel.setDiscardOwnMessages(false);
    }
}

