/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ee.utils;

import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.modules.Module;
import org.wildfly.security.manager.WildFlySecurityManager;

public class ClassLoadingUtils {
    public static Class<?> loadClass(String className, DeploymentUnit du) throws ClassNotFoundException {
        return ClassLoadingUtils.loadClass(className, (Module)du.getAttachment(Attachments.MODULE));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Class<?> loadClass(String className, Module module) throws ClassNotFoundException {
        ClassLoader oldTccl = WildFlySecurityManager.getCurrentContextClassLoaderPrivileged();
        try {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)module.getClassLoader());
            Class<?> clazz = Class.forName(className, false, (ClassLoader)module.getClassLoader());
            return clazz;
        }
        finally {
            WildFlySecurityManager.setCurrentContextClassLoaderPrivileged((ClassLoader)oldTccl);
        }
    }

    private ClassLoadingUtils() {
    }
}

