/*
 * Decompiled with CFR 0.152.
 */
package org.picketlink.identity.federation.api.saml.v2.metadata;

import java.io.StringWriter;
import java.io.Writer;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.xml.stream.XMLStreamWriter;
import org.picketlink.common.exceptions.ProcessingException;
import org.picketlink.common.util.StaxUtil;
import org.picketlink.identity.federation.api.saml.v2.metadata.SecurityActions;
import org.picketlink.identity.federation.core.saml.v2.util.SAMLMetadataUtil;
import org.picketlink.identity.federation.core.saml.v2.writers.SAMLMetadataWriter;
import org.picketlink.identity.federation.saml.v2.metadata.EndpointType;
import org.picketlink.identity.federation.saml.v2.metadata.EntityDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.IDPSSODescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.IndexedEndpointType;
import org.picketlink.identity.federation.saml.v2.metadata.KeyDescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.SPSSODescriptorType;
import org.picketlink.identity.federation.saml.v2.metadata.SSODescriptorType;

public class MetaDataExtractor {
    public static String LINE_SEPARATOR = SecurityActions.getSystemProperty("line.separator", "\n");

    public static X509Certificate getCertificate(KeyDescriptorType keyDescriptor) {
        try {
            return SAMLMetadataUtil.getCertificate(keyDescriptor);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static String toString(EntityDescriptorType edt) {
        StringWriter sw = new StringWriter();
        try {
            XMLStreamWriter writer = StaxUtil.getXMLStreamWriter((Writer)sw);
            SAMLMetadataWriter metaWriter = new SAMLMetadataWriter(writer);
            metaWriter.writeEntityDescriptor(edt);
        }
        catch (ProcessingException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    public static String toString(IDPSSODescriptorType idp) {
        StringBuilder builder = new StringBuilder();
        builder.append(LINE_SEPARATOR);
        IDPSSODescriptorType sdt = idp;
        builder.append(MetaDataExtractor.toString((SSODescriptorType)sdt));
        List<EndpointType> ssoServices = idp.getSingleSignOnService();
        if (ssoServices != null) {
            builder.append("Single Sign On Services are:[");
            for (EndpointType edt : ssoServices) {
                builder.append(MetaDataExtractor.toString(edt));
            }
            builder.append("]");
            builder.append(LINE_SEPARATOR);
        }
        return builder.toString();
    }

    public static String toString(SPSSODescriptorType sp) {
        StringBuilder builder = new StringBuilder();
        builder.append(LINE_SEPARATOR);
        SPSSODescriptorType sdt = sp;
        builder.append(MetaDataExtractor.toString((SSODescriptorType)sdt));
        List<IndexedEndpointType> assertionConsumerServices = sp.getAssertionConsumerService();
        if (assertionConsumerServices != null) {
            builder.append("AssertionConsumer Services are:[");
            for (IndexedEndpointType edt : assertionConsumerServices) {
                builder.append(MetaDataExtractor.toString(edt));
            }
            builder.append("]");
            builder.append(LINE_SEPARATOR);
        }
        builder.append("AuthnRequests Signed=").append(sp.isAuthnRequestsSigned());
        builder.append(LINE_SEPARATOR);
        builder.append("Requires Assertions Signed=").append(sp.isWantAssertionsSigned());
        builder.append(LINE_SEPARATOR);
        return builder.toString();
    }

    public static String toString(SSODescriptorType sso) {
        List<EndpointType> list;
        List<IndexedEndpointType> attrResServices;
        StringBuilder builder = new StringBuilder();
        List<String> nameIDs = sso.getNameIDFormat();
        if (nameIDs != null) {
            for (String string : nameIDs) {
                builder.append("NameID=").append(string);
                builder.append(LINE_SEPARATOR);
            }
        }
        if ((attrResServices = sso.getArtifactResolutionService()) != null) {
            builder.append("AttributeResolutionServices are:[");
            builder.append(LINE_SEPARATOR);
            for (IndexedEndpointType iet : attrResServices) {
                builder.append(MetaDataExtractor.toString(iet));
            }
            builder.append("]");
        }
        if ((list = sso.getSingleLogoutService()) != null) {
            builder.append("Single Logout Services are:[");
            builder.append(LINE_SEPARATOR);
            for (EndpointType edt : list) {
                builder.append(MetaDataExtractor.toString(edt));
            }
            builder.append("]");
            builder.append(LINE_SEPARATOR);
        }
        return builder.toString();
    }

    public static String toString(EndpointType ept) {
        StringBuilder builder = new StringBuilder();
        builder.append("[Location=").append(ept.getLocation());
        builder.append(",ResponseLocation=").append(ept.getResponseLocation());
        builder.append("]");
        builder.append(LINE_SEPARATOR);
        return builder.toString();
    }
}

