/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.stream.impl.termop;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.BaseStream;
import org.infinispan.stream.impl.TerminalOperation;
import org.infinispan.stream.impl.intops.IntermediateOperation;
import org.infinispan.stream.impl.termop.BaseTerminalOperation;

public class SingleRunOperation<E, R, S extends BaseStream<R, S>>
extends BaseTerminalOperation
implements TerminalOperation<E> {
    private final Function<S, ? extends E> function;
    private transient AtomicBoolean complete;

    public SingleRunOperation(Iterable<IntermediateOperation> intermediateOperations, Supplier<? extends BaseStream<?, ?>> supplier, Function<S, ? extends E> function) {
        super(intermediateOperations, supplier);
        this.function = function;
        this.complete = new AtomicBoolean();
    }

    @Override
    public boolean lostSegment(boolean stopIfLost) {
        return !this.complete.get();
    }

    @Override
    public E performOperation() {
        BaseStream stream = (BaseStream)this.supplier.get();
        for (IntermediateOperation intOp : this.intermediateOperations) {
            stream = intOp.perform(stream);
        }
        E value = this.function.apply(stream);
        this.complete.set(true);
        return value;
    }

    public Function<S, ? extends E> getFunction() {
        return this.function;
    }
}

