/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.batch.jberet;

import java.util.EnumMap;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.threads.ThreadsParser;
import org.jboss.dmr.ModelNode;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.wildfly.extension.batch.jberet.Attribute;
import org.wildfly.extension.batch.jberet.BatchSubsystemDefinition;
import org.wildfly.extension.batch.jberet.Element;
import org.wildfly.extension.batch.jberet.Namespace;
import org.wildfly.extension.batch.jberet.job.repository.JdbcJobRepositoryDefinition;

public class BatchSubsystemParser_1_0
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>> {
    public static final BatchSubsystemParser_1_0 INSTANCE = new BatchSubsystemParser_1_0();

    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> ops) throws XMLStreamException {
        ThreadsParser threadsParser = ThreadsParser.getInstance();
        PathAddress subsystemAddress = PathAddress.pathAddress((PathElement[])new PathElement[]{BatchSubsystemDefinition.SUBSYSTEM_PATH});
        ModelNode subsystemAddOp = Util.createAddOperation((PathAddress)subsystemAddress);
        ops.add(subsystemAddOp);
        EnumSet<Element> requiredElements = EnumSet.of(Element.JOB_REPOSITORY, Element.THREAD_POOL, Element.DEFAULT_JOB_REPOSITORY, Element.DEFAULT_THREAD_POOL);
        Namespace namespace = Namespace.forUri(reader.getNamespaceURI());
        while (reader.hasNext() && reader.nextTag() != 2) {
            String localName = reader.getLocalName();
            Element element = Element.forName(localName);
            if (element == Element.DEFAULT_THREAD_POOL) {
                BatchSubsystemDefinition.DEFAULT_THREAD_POOL.parseAndSetParameter(BatchSubsystemParser_1_0.readNameAttribute(reader), subsystemAddOp, (XMLStreamReader)reader);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                requiredElements.remove((Object)Element.DEFAULT_THREAD_POOL);
                continue;
            }
            if (element == Element.DEFAULT_JOB_REPOSITORY) {
                BatchSubsystemDefinition.DEFAULT_JOB_REPOSITORY.parseAndSetParameter(BatchSubsystemParser_1_0.readNameAttribute(reader), subsystemAddOp, (XMLStreamReader)reader);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                requiredElements.remove((Object)Element.DEFAULT_JOB_REPOSITORY);
                continue;
            }
            if (element == Element.JOB_REPOSITORY) {
                String name = BatchSubsystemParser_1_0.readNameAttribute(reader);
                this.parseJobRepository(reader, subsystemAddress, name, ops);
                requiredElements.remove((Object)Element.JOB_REPOSITORY);
                continue;
            }
            if (element == Element.THREAD_POOL) {
                threadsParser.parseUnboundedQueueThreadPool(reader, namespace.getUriString(), org.jboss.as.threads.Namespace.THREADS_1_1, subsystemAddress.toModelNode(), ops, "thread-pool", null);
                requiredElements.remove((Object)Element.THREAD_POOL);
                continue;
            }
            if (element == Element.THREAD_FACTORY) {
                threadsParser.parseThreadFactory(reader, namespace.getUriString(), org.jboss.as.threads.Namespace.THREADS_1_1, subsystemAddress.toModelNode(), ops, "thread-factory", null);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
        if (!requiredElements.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, requiredElements);
        }
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void parseJobRepository(XMLExtendedStreamReader reader, PathAddress subsystemAddress, String name, List<ModelNode> ops) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            String localName = reader.getLocalName();
            Element element = Element.forName(localName);
            if (element == Element.IN_MEMORY) {
                ops.add(Util.createAddOperation((PathAddress)subsystemAddress.append("in-memory-job-repository", name)));
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                continue;
            }
            if (element == Element.JDBC) {
                Map<Attribute, String> attributes = BatchSubsystemParser_1_0.readRequiredAttributes(reader, EnumSet.of(Attribute.DATA_SOURCE));
                ModelNode op = Util.createAddOperation((PathAddress)subsystemAddress.append("jdbc-job-repository", name));
                JdbcJobRepositoryDefinition.DATA_SOURCE.parseAndSetParameter(attributes.get((Object)Attribute.DATA_SOURCE), op, (XMLStreamReader)reader);
                ops.add(op);
                ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
                continue;
            }
            throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
        }
    }

    static String readNameAttribute(XMLExtendedStreamReader reader) throws XMLStreamException {
        return BatchSubsystemParser_1_0.readRequiredAttributes(reader, EnumSet.of(Attribute.NAME)).get((Object)Attribute.NAME);
    }

    static Map<Attribute, String> readRequiredAttributes(XMLExtendedStreamReader reader, Set<Attribute> attributes) throws XMLStreamException {
        int attributeCount = reader.getAttributeCount();
        EnumMap<Attribute, String> result = new EnumMap<Attribute, String>(Attribute.class);
        for (int i = 0; i < attributeCount; ++i) {
            Attribute current = Attribute.forName(reader.getAttributeLocalName(i));
            if (attributes.contains((Object)current)) {
                if (result.put(current, reader.getAttributeValue(i)) == null) continue;
                throw ParseUtils.duplicateAttribute((XMLExtendedStreamReader)reader, (String)current.getLocalName());
            }
            throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i, attributes.stream().map(Attribute::getLocalName).collect(Collectors.toSet()));
        }
        if (result.isEmpty()) {
            throw ParseUtils.missingRequired((XMLExtendedStreamReader)reader, attributes.stream().map(Attribute::getLocalName).collect(Collectors.toSet()));
        }
        return result;
    }
}

