/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.cache.infinispan.access;

import javax.transaction.SystemException;
import javax.transaction.TransactionManager;
import org.hibernate.cache.CacheException;
import org.hibernate.cache.infinispan.access.InvalidationCacheAccessDelegate;
import org.hibernate.cache.infinispan.access.PutFromLoadValidator;
import org.hibernate.cache.infinispan.impl.BaseRegion;
import org.hibernate.cache.spi.access.SoftLock;
import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.resource.transaction.TransactionCoordinator;
import org.hibernate.resource.transaction.spi.TransactionStatus;

public class NonTxInvalidationCacheAccessDelegate
extends InvalidationCacheAccessDelegate {
    public NonTxInvalidationCacheAccessDelegate(BaseRegion region, PutFromLoadValidator validator) {
        super(region, validator);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean insert(SessionImplementor session, Object key, Object value, Object version) throws CacheException {
        if (!this.region.checkValid()) {
            return false;
        }
        if (!this.putValidator.beginInvalidatingWithPFER(session, key, value)) {
            throw new CacheException("Failed to invalidate pending putFromLoad calls for key " + key + " from region " + this.region.getName());
        }
        this.putValidator.setCurrentSession(session);
        try {
            this.writeCache.remove(key);
        }
        finally {
            this.putValidator.resetCurrentSession();
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean update(SessionImplementor session, Object key, Object value, Object currentVersion, Object previousVersion) throws CacheException {
        if (!this.putValidator.beginInvalidatingWithPFER(session, key, value)) {
            throw new CacheException("Failed to invalidate pending putFromLoad calls for key " + key + " from region " + this.region.getName());
        }
        this.putValidator.setCurrentSession(session);
        try {
            this.writeCache.remove(key);
        }
        finally {
            this.putValidator.resetCurrentSession();
        }
        return true;
    }

    protected boolean isCommitted(SessionImplementor session) {
        TransactionManager tm;
        if (session.isClosed() && (tm = this.region.getTransactionManager()) != null) {
            try {
                switch (tm.getStatus()) {
                    case 3: 
                    case 8: {
                        return true;
                    }
                }
                return false;
            }
            catch (SystemException e) {
                log.debug((Object)"Failed to retrieve transaction status", (Throwable)e);
                return false;
            }
        }
        TransactionCoordinator tc = session.getTransactionCoordinator();
        return tc != null && tc.getTransactionDriverControl().getStatus() == TransactionStatus.COMMITTED;
    }

    @Override
    public void unlockItem(SessionImplementor session, Object key) throws CacheException {
        if (!this.putValidator.endInvalidatingKey(session, key, this.isCommitted(session))) {
            log.warn((Object)("Failed to end invalidating pending putFromLoad calls for key " + key + " from region " + this.region.getName() + "; the key won't be cached until invalidation expires."));
        }
    }

    @Override
    public boolean afterInsert(SessionImplementor session, Object key, Object value, Object version) {
        if (!this.putValidator.endInvalidatingKey(session, key, this.isCommitted(session))) {
            log.warn((Object)("Failed to end invalidating pending putFromLoad calls for key " + key + " from region " + this.region.getName() + "; the key won't be cached until invalidation expires."));
        }
        return false;
    }

    @Override
    public boolean afterUpdate(SessionImplementor session, Object key, Object value, Object currentVersion, Object previousVersion, SoftLock lock) {
        if (!this.putValidator.endInvalidatingKey(session, key, this.isCommitted(session))) {
            log.warn((Object)("Failed to end invalidating pending putFromLoad calls for key " + key + " from region " + this.region.getName() + "; the key won't be cached until invalidation expires."));
        }
        return false;
    }
}

