/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.service.concurrent;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.threads.JBossExecutors;
import org.wildfly.clustering.service.AsynchronousServiceBuilder;
import org.wildfly.clustering.service.Builder;

public class CachedThreadPoolExecutorServiceBuilder
implements Builder<ExecutorService>,
Service<ExecutorService> {
    private final ServiceName name;
    private final ThreadFactory factory;
    private volatile ExecutorService executor;

    public CachedThreadPoolExecutorServiceBuilder(ServiceName name, ThreadFactory factory) {
        this.name = name;
        this.factory = factory;
    }

    @Override
    public ServiceName getServiceName() {
        return this.name;
    }

    @Override
    public ServiceBuilder<ExecutorService> build(ServiceTarget target) {
        return new AsynchronousServiceBuilder<ExecutorService>(this.name, this).startSynchronously().build(target).setInitialMode(ServiceController.Mode.ON_DEMAND);
    }

    public ExecutorService getValue() {
        return JBossExecutors.protectedExecutorService((Executor)this.executor);
    }

    public void start(StartContext context) {
        this.executor = Executors.newCachedThreadPool(this.factory);
    }

    public void stop(StopContext context) {
        this.executor.shutdown();
        this.executor = null;
    }
}

