/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.controller.operations.common;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationDefinition;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.SimpleOperationDefinitionBuilder;
import org.jboss.as.controller.access.AuthorizationResult;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.descriptions.common.ControllerResolver;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.as.controller.persistence.ConfigurationPersistenceException;
import org.jboss.as.controller.persistence.ConfigurationPersister;
import org.jboss.as.controller.registry.OperationEntry;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class SnapshotTakeHandler
implements OperationStepHandler {
    private static final String OPERATION_NAME = "take-snapshot";
    public static final OperationDefinition DEFINITION = new SimpleOperationDefinitionBuilder("take-snapshot", ControllerResolver.getResolver("snapshot")).setReplyType(ModelType.STRING).setRuntimeOnly().withFlag(OperationEntry.Flag.MASTER_HOST_CONTROLLER_ONLY).addAccessConstraint(SensitiveTargetAccessConstraintDefinition.SNAPSHOTS).build();
    private final ConfigurationPersister persister;

    public SnapshotTakeHandler(ConfigurationPersister persister) {
        this.persister = persister;
    }

    @Override
    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        AuthorizationResult authorizationResult = context.authorize(operation);
        if (authorizationResult.getDecision() == AuthorizationResult.Decision.DENY) {
            throw ControllerLogger.ROOT_LOGGER.unauthorized(operation.get("operation").asString(), context.getCurrentAddress(), authorizationResult.getExplanation());
        }
        try {
            String name = this.persister.snapshot();
            context.getResult().set(name);
        }
        catch (ConfigurationPersistenceException e) {
            throw new OperationFailedException(e);
        }
        context.completeStep(OperationContext.RollbackHandler.NOOP_ROLLBACK_HANDLER);
    }
}

