/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.engine.metadata.impl;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.hibernate.annotations.common.reflection.XProperty;
import org.hibernate.search.annotations.NumericField;
import org.hibernate.search.annotations.NumericFields;
import org.hibernate.search.util.logging.impl.Log;
import org.hibernate.search.util.logging.impl.LoggerFactory;

class NumericFieldsConfiguration {
    private static final Log LOG = LoggerFactory.make();
    private final Class<?> indexedType;
    private final XProperty member;
    private final Map<String, NumericField> fieldsMarkedAsNumeric;
    private final Set<String> fieldsOfProperty = new HashSet<String>();

    NumericFieldsConfiguration(Class<?> indexedType, XProperty member) {
        NumericFields numericFieldsAnnotation;
        this.indexedType = indexedType;
        this.member = member;
        this.fieldsMarkedAsNumeric = new HashMap<String, NumericField>();
        NumericField numericFieldAnnotation = (NumericField)member.getAnnotation(NumericField.class);
        if (numericFieldAnnotation != null) {
            this.fieldsMarkedAsNumeric.put(numericFieldAnnotation.forField(), numericFieldAnnotation);
        }
        if ((numericFieldsAnnotation = (NumericFields)member.getAnnotation(NumericFields.class)) != null) {
            for (NumericField numericField : numericFieldsAnnotation.value()) {
                NumericField existing = this.fieldsMarkedAsNumeric.put(numericField.forField(), numericField);
                if (existing == null) continue;
                throw LOG.severalNumericFieldAnnotationsForSameField(indexedType, member.getName());
            }
        }
    }

    NumericField getNumericFieldAnnotation(String unprefixedFieldName) {
        this.fieldsOfProperty.add(unprefixedFieldName);
        NumericField numericFieldAnnotation = this.fieldsMarkedAsNumeric.get(unprefixedFieldName);
        if (numericFieldAnnotation == null) {
            numericFieldAnnotation = this.fieldsMarkedAsNumeric.get("");
        }
        return numericFieldAnnotation;
    }

    boolean isNumericField(String unprefixedFieldName) {
        return this.getNumericFieldAnnotation(unprefixedFieldName) != null;
    }

    void validate() {
        for (String fieldMarkedAsNumeric : this.fieldsMarkedAsNumeric.keySet()) {
            if (this.fieldsOfProperty.contains(fieldMarkedAsNumeric) || fieldMarkedAsNumeric.isEmpty() && !this.fieldsOfProperty.isEmpty()) continue;
            throw LOG.numericFieldAnnotationWithoutMatchingField(this.indexedType, this.member.getName());
        }
    }
}

