/*
 * Decompiled with CFR 0.152.
 */
package javax.el;

import java.beans.BeanInfo;
import java.beans.FeatureDescriptor;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import javax.el.ELContext;
import javax.el.ELException;
import javax.el.ELResolver;
import javax.el.ELUtil;
import javax.el.LambdaExpression;
import javax.el.PropertyNotFoundException;
import javax.el.PropertyNotWritableException;
import org.jboss.el.cache.BeanPropertiesCache;

public class BeanELResolver
extends ELResolver {
    private boolean isReadOnly;

    public BeanELResolver() {
        this.isReadOnly = false;
    }

    public BeanELResolver(boolean isReadOnly) {
        this.isReadOnly = isReadOnly;
    }

    @Override
    public Class<?> getType(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return null;
        }
        BeanPropertiesCache.BeanProperty bp = this.getBeanProperty(context, base, property);
        context.setPropertyResolved(true);
        return bp.getPropertyType();
    }

    @Override
    public Object getValue(ELContext context, Object base, Object property) {
        Object value;
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return null;
        }
        BeanPropertiesCache.BeanProperty bp = this.getBeanProperty(context, base, property);
        Method method = bp.getReadMethod();
        if (method == null) {
            throw new PropertyNotFoundException(ELUtil.getExceptionMessageString(context, "propertyNotReadable", new Object[]{base.getClass().getName(), property.toString()}));
        }
        try {
            value = method.invoke(base, new Object[0]);
            context.setPropertyResolved(base, property);
        }
        catch (ELException ex) {
            throw ex;
        }
        catch (InvocationTargetException ite) {
            throw new ELException(ite.getCause());
        }
        catch (Exception ex) {
            throw new ELException(ex);
        }
        return value;
    }

    @Override
    public void setValue(ELContext context, Object base, Object property, Object val) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return;
        }
        if (this.isReadOnly) {
            throw new PropertyNotWritableException(ELUtil.getExceptionMessageString(context, "resolverNotwritable", new Object[]{base.getClass().getName()}));
        }
        BeanPropertiesCache.BeanProperty bp = this.getBeanProperty(context, base, property);
        Method method = bp.getWriteMethod();
        if (method == null) {
            throw new PropertyNotWritableException(ELUtil.getExceptionMessageString(context, "propertyNotWritable", new Object[]{base.getClass().getName(), property.toString()}));
        }
        try {
            method.invoke(base, val);
            context.setPropertyResolved(base, property);
        }
        catch (ELException ex) {
            throw ex;
        }
        catch (InvocationTargetException ite) {
            throw new ELException(ite.getCause());
        }
        catch (Exception ex) {
            if (null == val) {
                val = "null";
            }
            String message = ELUtil.getExceptionMessageString(context, "setPropertyFailed", new Object[]{property.toString(), base.getClass().getName(), val});
            throw new ELException(message, ex);
        }
    }

    @Override
    public Object invoke(ELContext context, Object base, Object method, Class<?>[] paramTypes, Object[] params) {
        if (base == null || method == null) {
            return null;
        }
        Method m = ELUtil.findMethod(base.getClass(), method.toString(), paramTypes, params, false);
        m = BeanPropertiesCache.getMethod(base.getClass(), m);
        for (Object p : params) {
            if (!(p instanceof LambdaExpression)) continue;
            ((LambdaExpression)p).setELContext(context);
        }
        Object ret = ELUtil.invokeMethod(context, m, base, params);
        context.setPropertyResolved(base, method);
        return ret;
    }

    @Override
    public boolean isReadOnly(ELContext context, Object base, Object property) {
        if (context == null) {
            throw new NullPointerException();
        }
        if (base == null || property == null) {
            return false;
        }
        context.setPropertyResolved(true);
        if (this.isReadOnly) {
            return true;
        }
        BeanPropertiesCache.BeanProperty bp = this.getBeanProperty(context, base, property);
        return bp.isReadOnly();
    }

    @Override
    public Iterator<FeatureDescriptor> getFeatureDescriptors(ELContext context, Object base) {
        if (base == null) {
            return null;
        }
        BeanInfo info = null;
        try {
            info = Introspector.getBeanInfo(base.getClass());
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (info == null) {
            return null;
        }
        ArrayList<PropertyDescriptor> list = new ArrayList<PropertyDescriptor>(info.getPropertyDescriptors().length);
        for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
            pd.setValue("type", pd.getPropertyType());
            pd.setValue("resolvableAtDesignTime", Boolean.TRUE);
            list.add(pd);
        }
        return list.iterator();
    }

    @Override
    public Class<?> getCommonPropertyType(ELContext context, Object base) {
        if (base == null) {
            return null;
        }
        return Object.class;
    }

    private BeanPropertiesCache.BeanProperty getBeanProperty(ELContext context, Object base, Object prop) {
        BeanPropertiesCache.BeanProperty bp;
        String property = prop.toString();
        Class<?> baseClass = base.getClass();
        BeanPropertiesCache.BeanProperties bps = BeanPropertiesCache.getProperties().get(baseClass);
        if (bps == null) {
            bps = new BeanPropertiesCache.BeanProperties(baseClass);
            BeanPropertiesCache.getProperties().put(baseClass, bps);
        }
        if ((bp = bps.getBeanProperty(property)) == null) {
            throw new PropertyNotFoundException(ELUtil.getExceptionMessageString(context, "propertyNotFound", new Object[]{baseClass.getName(), property}));
        }
        return bp;
    }
}

