/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.iiop.openjdk.csiv2;

import org.jboss.metadata.ejb.jboss.IORSecurityConfigMetaData;
import org.omg.CORBA.LocalObject;
import org.omg.CORBA.ORB;
import org.omg.CORBA.Policy;
import org.omg.IOP.Codec;
import org.omg.IOP.TaggedComponent;
import org.wildfly.iiop.openjdk.csiv2.CSIv2Util;
import org.wildfly.iiop.openjdk.logging.IIOPLogger;
import org.wildfly.iiop.openjdk.service.CorbaORBService;

public class CSIv2Policy
extends LocalObject
implements Policy {
    public static final int TYPE = -2023406815;
    private TaggedComponent sslTaggedComponent;
    private TaggedComponent secTaggedComponent;

    public CSIv2Policy(TaggedComponent sslTaggedComponent, TaggedComponent secTaggedComponent) {
        this.sslTaggedComponent = sslTaggedComponent;
        this.secTaggedComponent = secTaggedComponent;
    }

    public CSIv2Policy(IORSecurityConfigMetaData metadata, Codec codec) {
        IIOPLogger.ROOT_LOGGER.debugf("IOR security config metadata: %s", metadata);
        try {
            ORB orb = ORB.init();
            String sslPortString = CorbaORBService.getORBProperty("OASSLPort");
            int sslPort = sslPortString == null ? 0 : Integer.parseInt(sslPortString);
            this.sslTaggedComponent = CSIv2Util.createSSLTaggedComponent(metadata, codec, sslPort, orb);
            this.secTaggedComponent = CSIv2Util.createSecurityTaggedComponent(metadata, codec, sslPort, orb);
        }
        catch (Exception e) {
            throw IIOPLogger.ROOT_LOGGER.unexpectedException(e);
        }
    }

    public TaggedComponent getSSLTaggedComponent() {
        return CSIv2Util.createCopy(this.sslTaggedComponent);
    }

    public TaggedComponent getSecurityTaggedComponent() {
        return CSIv2Util.createCopy(this.secTaggedComponent);
    }

    public Policy copy() {
        return new CSIv2Policy(this.getSSLTaggedComponent(), this.getSecurityTaggedComponent());
    }

    public void destroy() {
        this.sslTaggedComponent = null;
        this.secTaggedComponent = null;
    }

    public int policy_type() {
        return -2023406815;
    }

    public String toString() {
        return "CSIv2Policy[" + this.sslTaggedComponent + ", " + this.secTaggedComponent + "]";
    }
}

