/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.patching.installation;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jboss.as.patching.IoUtils;
import org.jboss.as.patching.PatchingException;
import org.jboss.as.patching.installation.InstallationManager;
import org.jboss.as.patching.installation.InstalledIdentity;
import org.jboss.as.patching.installation.InstalledImage;
import org.jboss.as.patching.installation.LayersFactory;
import org.jboss.as.patching.logging.PatchLogger;
import org.jboss.as.version.ProductConfig;

public class InstallationManagerImpl
extends InstallationManager {
    private final InstalledImage installedImage;
    private InstalledIdentity defaultIdentity;
    private List<File> moduleRoots;
    private List<File> bundleRoots;
    private static final AtomicBoolean restartRequired = new AtomicBoolean(false);

    public InstallationManagerImpl(InstalledImage installedImage, List<File> moduleRoots, List<File> bundlesRoots, ProductConfig productConfig) throws IOException {
        this.installedImage = installedImage;
        this.moduleRoots = moduleRoots;
        this.bundleRoots = bundlesRoots;
        this.defaultIdentity = LayersFactory.load(installedImage, productConfig, moduleRoots, this.bundleRoots);
    }

    @Override
    public InstalledIdentity getInstalledIdentity(String productName, String productVersion) throws PatchingException {
        String recordedProductVersion;
        File productConf;
        String defaultIdentityName = this.defaultIdentity.getIdentity().getName();
        if (productName == null) {
            productName = defaultIdentityName;
        }
        if (!(productConf = new File(this.installedImage.getInstallationMetadata(), productName + ".conf")).exists()) {
            recordedProductVersion = null;
        } else {
            Properties props = this.loadProductConf(productConf);
            recordedProductVersion = props.getProperty("current-version");
        }
        if (defaultIdentityName.equals(productName)) {
            if (recordedProductVersion != null && !recordedProductVersion.equals(this.defaultIdentity.getIdentity().getVersion())) {
                this.defaultIdentity = this.loadIdentity(productName, recordedProductVersion);
            }
            if (productVersion != null && !this.defaultIdentity.getIdentity().getVersion().equals(productVersion)) {
                throw new PatchingException(PatchLogger.ROOT_LOGGER.productVersionDidNotMatchInstalled(productName, productVersion, this.defaultIdentity.getIdentity().getVersion()));
            }
            return this.defaultIdentity;
        }
        if (recordedProductVersion != null && !"Unknown".equals(recordedProductVersion)) {
            if (productVersion != null) {
                if (!productVersion.equals(recordedProductVersion)) {
                    throw new PatchingException(PatchLogger.ROOT_LOGGER.productVersionDidNotMatchInstalled(productName, productVersion, recordedProductVersion));
                }
            } else {
                productVersion = recordedProductVersion;
            }
        }
        return this.loadIdentity(productName, productVersion);
    }

    private InstalledIdentity loadIdentity(String productName, String productVersion) throws PatchingException {
        try {
            return LayersFactory.load(this.installedImage, new ProductConfig(productName, productVersion == null ? "Unknown" : productVersion, null), this.moduleRoots, this.bundleRoots);
        }
        catch (IOException e) {
            throw new PatchingException(PatchLogger.ROOT_LOGGER.failedToLoadInfo(productName), e);
        }
    }

    private Properties loadProductConf(File productConf) throws PatchingException {
        Properties props = new Properties();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(productConf);
            props.load(fis);
        }
        catch (IOException e) {
            throw new PatchingException(PatchLogger.ROOT_LOGGER.failedToLoadInfo(productConf.getAbsolutePath()), e);
        }
        finally {
            if (fis != null) {
                IoUtils.safeClose(fis);
            }
        }
        return props;
    }

    @Override
    public InstalledIdentity getDefaultIdentity() {
        return this.defaultIdentity;
    }

    @Override
    public List<InstalledIdentity> getInstalledIdentities() throws PatchingException {
        List<InstalledIdentity> installedIdentities;
        File metadataDir = this.installedImage.getInstallationMetadata();
        if (!metadataDir.exists()) {
            installedIdentities = Collections.singletonList(this.defaultIdentity);
        } else {
            final String defaultConf = this.defaultIdentity.getIdentity().getName() + ".conf";
            File[] identityConfs = metadataDir.listFiles(new FileFilter(){

                @Override
                public boolean accept(File pathname) {
                    return pathname.isFile() && pathname.getName().endsWith(".conf") && !pathname.getName().equals(defaultConf);
                }
            });
            if (identityConfs == null || identityConfs.length == 0) {
                installedIdentities = Collections.singletonList(this.defaultIdentity);
            } else {
                installedIdentities = new ArrayList<InstalledIdentity>(identityConfs.length + 1);
                installedIdentities.add(this.defaultIdentity);
                for (File conf : identityConfs) {
                    InstalledIdentity identity;
                    Properties props = this.loadProductConf(conf);
                    String productName = conf.getName();
                    productName = productName.substring(0, productName.length() - ".conf".length());
                    String productVersion = props.getProperty("current-version");
                    try {
                        identity = LayersFactory.load(this.installedImage, new ProductConfig(productName, productVersion, null), this.moduleRoots, this.bundleRoots);
                    }
                    catch (IOException e) {
                        throw new PatchingException(PatchLogger.ROOT_LOGGER.failedToLoadInfo(productName), e);
                    }
                    installedIdentities.add(identity);
                }
            }
        }
        return installedIdentities;
    }

    @Override
    public InstalledImage getInstalledImage() {
        return this.installedImage;
    }

    @Override
    public boolean requiresRestart() {
        return restartRequired.get();
    }

    @Override
    public boolean restartRequired() {
        return restartRequired.compareAndSet(false, true);
    }

    @Override
    public void clearRestartRequired() {
        restartRequired.set(false);
    }
}

