/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.io;

import java.util.HashMap;
import java.util.Map;

enum Namespace {
    UNKNOWN(null),
    IO_1_0("urn:jboss:domain:io:1.0"),
    IO_1_1("urn:jboss:domain:io:1.1");

    public static final Namespace CURRENT;
    private final String name;
    private static final Map<String, Namespace> MAP;

    private Namespace(String name) {
        this.name = name;
    }

    public String getUriString() {
        return this.name;
    }

    public static Namespace forUri(String uri) {
        Namespace element = MAP.get(uri);
        return element == null ? UNKNOWN : element;
    }

    static {
        CURRENT = IO_1_1;
        HashMap<String, Namespace> map = new HashMap<String, Namespace>();
        for (Namespace namespace : Namespace.values()) {
            String name = namespace.getUriString();
            if (name == null) continue;
            map.put(name, namespace);
        }
        MAP = map;
    }
}

