/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.discovery;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicInteger;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.namespace.QName;
import javax.xml.ws.AsyncHandler;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Dispatch;
import javax.xml.ws.EndpointReference;
import javax.xml.ws.Holder;
import javax.xml.ws.Response;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceFeature;
import javax.xml.ws.soap.AddressingFeature;
import javax.xml.ws.wsaddressing.W3CEndpointReference;
import javax.xml.ws.wsaddressing.W3CEndpointReferenceBuilder;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.apache.cxf.common.jaxb.JAXBContextCache;
import org.apache.cxf.common.util.StringUtils;
import org.apache.cxf.databinding.DataBinding;
import org.apache.cxf.headers.Header;
import org.apache.cxf.jaxb.JAXBDataBinding;
import org.apache.cxf.jaxws.ServiceImpl;
import org.apache.cxf.jaxws.spi.ProviderImpl;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.ContextUtils;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.apache.cxf.ws.addressing.EndpointReferenceUtils;
import org.apache.cxf.ws.discovery.WSDVersion;
import org.apache.cxf.ws.discovery.wsdl.AppSequenceType;
import org.apache.cxf.ws.discovery.wsdl.ByeType;
import org.apache.cxf.ws.discovery.wsdl.HelloType;
import org.apache.cxf.ws.discovery.wsdl.ObjectFactory;
import org.apache.cxf.ws.discovery.wsdl.ProbeMatchType;
import org.apache.cxf.ws.discovery.wsdl.ProbeMatchesType;
import org.apache.cxf.ws.discovery.wsdl.ProbeType;
import org.apache.cxf.ws.discovery.wsdl.ResolveMatchType;
import org.apache.cxf.ws.discovery.wsdl.ResolveMatchesType;
import org.apache.cxf.ws.discovery.wsdl.ResolveType;
import org.apache.cxf.ws.discovery.wsdl.ScopesType;

public class WSDiscoveryClient
implements Closeable {
    public static final QName SERVICE_QNAME = new QName("http://docs.oasis-open.org/ws-dd/ns/discovery/2009/01", "DiscoveryProxy");
    String address = "soap.udp://239.255.255.250:3702";
    boolean adHoc = true;
    AtomicInteger msgId = new AtomicInteger(1);
    long instanceId = System.currentTimeMillis();
    JAXBContext jaxbContext;
    ServiceImpl service;
    Dispatch<Object> dispatch;
    ObjectFactory factory = new ObjectFactory();
    final Bus bus;
    int defaultProbeTimeout = 1000;
    WSDVersion version = WSDVersion.INSTANCE_1_1;
    String soapVersion = "http://www.w3.org/2003/05/soap/bindings/HTTP/";

    public WSDiscoveryClient() {
        this((Bus)null);
    }

    public WSDiscoveryClient(Bus b) {
        this.bus = b == null ? BusFactory.getThreadDefaultBus() : b;
    }

    public WSDiscoveryClient(String address) {
        this((Bus)null);
        this.resetDispatch(address);
    }

    public WSDiscoveryClient(Bus b, String address) {
        this(b);
        this.resetDispatch(address);
    }

    public void setDefaultProbeTimeout(int i) {
        this.defaultProbeTimeout = i;
    }

    public int getDefaultProbeTimeout() {
        return this.defaultProbeTimeout;
    }

    public String getAddress() {
        return this.address;
    }

    public void setAddress(String a) {
        if (!this.address.equals(a)) {
            this.uncache();
            this.resetDispatch(a);
        }
    }

    public void setVersion10() {
        this.setVersion(true);
    }

    public void setVersion(boolean version10) {
        WSDVersion newv;
        WSDVersion wSDVersion = newv = version10 ? WSDVersion.INSTANCE_1_0 : WSDVersion.INSTANCE_1_1;
        if (newv != this.version) {
            this.version = newv;
            this.uncache();
        }
    }

    public void setSoapVersion11() {
        this.setSoapVersion(true);
    }

    public void setSoapVersion(boolean do11) {
        String newVer;
        String string = newVer = do11 ? "http://schemas.xmlsoap.org/wsdl/soap/http" : "http://www.w3.org/2003/05/soap/bindings/HTTP/";
        if (!this.soapVersion.equals(newVer)) {
            this.soapVersion = newVer;
            this.uncache();
        }
    }

    private void uncache() {
        if (this.dispatch instanceof Closeable) {
            try {
                ((Closeable)this.dispatch).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        this.dispatch = null;
        this.service = null;
    }

    private synchronized JAXBContext getJAXBContext() {
        if (this.jaxbContext == null) {
            try {
                this.jaxbContext = JAXBContextCache.getCachedContextAndSchemas((Class[])new Class[]{ObjectFactory.class}).getContext();
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }
        return this.jaxbContext;
    }

    private synchronized ServiceImpl getService() {
        if (this.service == null) {
            Bus b = BusFactory.getAndSetThreadDefaultBus((Bus)this.bus);
            try {
                this.service = new ServiceImpl(this.bus, null, this.version.getServiceName(), Service.class, new WebServiceFeature[0]);
                this.service.addPort(this.version.getServiceName(), this.soapVersion, this.address);
            }
            finally {
                BusFactory.setThreadDefaultBus((Bus)b);
            }
        }
        return this.service;
    }

    private synchronized void resetDispatch(String newad) {
        this.address = newad;
        this.dispatch = null;
        this.service = null;
        this.adHoc = false;
        try {
            URI uri = new URI(this.address);
            if (StringUtils.isEmpty((String)uri.getHost())) {
                this.adHoc = true;
            } else {
                InetSocketAddress isa = null;
                isa = new InetSocketAddress(uri.getHost(), uri.getPort());
                if (isa.getAddress().isMulticastAddress()) {
                    this.adHoc = true;
                }
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
    }

    private synchronized Dispatch<Object> getDispatchInternal(boolean addSeq, String action) {
        if (this.dispatch == null) {
            AddressingFeature f = new AddressingFeature(true, true);
            this.dispatch = this.getService().createDispatch(this.version.getServiceName(), this.getJAXBContext(), Service.Mode.PAYLOAD, new WebServiceFeature[]{f});
            this.dispatch.getRequestContext().put("thread.local.request.context", Boolean.TRUE);
            this.version.addVersionTransformer(this.dispatch);
        }
        this.addAddressing((BindingProvider)this.dispatch, false, action);
        return this.dispatch;
    }

    private void addAddressing(BindingProvider p, boolean addSeq, String action) {
        AddressingProperties addrProperties = new AddressingProperties();
        if (action != null) {
            AttributedURIType act = new AttributedURIType();
            act.setValue(action);
            addrProperties.setAction(act);
        }
        if (this.adHoc) {
            EndpointReferenceType to = new EndpointReferenceType();
            addrProperties.exposeAs(this.version.getAddressingNamespace());
            AttributedURIType epr = new AttributedURIType();
            epr.setValue(this.version.getToAddress());
            to.setAddress(epr);
            addrProperties.setTo(to);
            if (addSeq) {
                AppSequenceType s = new AppSequenceType();
                s.setInstanceId(this.instanceId);
                s.setMessageNumber(this.msgId.getAndIncrement());
                JAXBElement<AppSequenceType> seq = new ObjectFactory().createAppSequence(s);
                Header h = new Header(seq.getName(), seq, (DataBinding)new JAXBDataBinding(this.getJAXBContext()));
                ArrayList<Header> headers = new ArrayList<Header>();
                headers.add(h);
                p.getRequestContext().put(Header.HEADER_LIST, headers);
            }
        } else {
            addrProperties.exposeAs(this.version.getAddressingNamespace());
        }
        p.getRequestContext().put("javax.xml.ws.addressing.context", addrProperties);
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.dispatch != null) {
            ((Closeable)this.dispatch).close();
            this.dispatch = null;
        }
        this.service = null;
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.close();
    }

    public HelloType register(HelloType hello) {
        if (hello.getEndpointReference() == null) {
            hello.setEndpointReference(this.generateW3CEndpointReference());
        }
        this.getDispatchInternal(true, this.version.getHelloAction()).invokeOneWay(this.factory.createHello(hello));
        return hello;
    }

    public HelloType register(EndpointReference ert) {
        HelloType hello = new HelloType();
        hello.setScopes(new ScopesType());
        hello.setMetadataVersion(1L);
        EndpointReferenceType ref = ProviderImpl.convertToInternal((EndpointReference)ert);
        this.proccessEndpointReference(ref, hello.getScopes(), hello.getTypes(), hello.getXAddrs());
        hello.setEndpointReference(this.generateW3CEndpointReference());
        return this.register(hello);
    }

    public void unregister(ByeType bye) {
        this.getDispatchInternal(true, this.version.getByeAction()).invokeOneWay(this.factory.createBye(bye));
    }

    public void unregister(HelloType hello) {
        ByeType bt = new ByeType();
        bt.setScopes(hello.getScopes());
        bt.setEndpointReference(hello.getEndpointReference());
        this.unregister(bt);
    }

    public List<EndpointReference> probe() {
        return this.probe((QName)null);
    }

    public List<EndpointReference> probe(QName type) {
        ProbeType p = new ProbeType();
        if (type != null) {
            p.getTypes().add(type);
        }
        ProbeMatchesType pmt = this.probe(p, this.defaultProbeTimeout);
        ArrayList<EndpointReference> er = new ArrayList<EndpointReference>();
        for (ProbeMatchType pm : pmt.getProbeMatch()) {
            for (String add : pm.getXAddrs()) {
                W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder();
                builder.address(add);
                er.add((EndpointReference)builder.build());
            }
        }
        return er;
    }

    public ProbeMatchesType probe(ProbeType params) {
        return this.probe(params, this.defaultProbeTimeout);
    }

    public ProbeMatchesType probe(ProbeType params, int timeout) {
        Dispatch<Object> disp = this.getDispatchInternal(false, this.version.getProbeAction());
        if (this.adHoc) {
            disp.getRequestContext().put("udp.multi.response.timeout", timeout);
            final ProbeMatchesType response = new ProbeMatchesType();
            AsyncHandler<Object> handler = new AsyncHandler<Object>(){

                public void handleResponse(Response<Object> res) {
                    try {
                        Object o = res.get();
                        while (o instanceof JAXBElement) {
                            o = ((JAXBElement)o).getValue();
                        }
                        if (o instanceof ProbeMatchesType) {
                            response.getProbeMatch().addAll(((ProbeMatchesType)o).getProbeMatch());
                        } else if (o instanceof HelloType) {
                            HelloType h = (HelloType)o;
                            QName sn = WSDiscoveryClient.this.version.getServiceName();
                            if (h.getTypes().contains(sn) || h.getTypes().contains(new QName("", sn.getLocalPart()))) {
                                WSDiscoveryClient.this.uncache();
                                WSDiscoveryClient.this.resetDispatch(h.getXAddrs().get(0));
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                }
            };
            disp.invokeAsync(new ObjectFactory().createProbe(params), (AsyncHandler)handler);
            return response;
        }
        Object o = disp.invoke(new ObjectFactory().createProbe(params));
        while (o instanceof JAXBElement) {
            o = ((JAXBElement)o).getValue();
        }
        return (ProbeMatchesType)o;
    }

    public ResolveMatchType resolve(W3CEndpointReference ref) {
        return this.resolve(ref, this.defaultProbeTimeout);
    }

    public ResolveMatchType resolve(W3CEndpointReference ref, int timeout) {
        Dispatch<Object> disp = this.getDispatchInternal(false, this.version.getResolveAction());
        ResolveType rt = new ResolveType();
        rt.setEndpointReference(ref);
        if (this.adHoc) {
            disp.getRequestContext().put("udp.multi.response.timeout", timeout);
            final Holder response = new Holder();
            AsyncHandler<Object> handler = new AsyncHandler<Object>(){

                public void handleResponse(Response<Object> res) {
                    try {
                        Object o = res.get();
                        while (o instanceof JAXBElement) {
                            o = ((JAXBElement)o).getValue();
                        }
                        if (o instanceof ResolveMatchesType) {
                            response.value = (ResolveMatchesType)o;
                        } else if (o instanceof HelloType) {
                            HelloType h = (HelloType)o;
                            QName sn = WSDiscoveryClient.this.version.getServiceName();
                            if (h.getTypes().contains(sn) || h.getTypes().contains(new QName("", sn.getLocalPart()))) {
                                WSDiscoveryClient.this.uncache();
                                WSDiscoveryClient.this.resetDispatch(h.getXAddrs().get(0));
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {
                    }
                    catch (ExecutionException executionException) {
                        // empty catch block
                    }
                }
            };
            disp.invokeAsync(new ObjectFactory().createResolve(rt), (AsyncHandler)handler);
            return response.value == null ? null : ((ResolveMatchesType)response.value).getResolveMatch();
        }
        Object o = disp.invoke(new ObjectFactory().createResolve(rt));
        while (o instanceof JAXBElement) {
            o = ((JAXBElement)o).getValue();
        }
        return o == null ? null : ((ResolveMatchesType)o).getResolveMatch();
    }

    private W3CEndpointReference generateW3CEndpointReference() {
        W3CEndpointReferenceBuilder builder = new W3CEndpointReferenceBuilder();
        builder.address(ContextUtils.generateUUID());
        return builder.build();
    }

    private void proccessEndpointReference(EndpointReferenceType ref, ScopesType scopes, List<QName> types, List<String> xAddrs) {
        String add;
        QName nm = EndpointReferenceUtils.getPortQName((EndpointReferenceType)ref, (Bus)this.bus);
        scopes.getValue().add(nm.getNamespaceURI());
        types.add(nm);
        String wsdlLocation = EndpointReferenceUtils.getWSDLLocation((EndpointReferenceType)ref);
        if (!StringUtils.isEmpty((String)wsdlLocation)) {
            xAddrs.add(wsdlLocation);
        }
        if (!StringUtils.isEmpty((String)(add = EndpointReferenceUtils.getAddress((EndpointReferenceType)ref))) && !xAddrs.contains(add)) {
            xAddrs.add(add);
        }
    }

    public boolean isAdHoc() {
        return this.adHoc;
    }
}

