/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.persistence.impl.journal;

import java.nio.ByteBuffer;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.core.io.SequentialFile;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.replication.ReplicatedLargeMessage;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.LargeServerMessage;

public final class LargeServerMessageInSync
implements ReplicatedLargeMessage {
    private final LargeServerMessage mainLM;
    private final StorageManager storageManager;
    private SequentialFile appendFile;
    private boolean syncDone;
    private boolean deleted;

    public LargeServerMessageInSync(StorageManager storageManager) {
        this.mainLM = storageManager.createLargeMessage();
        this.storageManager = storageManager;
    }

    public synchronized void joinSyncedData(ByteBuffer buffer) throws Exception {
        if (this.deleted) {
            return;
        }
        SequentialFile mainSeqFile = this.mainLM.getFile();
        if (!mainSeqFile.isOpen()) {
            mainSeqFile.open();
        }
        if (this.appendFile != null) {
            int bytesRead;
            this.appendFile.close();
            this.appendFile.open();
            do {
                buffer.rewind();
                bytesRead = this.appendFile.read(buffer);
                if (bytesRead <= 0) continue;
                mainSeqFile.writeDirect(buffer, false);
            } while (bytesRead >= buffer.capacity());
            this.deleteAppendFile();
        }
        this.syncDone = true;
    }

    public SequentialFile getSyncFile() throws ActiveMQException {
        return this.mainLM.getFile();
    }

    @Override
    public Message setDurable(boolean durable) {
        this.mainLM.setDurable(durable);
        return this.mainLM;
    }

    @Override
    public synchronized Message setMessageID(long id) {
        this.mainLM.setMessageID(id);
        return this.mainLM;
    }

    @Override
    public synchronized void releaseResources() {
        this.mainLM.releaseResources();
        if (this.appendFile != null && this.appendFile.isOpen()) {
            try {
                this.appendFile.close();
            }
            catch (Exception e) {
                ActiveMQServerLogger.LOGGER.largeMessageErrorReleasingResources(e);
            }
        }
    }

    @Override
    public synchronized void deleteFile() throws Exception {
        this.deleted = true;
        try {
            this.mainLM.deleteFile();
        }
        finally {
            this.deleteAppendFile();
        }
    }

    private void deleteAppendFile() throws Exception {
        if (this.appendFile != null) {
            if (this.appendFile.isOpen()) {
                this.appendFile.close();
            }
            this.appendFile.delete();
        }
    }

    @Override
    public synchronized void addBytes(byte[] bytes) throws Exception {
        if (this.deleted) {
            return;
        }
        if (this.syncDone) {
            this.mainLM.addBytes(bytes);
            return;
        }
        if (this.appendFile == null) {
            this.appendFile = this.storageManager.createFileForLargeMessage(this.mainLM.getMessageID(), StorageManager.LargeMessageExtension.SYNC);
        }
        if (!this.appendFile.isOpen()) {
            this.appendFile.open();
        }
        this.storageManager.addBytesToLargeMessage(this.appendFile, this.mainLM.getMessageID(), bytes);
    }
}

