/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq;

import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.activemq.artemis.core.security.CheckType;
import org.apache.activemq.artemis.core.security.Role;
import org.apache.activemq.artemis.spi.core.security.ActiveMQSecurityManager;
import org.jboss.as.security.plugins.SecurityDomainContext;
import org.jboss.security.SecurityContext;
import org.jboss.security.SecurityContextAssociation;
import org.jboss.security.SecurityContextFactory;
import org.jboss.security.SimplePrincipal;
import org.wildfly.extension.messaging.activemq.DefaultCredentials;
import org.wildfly.extension.messaging.activemq.logging.MessagingLogger;

public class WildFlySecurityManager
implements ActiveMQSecurityManager {
    private SecurityDomainContext securityDomainContext;
    private String defaultUser = null;
    private String defaultPassword = null;

    public WildFlySecurityManager(SecurityDomainContext sdc) {
        this.securityDomainContext = sdc;
        this.defaultUser = DefaultCredentials.getUsername();
        this.defaultPassword = DefaultCredentials.getPassword();
    }

    public boolean validateUser(String username, String password) {
        if (this.defaultUser.equals(username) && this.defaultPassword.equals(password)) {
            return true;
        }
        if (this.securityDomainContext == null) {
            throw MessagingLogger.ROOT_LOGGER.securityDomainContextNotSet();
        }
        return this.securityDomainContext.getAuthenticationManager().isValid((Principal)new SimplePrincipal(username), (Object)password, new Subject());
    }

    public boolean validateUserAndRole(final String username, final String password, final Set<Role> roles, final CheckType checkType) {
        if (this.defaultUser.equals(username) && this.defaultPassword.equals(password)) {
            return true;
        }
        if (this.securityDomainContext == null) {
            throw MessagingLogger.ROOT_LOGGER.securityDomainContextNotSet();
        }
        final Subject subject = new Subject();
        boolean authenticated = this.securityDomainContext.getAuthenticationManager().isValid((Principal)new SimplePrincipal(username), (Object)password, subject);
        if (authenticated) {
            authenticated = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                @Override
                public Boolean run() {
                    SecurityContext securityContext;
                    SimplePrincipal principal = new SimplePrincipal(username);
                    SecurityContext currentSecurityContext = SecurityContextAssociation.getSecurityContext();
                    if (currentSecurityContext == null) {
                        try {
                            securityContext = SecurityContextFactory.createSecurityContext((Principal)principal, (Object)password, (Subject)subject, (String)WildFlySecurityManager.this.securityDomainContext.getAuthenticationManager().getSecurityDomain());
                        }
                        catch (Exception e) {
                            throw new RuntimeException(e);
                        }
                    } else {
                        securityContext = currentSecurityContext;
                        securityContext.getUtil().createSubjectInfo((Principal)principal, (Object)password, subject);
                    }
                    SecurityContextAssociation.setSecurityContext((SecurityContext)securityContext);
                    HashSet<SimplePrincipal> principals = new HashSet<SimplePrincipal>();
                    for (Role role : roles) {
                        if (!checkType.hasRole(role)) continue;
                        principals.add(new SimplePrincipal(role.getName()));
                    }
                    boolean authenticated = WildFlySecurityManager.this.securityDomainContext.getAuthorizationManager().doesUserHaveRole((Principal)new SimplePrincipal(username), principals);
                    SecurityContextAssociation.setSecurityContext((SecurityContext)currentSecurityContext);
                    return authenticated;
                }
            });
        }
        return authenticated;
    }
}

