/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.logmanager.handlers;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.OutputStream;
import org.jboss.logmanager.ExtLogRecord;
import org.jboss.logmanager.handlers.CountingOutputStream;
import org.jboss.logmanager.handlers.PeriodicRotatingFileHandler;

public class PeriodicSizeRotatingFileHandler
extends PeriodicRotatingFileHandler {
    private long rotateSize = 655360L;
    private int maxBackupIndex = 1;
    private CountingOutputStream outputStream;
    private boolean rotateOnBoot;

    public PeriodicSizeRotatingFileHandler() {
    }

    public PeriodicSizeRotatingFileHandler(String fileName) throws FileNotFoundException {
        super(fileName);
    }

    public PeriodicSizeRotatingFileHandler(String fileName, boolean append) throws FileNotFoundException {
        super(fileName, append);
    }

    public PeriodicSizeRotatingFileHandler(File file, String suffix) throws FileNotFoundException {
        super(file, suffix);
    }

    public PeriodicSizeRotatingFileHandler(File file, String suffix, boolean append) throws FileNotFoundException {
        super(file, suffix, append);
    }

    public PeriodicSizeRotatingFileHandler(File file, String suffix, long rotateSize, int maxBackupIndex) throws FileNotFoundException {
        super(file, suffix);
        this.rotateSize = rotateSize;
        this.maxBackupIndex = maxBackupIndex;
    }

    public PeriodicSizeRotatingFileHandler(File file, String suffix, long rotateSize, int maxBackupIndex, boolean append) throws FileNotFoundException {
        super(file, suffix, append);
        this.rotateSize = rotateSize;
        this.maxBackupIndex = maxBackupIndex;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setOutputStream(OutputStream outputStream) {
        Object object = this.outputLock;
        synchronized (object) {
            this.outputStream = outputStream == null ? null : new CountingOutputStream(outputStream);
            super.setOutputStream(this.outputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setFile(File file) throws FileNotFoundException {
        Object object = this.outputLock;
        synchronized (object) {
            if (this.rotateOnBoot && this.maxBackupIndex > 0 && file != null && file.exists() && file.length() > 0L) {
                this.rotate(file);
            }
            super.setFile(file);
            if (this.outputStream != null) {
                this.outputStream.currentSize = file == null ? 0L : file.length();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isRotateOnBoot() {
        Object object = this.outputLock;
        synchronized (object) {
            return this.rotateOnBoot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRotateOnBoot(boolean rotateOnBoot) {
        PeriodicSizeRotatingFileHandler.checkAccess(this);
        Object object = this.outputLock;
        synchronized (object) {
            this.rotateOnBoot = rotateOnBoot;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setRotateSize(long rotateSize) {
        PeriodicSizeRotatingFileHandler.checkAccess(this);
        Object object = this.outputLock;
        synchronized (object) {
            this.rotateSize = rotateSize;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMaxBackupIndex(int maxBackupIndex) {
        PeriodicSizeRotatingFileHandler.checkAccess(this);
        Object object = this.outputLock;
        synchronized (object) {
            this.maxBackupIndex = maxBackupIndex;
        }
    }

    @Override
    protected void preWrite(ExtLogRecord record) {
        long currentSize;
        super.preWrite(record);
        int maxBackupIndex = this.maxBackupIndex;
        long l = currentSize = this.outputStream == null ? Long.MIN_VALUE : this.outputStream.currentSize;
        if (currentSize > this.rotateSize && maxBackupIndex > 0) {
            try {
                File file = this.getFile();
                if (file == null) {
                    return;
                }
                this.setFile(null);
                this.rotate(file);
                this.setFile(file);
            }
            catch (FileNotFoundException e) {
                this.reportError("Unable to rotate log file", e, 4);
            }
        }
    }

    private void rotate(File file) {
        File fileWithSuffix = new File(file.getAbsolutePath() + this.getNextSuffix());
        new File(fileWithSuffix.getAbsolutePath() + "." + this.maxBackupIndex).delete();
        for (int i = this.maxBackupIndex - 1; i >= 1; --i) {
            new File(fileWithSuffix.getAbsolutePath() + "." + i).renameTo(new File(fileWithSuffix.getAbsolutePath() + "." + (i + 1)));
        }
        file.renameTo(new File(fileWithSuffix.getAbsolutePath() + ".1"));
    }
}

