/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Base64;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.jboss.IndexExternalizer;

public enum SessionIdentifierExternalizer implements Externalizer<String>
{
    UTF8{

        public void writeObject(ObjectOutput output, String id) throws IOException {
            output.writeUTF(id);
        }

        public String readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            return input.readUTF();
        }
    }
    ,
    BASE64{

        public void writeObject(ObjectOutput output, String id) throws IOException {
            byte[] bytes = Base64.getUrlDecoder().decode(id);
            IndexExternalizer.UNSIGNED_BYTE.writeObject(output, Integer.valueOf(bytes.length));
            output.write(bytes);
        }

        public String readObject(ObjectInput input) throws IOException, ClassNotFoundException {
            byte[] decoded = new byte[IndexExternalizer.UNSIGNED_BYTE.readObject(input).intValue()];
            input.read(decoded);
            return Base64.getUrlEncoder().encodeToString(decoded);
        }
    };


    public Class<? extends String> getTargetClass() {
        return String.class;
    }
}

