/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.web.infinispan.session;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.time.Duration;
import java.time.Instant;
import org.wildfly.clustering.marshalling.Externalizer;
import org.wildfly.clustering.marshalling.jboss.IndexExternalizer;
import org.wildfly.clustering.marshalling.jboss.InstantExternalizer;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaData;
import org.wildfly.clustering.web.infinispan.session.SessionCreationMetaDataEntry;
import org.wildfly.clustering.web.infinispan.session.SimpleSessionCreationMetaData;

public class SessionCreationMetaDataEntryExternalizer
implements Externalizer<SessionCreationMetaDataEntry<Object>> {
    private static final Externalizer<Instant> INSTANT_EXTERNALIZER = new InstantExternalizer();

    public void writeObject(ObjectOutput output, SessionCreationMetaDataEntry<Object> entry) throws IOException {
        SessionCreationMetaData metaData = entry.getMetaData();
        INSTANT_EXTERNALIZER.writeObject(output, (Object)metaData.getCreationTime());
        IndexExternalizer.VARIABLE.writeObject(output, Integer.valueOf((int)metaData.getMaxInactiveInterval().getSeconds()));
    }

    public SessionCreationMetaDataEntry<Object> readObject(ObjectInput input) throws IOException, ClassNotFoundException {
        SimpleSessionCreationMetaData metaData = new SimpleSessionCreationMetaData((Instant)INSTANT_EXTERNALIZER.readObject(input));
        metaData.setMaxInactiveInterval(Duration.ofSeconds(IndexExternalizer.VARIABLE.readObject(input).intValue()));
        return new SessionCreationMetaDataEntry<Object>(metaData);
    }

    public Class getTargetClass() {
        return SessionCreationMetaDataEntry.class;
    }
}

