/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.api.jms.management;

import org.apache.activemq.artemis.utils.json.JSONArray;
import org.apache.activemq.artemis.utils.json.JSONObject;

public class JMSConnectionInfo {
    private final String connectionID;
    private final String clientAddress;
    private final long creationTime;
    private final String clientID;
    private final String username;

    public static JMSConnectionInfo[] from(String jsonString) throws Exception {
        JSONArray array = new JSONArray(jsonString);
        JMSConnectionInfo[] infos = new JMSConnectionInfo[array.length()];
        for (int i = 0; i < array.length(); ++i) {
            JMSConnectionInfo info;
            JSONObject obj = array.getJSONObject(i);
            String cid = obj.isNull("clientID") ? null : obj.getString("clientID");
            String uname = obj.isNull("principal") ? null : obj.getString("principal");
            infos[i] = info = new JMSConnectionInfo(obj.getString("connectionID"), obj.getString("clientAddress"), obj.getLong("creationTime"), cid, uname);
        }
        return infos;
    }

    private JMSConnectionInfo(String connectionID, String clientAddress, long creationTime, String clientID, String username) {
        this.connectionID = connectionID;
        this.clientAddress = clientAddress;
        this.creationTime = creationTime;
        this.clientID = clientID;
        this.username = username;
    }

    public String getConnectionID() {
        return this.connectionID;
    }

    public String getClientAddress() {
        return this.clientAddress;
    }

    public long getCreationTime() {
        return this.creationTime;
    }

    public String getClientID() {
        return this.clientID;
    }

    public String getUsername() {
        return this.username;
    }
}

