/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.uri;

import java.net.URI;
import java.util.List;
import java.util.Map;
import org.apache.activemq.artemis.api.core.TransportConfiguration;
import org.apache.activemq.artemis.api.core.client.ActiveMQClient;
import org.apache.activemq.artemis.api.core.client.ServerLocator;
import org.apache.activemq.artemis.core.remoting.impl.netty.NettyConnectorFactory;
import org.apache.activemq.artemis.core.remoting.impl.netty.TransportConstants;
import org.apache.activemq.artemis.uri.AbstractServerLocatorSchema;
import org.apache.activemq.artemis.uri.ConnectionOptions;
import org.apache.activemq.artemis.uri.TCPTransportConfigurationSchema;
import org.apache.activemq.artemis.utils.IPV6Util;
import org.apache.activemq.artemis.utils.uri.URISchema;

public class TCPServerLocatorSchema
extends AbstractServerLocatorSchema {
    public String getSchemaName() {
        return "tcp";
    }

    protected ServerLocator internalNewObject(URI uri, Map<String, String> query, String name) throws Exception {
        ConnectionOptions options = this.newConnectionOptions(uri, query);
        List<TransportConfiguration> configurations = TCPTransportConfigurationSchema.getTransportConfigurations(uri, query, TransportConstants.ALLOWABLE_CONNECTOR_KEYS, name, NettyConnectorFactory.class.getName());
        TransportConfiguration[] tcs = new TransportConfiguration[configurations.size()];
        configurations.toArray(tcs);
        if (options.isHa()) {
            return ActiveMQClient.createServerLocatorWithHA(tcs);
        }
        return ActiveMQClient.createServerLocatorWithoutHA(tcs);
    }

    protected URI internalNewURI(ServerLocator bean) throws Exception {
        String query = URISchema.getData(null, (Object[])new Object[]{bean});
        TransportConfiguration[] staticConnectors = bean.getStaticTransportConfigurations();
        return TCPServerLocatorSchema.getURI(query, staticConnectors);
    }

    public static URI getURI(String query, TransportConfiguration[] staticConnectors) throws Exception {
        if (staticConnectors == null || staticConnectors.length < 1) {
            throw new Exception();
        }
        StringBuilder fragment = new StringBuilder();
        for (int i = 1; i < staticConnectors.length; ++i) {
            TransportConfiguration connector = staticConnectors[i];
            Map<String, Object> params = TCPServerLocatorSchema.escapeIPv6Host(connector.getParams());
            URI extraUri = new URI("tcp", null, TCPServerLocatorSchema.getHost(params), TCPServerLocatorSchema.getPort(params), null, TCPServerLocatorSchema.createQuery(params, null), null);
            if (i > 1) {
                fragment.append(",");
            }
            fragment.append(extraUri.toASCIIString());
        }
        Map<String, Object> params = TCPServerLocatorSchema.escapeIPv6Host(staticConnectors[0].getParams());
        return new URI("tcp", null, TCPServerLocatorSchema.getHost(params), TCPServerLocatorSchema.getPort(params), null, TCPServerLocatorSchema.createQuery(params, query), fragment.toString());
    }

    private static Map<String, Object> escapeIPv6Host(Map<String, Object> params) {
        String newHost;
        String host = (String)params.get("host");
        if (host != (newHost = IPV6Util.encloseHost((String)host))) {
            params.put("host", "[" + host + "]");
        }
        return params;
    }

    private static int getPort(Map<String, Object> params) {
        Object port = params.get("port");
        if (port instanceof String) {
            return Integer.valueOf((String)port);
        }
        return port != null ? (Integer)port : 61616;
    }

    private static String getHost(Map<String, Object> params) {
        return params.get("host") != null ? (String)params.get("host") : "localhost";
    }

    private static String createQuery(Map<String, Object> params, String query) {
        StringBuilder cb = query == null ? new StringBuilder() : new StringBuilder(query);
        for (String param : params.keySet()) {
            if (cb.length() > 0) {
                cb.append("&");
            }
            cb.append(param).append("=").append(params.get(param));
        }
        return cb.toString();
    }
}

