/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.driver.registry;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.services.driver.InstalledDriver;
import org.jboss.as.connector.services.driver.registry.DriverRegistry;

public class DriverRegistryImpl
implements DriverRegistry {
    private final Map<String, HashMap<String, InstalledDriver>> drivers = new HashMap<String, HashMap<String, InstalledDriver>>();
    private static final String DEFAULT_PROFILE = "default";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void registerInstalledDriver(InstalledDriver driver) throws IllegalArgumentException {
        if (driver == null) {
            throw new IllegalArgumentException(ConnectorLogger.ROOT_LOGGER.nullVar("driver"));
        }
        ConnectorLogger.DEPLOYMENT_CONNECTOR_REGISTRY_LOGGER.tracef("Adding driver: %s", driver);
        String profile = driver.getProfile() != null ? driver.getProfile() : DEFAULT_PROFILE;
        Map<String, HashMap<String, InstalledDriver>> map = this.drivers;
        synchronized (map) {
            HashMap<String, InstalledDriver> driversInProfile = this.drivers.get(profile) == null ? new HashMap<String, InstalledDriver>() : this.drivers.get(profile);
            driversInProfile.put(driver.getDriverName(), driver);
            this.drivers.put(profile, driversInProfile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unregisterInstalledDriver(InstalledDriver driver) {
        if (driver == null) {
            throw new IllegalArgumentException(ConnectorLogger.ROOT_LOGGER.nullVar("driver"));
        }
        ConnectorLogger.DEPLOYMENT_CONNECTOR_REGISTRY_LOGGER.tracef("Removing deployment: %s", driver);
        String profile = driver.getProfile() != null ? driver.getProfile() : DEFAULT_PROFILE;
        Map<String, HashMap<String, InstalledDriver>> map = this.drivers;
        synchronized (map) {
            HashMap<String, InstalledDriver> driversInProfile = this.drivers.get(profile);
            if (driversInProfile != null) {
                driversInProfile.remove(driver.getDriverName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<InstalledDriver> getInstalledDrivers(String profileName) {
        HashSet<InstalledDriver> installedDrivers = new HashSet<InstalledDriver>();
        Map<String, HashMap<String, InstalledDriver>> map = this.drivers;
        synchronized (map) {
            if (profileName != null) {
                if (this.drivers.get(profileName) != null) {
                    installedDrivers.addAll(this.drivers.get(profileName).values());
                }
            } else if (this.drivers.get(DEFAULT_PROFILE) == null) {
                throw ConnectorLogger.ROOT_LOGGER.noDriverDefinedInDefaultProfile();
            }
            if (this.drivers.get(DEFAULT_PROFILE) != null) {
                installedDrivers.addAll(this.drivers.get(DEFAULT_PROFILE).values());
            }
        }
        return Collections.unmodifiableSet(installedDrivers);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InstalledDriver getInstalledDriver(String name, String profileName) throws IllegalStateException {
        InstalledDriver returnValue = null;
        Map<String, HashMap<String, InstalledDriver>> map = this.drivers;
        synchronized (map) {
            if (profileName != null) {
                if (this.drivers.get(profileName) != null) {
                    returnValue = this.drivers.get(profileName).get(name);
                }
            } else if (this.drivers.get(DEFAULT_PROFILE) == null) {
                throw ConnectorLogger.ROOT_LOGGER.driverNotDefinedInDefaultProfile(name);
            }
            if (returnValue == null) {
                returnValue = this.drivers.get(DEFAULT_PROFILE).get(name);
            }
        }
        return returnValue;
    }
}

