/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.services.resourceadapters;

import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import org.jboss.as.connector.dynamicresource.ClearStatisticsHandler;
import org.jboss.as.connector.dynamicresource.StatisticsResourceDefinition;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.metadata.deployment.ResourceAdapterDeployment;
import org.jboss.as.connector.services.mdr.AS7MetadataRepository;
import org.jboss.as.connector.subsystems.common.pool.PoolMetrics;
import org.jboss.as.connector.subsystems.resourceadapters.CommonAttributes;
import org.jboss.as.connector.subsystems.resourceadapters.IronJacamarResource;
import org.jboss.as.connector.subsystems.resourceadapters.IronJacamarResourceCreator;
import org.jboss.as.connector.subsystems.resourceadapters.IronJacamarResourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ResourceBuilder;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.descriptions.OverrideDescriptionProvider;
import org.jboss.as.controller.descriptions.StandardResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.jboss.jca.core.api.connectionmanager.pool.PoolStatistics;
import org.jboss.jca.core.api.management.AdminObject;
import org.jboss.jca.core.api.management.ConnectionFactory;
import org.jboss.jca.core.connectionmanager.ConnectionManager;
import org.jboss.jca.core.spi.statistics.StatisticsPlugin;
import org.jboss.jca.deployers.common.CommonDeployment;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class IronJacamarActivationResourceService
implements Service<ManagementResourceRegistration> {
    private static PathElement SUBSYSTEM_PATH_ELEMENT = PathElement.pathElement((String)"subsystem", (String)"resource-adapters");
    private static PathElement IJ_PATH_ELEMENT = PathElement.pathElement((String)"ironjacamar", (String)"ironjacamar");
    private final ManagementResourceRegistration registration;
    private final Resource deploymentResource;
    private final boolean statsEnabled;
    protected final InjectedValue<ResourceAdapterDeployment> deployment = new InjectedValue();
    protected final InjectedValue<AS7MetadataRepository> mdr = new InjectedValue();

    public IronJacamarActivationResourceService(ManagementResourceRegistration registration, Resource deploymentResource, boolean statsEnabled) {
        this.registration = registration;
        this.deploymentResource = deploymentResource;
        this.statsEnabled = statsEnabled;
    }

    public void start(StartContext context) throws StartException {
        IronJacamarResource.IronJacamarRuntimeResource subsystemResource;
        ManagementResourceRegistration ijRegistration;
        ManagementResourceRegistration subRegistration;
        CommonDeployment deploymentMD = ((ResourceAdapterDeployment)this.deployment.getValue()).getDeployment();
        ConnectorLogger.ROOT_LOGGER.debugf("Starting IronJacamarActivationResourceService %s", deploymentMD.getDeploymentName());
        try {
            ResourceBuilder resourceBuilder = ResourceBuilder.Factory.create((PathElement)SUBSYSTEM_PATH_ELEMENT, (StandardResourceDescriptionResolver)new StandardResourceDescriptionResolver("statistics", CommonAttributes.RESOURCE_NAME, CommonAttributes.class.getClassLoader()));
            subRegistration = this.registration.registerSubModel(resourceBuilder.build());
        }
        catch (IllegalArgumentException iae) {
            subRegistration = this.registration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{SUBSYSTEM_PATH_ELEMENT}));
        }
        try {
            ijRegistration = subRegistration.registerSubModel((ResourceDefinition)new IronJacamarResourceDefinition());
        }
        catch (IllegalArgumentException iae) {
            ijRegistration = subRegistration.getSubModel(PathAddress.pathAddress((String)"ironjacamar", (String)"ironjacamar"));
        }
        try {
            if (this.deploymentResource != null) {
                PathElement peLocalStats = PathElement.pathElement((String)"statistics", (String)"extended");
                if (deploymentMD.getConnector() != null && deploymentMD.getConnector().getResourceAdapter() != null) {
                    ManagementResourceRegistration overrideCdRegistration;
                    ManagementResourceRegistration cdRegistration;
                    StatisticsPlugin extendStats;
                    PathElement peCdStats;
                    PathElement peCD;
                    ManagementResourceRegistration raRegistration = ijRegistration.getSubModel(PathAddress.EMPTY_ADDRESS.append(new PathElement[]{PathElement.pathElement((String)"resource-adapter")})).registerOverrideModel(deploymentMD.getDeploymentName(), new OverrideDescriptionProvider(){

                        public Map<String, ModelNode> getAttributeOverrideDescriptions(Locale locale) {
                            return Collections.emptyMap();
                        }

                        public Map<String, ModelNode> getChildTypeOverrideDescriptions(Locale locale) {
                            return Collections.emptyMap();
                        }
                    });
                    ResourceBuilder resourceBuilder = ResourceBuilder.Factory.create((PathElement)peLocalStats, (StandardResourceDescriptionResolver)new StandardResourceDescriptionResolver("statistics.workmanager", CommonAttributes.RESOURCE_NAME, CommonAttributes.class.getClassLoader()));
                    ManagementResourceRegistration raStatsSubRegistration = raRegistration.registerSubModel(resourceBuilder.build());
                    if (deploymentMD.getConnector().getResourceAdapter().getStatistics() != null) {
                        StatisticsPlugin raStats = deploymentMD.getConnector().getResourceAdapter().getStatistics();
                        raStats.setEnabled(this.statsEnabled);
                        PoolMetrics.ParametrizedPoolMetricsHandler handler = new PoolMetrics.ParametrizedPoolMetricsHandler(raStats);
                        for (AttributeDefinition attribute : StatisticsResourceDefinition.getAttributesFromPlugin(raStats)) {
                            raStatsSubRegistration.registerMetric(attribute, (OperationStepHandler)handler);
                        }
                        raStatsSubRegistration.registerOperationHandler(ClearStatisticsHandler.DEFINITION, (OperationStepHandler)new ClearStatisticsHandler(raStats));
                    }
                    if (deploymentMD.getConnector() != null && deploymentMD.getConnector().getConnectionFactories() != null) {
                        for (ConnectionFactory cf : deploymentMD.getConnector().getConnectionFactories()) {
                            if (cf.getManagedConnectionFactory() == null || cf.getManagedConnectionFactory().getStatistics() == null) continue;
                            peCD = PathElement.pathElement((String)"connection-definitions", (String)cf.getJndiName());
                            peCdStats = PathElement.pathElement((String)"statistics", (String)"extended");
                            extendStats = cf.getManagedConnectionFactory().getStatistics();
                            extendStats.setEnabled(this.statsEnabled);
                            if (extendStats.getNames().size() == 0 || extendStats.getNames().size() == 0) continue;
                            cdRegistration = raRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{peCD}));
                            overrideCdRegistration = cdRegistration.registerOverrideModel(cf.getJndiName(), new OverrideDescriptionProvider(){

                                public Map<String, ModelNode> getAttributeOverrideDescriptions(Locale locale) {
                                    return Collections.emptyMap();
                                }

                                public Map<String, ModelNode> getChildTypeOverrideDescriptions(Locale locale) {
                                    return Collections.emptyMap();
                                }
                            });
                            if (extendStats.getNames().size() == 0 || overrideCdRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{peCdStats})) != null) continue;
                            overrideCdRegistration.registerSubModel((ResourceDefinition)new StatisticsResourceDefinition(peCdStats, CommonAttributes.RESOURCE_NAME, extendStats));
                        }
                    }
                    if (deploymentMD.getConnectionManagers() != null) {
                        for (ConnectionManager cm : deploymentMD.getConnectionManagers()) {
                            if (cm.getPool() == null) continue;
                            PathElement peCD2 = PathElement.pathElement((String)"connection-definitions", (String)cm.getJndiName());
                            PathElement peCdStats2 = PathElement.pathElement((String)"statistics", (String)"pool");
                            PoolStatistics poolStats = cm.getPool().getStatistics();
                            poolStats.setEnabled(this.statsEnabled);
                            if (poolStats.getNames().size() == 0) continue;
                            ManagementResourceRegistration cdRegistration2 = raRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{peCD2}));
                            ManagementResourceRegistration overrideCdRegistration2 = cdRegistration2.registerOverrideModel(cm.getJndiName(), new OverrideDescriptionProvider(){

                                public Map<String, ModelNode> getAttributeOverrideDescriptions(Locale locale) {
                                    return Collections.emptyMap();
                                }

                                public Map<String, ModelNode> getChildTypeOverrideDescriptions(Locale locale) {
                                    return Collections.emptyMap();
                                }
                            });
                            if (poolStats.getNames().size() == 0 || overrideCdRegistration2.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{peCdStats2})) != null) continue;
                            overrideCdRegistration2.registerSubModel((ResourceDefinition)new StatisticsResourceDefinition(peCdStats2, CommonAttributes.RESOURCE_NAME, (StatisticsPlugin)poolStats));
                        }
                    }
                    if (deploymentMD.getConnector() != null && deploymentMD.getConnector().getAdminObjects() != null) {
                        for (AdminObject ao : deploymentMD.getConnector().getAdminObjects()) {
                            if (ao.getStatistics() == null) continue;
                            peCD = PathElement.pathElement((String)"admin-objects", (String)ao.getJndiName());
                            peCdStats = PathElement.pathElement((String)"statistics", (String)"extended");
                            extendStats = ao.getStatistics();
                            extendStats.setEnabled(this.statsEnabled);
                            if (extendStats.getNames().size() == 0 || extendStats.getNames().size() == 0) continue;
                            cdRegistration = raRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{peCD}));
                            overrideCdRegistration = cdRegistration.registerOverrideModel(ao.getJndiName(), new OverrideDescriptionProvider(){

                                public Map<String, ModelNode> getAttributeOverrideDescriptions(Locale locale) {
                                    return Collections.emptyMap();
                                }

                                public Map<String, ModelNode> getChildTypeOverrideDescriptions(Locale locale) {
                                    return Collections.emptyMap();
                                }
                            });
                            if (extendStats.getNames().size() == 0 || overrideCdRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{peCdStats})) != null) continue;
                            overrideCdRegistration.registerSubModel((ResourceDefinition)new StatisticsResourceDefinition(peCdStats, CommonAttributes.RESOURCE_NAME, extendStats));
                        }
                    }
                }
            }
        }
        catch (IllegalArgumentException peLocalStats) {
            // empty catch block
        }
        if (!this.deploymentResource.hasChild(SUBSYSTEM_PATH_ELEMENT)) {
            subsystemResource = new IronJacamarResource.IronJacamarRuntimeResource();
            this.deploymentResource.registerChild(SUBSYSTEM_PATH_ELEMENT, (Resource)subsystemResource);
        } else {
            subsystemResource = this.deploymentResource.getChild(SUBSYSTEM_PATH_ELEMENT);
        }
        IronJacamarResourceCreator.INSTANCE.execute((Resource)subsystemResource, (AS7MetadataRepository)this.mdr.getValue());
    }

    public void stop(StopContext context) {
        ManagementResourceRegistration subsystemResourceRegistration = this.registration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{SUBSYSTEM_PATH_ELEMENT}));
        if (subsystemResourceRegistration != null) {
            if (subsystemResourceRegistration.getSubModel(PathAddress.pathAddress((PathElement[])new PathElement[]{IJ_PATH_ELEMENT})) != null) {
                subsystemResourceRegistration.unregisterSubModel(IJ_PATH_ELEMENT);
            }
            this.registration.unregisterSubModel(SUBSYSTEM_PATH_ELEMENT);
        }
        this.deploymentResource.removeChild(SUBSYSTEM_PATH_ELEMENT);
    }

    public ManagementResourceRegistration getValue() throws IllegalStateException, IllegalArgumentException {
        return this.registration;
    }

    public Injector<AS7MetadataRepository> getMdrInjector() {
        return this.mdr;
    }

    public Injector<ResourceAdapterDeployment> getResourceAdapterDeploymentInjector() {
        return this.deployment;
    }
}

