/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui.component;

import javax.swing.JTextPane;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;

public class CLIOutput
extends JTextPane {
    public CLIOutput() {
        super.setEditable(false);
    }

    @Override
    public void setEditable(boolean b) {
    }

    public void postCommandWithResponse(String command, String response) {
        this.postAttributed(response + "\n\n", null);
        this.postBold(command + "\n");
    }

    public void post(String text) {
        this.postAttributed(text, null);
    }

    public int postAt(String text, int position) {
        return this.postAttributed(text, position, null);
    }

    public void postBold(String text) {
        this.postBoldAt(text, 0);
    }

    public int postBoldAt(String text, int position) {
        SimpleAttributeSet attribs = new SimpleAttributeSet();
        StyleConstants.setBold(attribs, true);
        return this.postAttributed(text, position, attribs);
    }

    public void postAttributed(String text, AttributeSet attribs) {
        this.postAttributed(text, 0, attribs);
    }

    public int postAttributed(String text, int position, AttributeSet attribs) {
        Document doc = this.getDocument();
        this.setCaretPosition(position);
        try {
            doc.insertString(position, text, attribs);
            this.repaint();
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return this.getCaretPosition();
    }
}

